/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class OCMakeFunctionVirtualFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private boolean isPure;

    public OCMakeFunctionVirtualFix(OCFunctionSymbol symbol, boolean pure) {
        super(symbol);
        this.isPure = pure;
    }

    @Override
    protected boolean isAvailable(OCFunctionSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol) && symbol.getParent() != null && !symbol.isCppConstructor() && !symbol.isFriendOrStatic();
    }

    @Override
    protected String getTextInternal(OCFunctionSymbol symbol) {
        return "Make " + symbol.getNameWithKindLowercase() + (this.isPure ? " pure virtual" : " virtual");
    }

    @NotNull
    public String getFamilyName() {
        return "Make function virtual";
    }

    @Override
    protected void invoke(OCFunctionSymbol symbol) {
        OCFunctionDeclaration function = symbol.locateFunctionDefinition();
        if (function != null) {
            int offset;
            if (this.isPure) {
                offset = function.getDeclarator().getTextRange().getEndOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "= 0", false);
            }
            if (!symbol.isVirtual()) {
                offset = function.getTextRange().getStartOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "virtual ", false);
            }
        }
    }
}

