/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFixBase;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMakePropertyDynamicQuickFix
extends OCSynthesizePropertyQuickFixBase
implements LowPriorityAction {
    public OCMakePropertyDynamicQuickFix(OCImplementationSymbol implementationSymbol, OCPropertySymbol property) {
        super(implementationSymbol, property);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            return "Invalid";
        }
        return "Make " + this.myProperty.getNameWithKindLowercase() + " @dynamic";
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateIvarsActionContext context) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCClassDeclarationBase decl = (OCClassDeclarationBase)this.myImplementationSymbol.locateDefinition();
        if (!(decl instanceof OCImplementation) || !FileModificationService.getInstance().prepareFileForWrite(decl.getContainingFile())) {
            return;
        }
        OCImplementation implementation = (OCImplementation)decl;
        OCSynthesizePropertiesList declaration2 = OCElementFactory.synthesizeList("@dynamic", this.myProperty.getName(), null, (PsiElement)file2);
        OCInstanceVariablesList ivars = implementation.getInstanceVariablesList();
        implementation.addBefore(declaration2, ivars.getNextSibling());
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            CommandProcessor.getInstance().addAffectedFiles(project2, new VirtualFile[]{virtualFile});
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

