/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCRemoveExtraInitializersIntentionAction
extends OCPsiElementsQuickFix {
    private int myStartIndex;

    public OCRemoveExtraInitializersIntentionAction(List<? extends PsiElement> initializers, int startIndex) {
        super(initializers);
        this.myStartIndex = startIndex;
    }

    @Override
    protected String getTextInternal() {
        return "Remove extra initializers";
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    public boolean isAvailable() {
        return this.myElementPointers != null && this.myElementPointers.size() > this.myStartIndex && OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file2) {
        for (int i2 = this.myElementPointers.size() - 1; i2 >= this.myStartIndex; --i2) {
            PsiElement element = ((SmartPsiElementPointer)this.myElementPointers.get(i2)).getElement();
            if (element == null) continue;
            OCChangeUtil.delete(element);
        }
    }
}

