/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OCRemoveTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private OCElementType myModifier;

    public OCRemoveTypeModifierIntentionAction(OCSymbolWithQualifiedName symbol, OCElementType modifier) {
        super(symbol);
        this.myModifier = modifier;
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return "Make " + this.getSubject(symbol) + " non-" + this.myModifier.getName();
    }

    @NotNull
    public String getFamilyName() {
        return "Remove '" + this.myModifier.getName() + "'";
    }

    protected String getSubject(OCSymbol symbol) {
        return symbol.getNameWithKindLowercase();
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        if (!OCSearchScope.isInProjectSources(symbol) || !OCCodeInsightUtil.isValid(symbol.locateDefinition())) {
            return false;
        }
        if (!(this.myModifier != OCTokenTypes.CONST_KEYWORD || ((OCDeclaratorSymbol)symbol).isConst() && symbol.getKind() != OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.BLOCK_KEYWORD || ((OCDeclaratorSymbol)symbol).isBlockModifiable();
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        symbol.processSameSymbols((Processor<OCSymbol>)collector);
        List psiSmartPointers = collector.getResults().stream().map(OCSymbol::locateDefinition).filter(Objects::nonNull).map(OCElementUtil::createPsiElementPointer).collect(Collectors.toList());
        for (SmartPsiElementPointer pointer : psiSmartPointers) {
            OCTypeElement typeElement;
            PsiElement element = pointer.getElement();
            if (element == null || this.findAndRemove(element) || !(element instanceof OCDeclarator) || !(element.getParent() instanceof OCDeclaration) || (typeElement = ((OCDeclaration)element.getParent()).getTypeElement()) == null || this.findAndRemove(typeElement)) continue;
            this.findAndRemove(typeElement.getParent());
        }
    }

    private boolean findAndRemove(PsiElement element) {
        ASTNode[] children2 = element.getNode().getChildren(null);
        for (int i2 = children2.length - 1; i2 >= 0; --i2) {
            if (children2[i2].getElementType() != this.myModifier) continue;
            PsiElement psi = children2[i2].getPsi();
            if (psi != null) {
                OCChangeUtil.delete(psi);
            }
            return true;
        }
        return false;
    }
}

