/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSynthesizePropertyQuickFixBase
extends OCGenerateIvarsHandler
implements IntentionAction {
    protected OCImplementationSymbol myImplementationSymbol;
    protected OCPropertySymbol myProperty;

    public OCSynthesizePropertyQuickFixBase(OCImplementationSymbol implementationSymbol, OCPropertySymbol property) {
        this.myImplementationSymbol = implementationSymbol;
        this.myProperty = property;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            return "Invalid";
        }
        return "Synthesize " + this.myProperty.getNameWithKindLowercase();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.myImplementationSymbol) && this.myProperty != null;
    }

    @Override
    protected OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myProperty;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
        return this.myImplementationSymbol;
    }

    @Override
    protected boolean replaceAllProperties() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }
}

