/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCExtractMethodHandler;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.move.OCCodeMoveValidator;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OCExtractMethodProcessor {
    private OCDataFlowAnalyzer analyzer;
    private OCChangeSignatureHandler handler;
    private DataContext dataContext;
    private OCCallableKind callableKind;
    private Project project;
    private TextRange selection;
    private PsiElement firstElement;
    private PsiElement[] elements;
    private OCType parentReturnType;
    private boolean nonVoidParentReturnType;
    private boolean hasExitNodes;
    private boolean hasStatementsAfter;
    private OCCallable parentCallable;
    private OCSymbol parentCallableSymbol;

    OCExtractMethodProcessor(PsiElement[] elements, Project project2, TextRange selection, DataContext dataContext) {
        this.elements = elements;
        this.project = project2;
        this.selection = selection;
        this.dataContext = dataContext;
    }

    public void invoke(Editor editor) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.extractMethod");
        if (this.elements.length == 0) {
            return;
        }
        this.firstElement = this.elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.project, (PsiElement)this.firstElement)) {
            return;
        }
        if (!this.analyze(editor)) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.handler.setName("");
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.handleInputOutputVars());
        this.handler.getGeneratedInfo().runOnSuccess(() -> {
            List<OCCallable> newMethods = this.handler.getNewCallables();
            if (newMethods != null && !newMethods.isEmpty()) {
                for (PsiElement element : this.elements) {
                    if (!element.isValid()) continue;
                    OCChangeUtil.deleteUnsafe(element);
                }
                if (this.callableKind == OCCallableKind.BLOCK) {
                    this.extractBlockParameter((OCBlockExpression)this.handler.getChangeInfo().getMethod());
                }
            }
        });
        this.handler.invoke();
    }

    private boolean analyze(Editor editor) {
        OCCallable<OCMethodSymbol> methodStub;
        this.parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)this.firstElement, (Class[])new Class[]{OCMethod.class, OCFunctionDefinition.class});
        if (this.parentCallable == null) {
            this.parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)this.firstElement, (Class[])new Class[]{OCBlockExpression.class, OCLambdaExpression.class});
        }
        if (this.parentCallable == null) {
            return false;
        }
        this.parentCallableSymbol = this.parentCallable.getSymbol();
        OCSymbol parentClass = null;
        boolean isStatic = false;
        this.callableKind = (OCCallableKind)((Object)OCChangeSignatureActionHandler.CALLABLE_KIND.getData(this.dataContext));
        this.parentReturnType = null;
        if (this.callableKind == null) {
            OCCallableKind oCCallableKind = this.callableKind = this.parentCallable instanceof OCMethod ? OCCallableKind.METHOD : OCCallableKind.FUNCTION;
        }
        if (this.parentCallableSymbol instanceof OCMethodSymbol && this.callableKind != OCCallableKind.BLOCK) {
            parentClass = (OCSymbol)((OCMethodSymbol)this.parentCallableSymbol).getParent();
            String signature = (((OCMethodSymbol)this.parentCallableSymbol).isStatic() ? "+" : "-") + "(void) f";
            methodStub = OCElementFactory.methodFromSignature(signature, this.parentCallable.getParent(), true, false);
        } else {
            String qualifier = "";
            if (this.parentCallableSymbol instanceof OCSymbolWithQualifiedName) {
                String fullName = ((OCSymbolWithQualifiedName)this.parentCallableSymbol).getQualifiedName().getNameWithParent();
                int index = fullName.lastIndexOf("::");
                qualifier = index > 0 ? fullName.substring(0, index + 2) : "";
            }
            String signature = "void " + qualifier + "f()";
            if (this.canBeConst()) {
                signature = signature + " const";
            }
            if (this.parentCallableSymbol != null && this.parentCallableSymbol.getType().isVolatile()) {
                signature = signature + " volatile";
            }
            methodStub = (OCCallable)OCElementFactory.topLevelDeclarationFromText(signature + "{}", this.parentCallable.getParent());
            isStatic = this.parentCallableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)this.parentCallableSymbol).resolveIsStatic();
        }
        this.parentReturnType = this.parentCallable.getReturnType().resolve(this.parentCallable.getContainingOCFile());
        this.nonVoidParentReturnType = !this.parentReturnType.isVoid();
        PsiElement parent = OCChangeUtil.getAppropriateParent(this.callableKind.getSymbolKind(), this.firstElement);
        PsiElement insertionPoint = OCChangeUtil.getRealAnchorForInsertion(parent, this.firstElement);
        this.handler = OCChangeSignatureActionHandler.getHandler((OCCallable)methodStub, insertionPoint);
        switch (this.callableKind) {
            case METHOD: {
                this.handler.setTitle("Extract Method");
                break;
            }
            case FUNCTION: {
                this.handler.setTitle("Extract Function");
                break;
            }
            case BLOCK: {
                this.handler.setTitle("Extract Block Parameter");
                break;
            }
            case LAMBDA: {
                return false;
            }
        }
        this.handler.setHelpId("refactoring.extractMethod");
        this.handler.setRefactorButtonText("Extract");
        this.handler.setCallableKind(this.callableKind);
        if (this.callableKind == OCCallableKind.BLOCK) {
            this.prepareBlockParameter();
        }
        PsiElement element = this.firstElement;
        PsiElement prevElement = OCElementUtil.getPrevSiblingOrParentSibling(element);
        while (prevElement instanceof OCMacroCall) {
            element = prevElement;
            prevElement = OCElementUtil.getPrevSiblingOrParentSibling(element);
        }
        this.handler.setChangeUsages(false);
        this.handler.getGeneratedInfo().setMethodReference(PsiTreeUtil.prevLeaf((PsiElement)element));
        this.handler.getGeneratedInfo().setMethodParent(parentClass, true, Collections.emptyList());
        this.handler.getGeneratedInfo().setStatic(isStatic);
        this.analyzer = new OCDataFlowAnalyzer(this.parentCallable, this.selection);
        this.analyzer.buildControlFlowGraph();
        this.analyzer.analyze();
        final TextRange range = new TextRange(this.elements[this.elements.length - 1].getTextRange().getEndOffset(), this.parentCallable.getTextRange().getEndOffset());
        this.parentCallable.accept(new OCRecursiveVisitor(range){

            @Override
            public void visitStatement(OCStatement stmt) {
                super.visitStatement(stmt);
                if (range.contains(stmt.getTextRange())) {
                    OCExtractMethodProcessor.this.hasStatementsAfter = true;
                }
            }
        });
        String message2 = this.checkValidity();
        if (message2 != null) {
            CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)editor, (String)message2, (String)OCExtractMethodHandler.REFACTORING_NAME, null);
            return false;
        }
        return true;
    }

    private OCParameterInfo addParameter(List<OCSymbol> parameters2, Map<OCSymbol, OCParameterInfo> paramsMap, OCSymbol var, boolean isReferenceMode, boolean wasNonConstUsage) {
        String selectorName;
        int paramIndex;
        if (paramsMap.containsKey(var)) {
            this.handler.removeParameter(var.getName(), false);
            paramsMap.remove(var);
            paramIndex = parameters2.indexOf(var);
            parameters2.set(paramIndex, var);
            selectorName = var.getName();
        } else {
            paramIndex = parameters2.size();
            parameters2.add(var);
            selectorName = paramIndex == 0 ? "" : var.getName();
        }
        OCType type2 = OCTypeUtils.getExtractExpressionType(var.getType(), this.parentCallable, wasNonConstUsage, isReferenceMode);
        if (type2 instanceof OCCppReferenceType) {
            isReferenceMode = false;
        }
        OCParameterInfo param = this.handler.addParameter(selectorName, var.getName(), type2, paramIndex, isReferenceMode);
        paramsMap.put(var, param);
        param.setUsages(this.analyzer.getVariableUsages(var));
        return param;
    }

    private void handleInputOutputVars() {
        ArrayList<PsiElement> newStatements = new ArrayList<PsiElement>(Arrays.asList(this.elements));
        StringBuilder callBuilder = new StringBuilder();
        ArrayList<OCSymbol> parameters2 = new ArrayList<OCSymbol>();
        HashMap<OCSymbol, OCParameterInfo> paramsMap = new HashMap<OCSymbol, OCParameterInfo>();
        List<OCSymbol> escapedDeclarators = this.analyzer.getEscapedDeclarators();
        OCReadWriteAccessDetector detector = new OCReadWriteAccessDetector();
        boolean hasReturn = false;
        if (this.hasExitNodes && this.nonVoidParentReturnType) {
            callBuilder.append("return ");
            this.setReturnType(this.parentReturnType, false, false);
            hasReturn = true;
        }
        for (OCSymbol var : this.analyzer.getInputVariables()) {
            boolean wasDereference = false;
            boolean wasNonConstUsage = false;
            for (PsiReference reference : this.analyzer.getVariableUsages(var)) {
                PsiElement parent;
                PsiElement element = reference.getElement();
                if (element instanceof OCReferenceElement && element.getParent() instanceof OCReferenceExpression && (parent = OCParenthesesUtils.topmostParenthesized((OCExpression)element.getParent()).getParent()) instanceof OCUnaryExpression && ((OCUnaryExpression)parent).isGetAddress()) {
                    wasDereference = true;
                }
                if (detector.getExpressionAccess(element) == ReadWriteAccessDetector.Access.Read && detector.canBeConstReference(element, true)) continue;
                wasNonConstUsage = true;
            }
            OCType varType = var.getType().resolve(this.parentCallable.getContainingOCFile());
            this.addParameter(parameters2, paramsMap, var, wasDereference || varType instanceof OCStructType, wasDereference || wasNonConstUsage);
        }
        if (this.firstElement instanceof OCExpression && !(this.firstElement.getParent() instanceof OCExpressionStatement)) {
            OCType expectedType;
            OCType returnType = OCExpectedTypeUtil.getExpressionType((OCExpression)this.firstElement, true);
            if ((returnType.isPointerToID() || returnType.isUnknown()) && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)this.firstElement)) != OCUnknownType.INSTANCE) {
                returnType = expectedType.resolve(this.firstElement.getContainingFile());
            }
            returnType = returnType.cloneWithAliasName(((OCExpression)this.firstElement).findBestTypeName(returnType));
            OCSymbol symbol = this.firstElement instanceof OCReferenceExpression ? ((OCReferenceExpression)this.firstElement).resolveToSymbol() : (this.firstElement instanceof OCQualifiedExpression ? ((OCQualifiedExpression)this.firstElement).resolveToSymbol() : null);
            this.setReturnType(returnType, symbol != null && symbol.isGlobal(), new OCReadWriteAccessDetector().canBeConstReference(this.firstElement, true));
            hasReturn = true;
        }
        if (this.analyzer.getOutputVariables().size() > 0) {
            if (!(this.analyzer.getOutputVariables().size() != 1 || this.firstElement instanceof OCExpression || this.hasExitNodes && this.nonVoidParentReturnType || hasReturn)) {
                this.handleOneOutputVar(newStatements, callBuilder, paramsMap, escapedDeclarators);
            } else {
                this.handleSeveralOutputVars(newStatements, parameters2, paramsMap, escapedDeclarators);
            }
        }
        this.handleOutsideDefinedVariables(newStatements, paramsMap.keySet());
        callBuilder.append("f(");
        boolean isFirst = true;
        for (OCSymbol parameter : parameters2) {
            OCParameterInfo paramInfo = (OCParameterInfo)paramsMap.get(parameter);
            callBuilder.append(isFirst ? "" : ",");
            if (paramInfo.isReferenceMode()) {
                callBuilder.append('&');
            }
            callBuilder.append(parameter.getName());
            isFirst = false;
        }
        callBuilder.append(')').append(this.firstElement instanceof OCExpression ? "" : ";");
        this.handler.getGeneratedInfo().setMethodStatements(newStatements);
        this.handler.getGeneratedInfo().setCallString(callBuilder.toString());
        ArrayList<PsiElement> beforeCallStatements = new ArrayList<PsiElement>();
        ArrayList<PsiElement> afterCallStatements = new ArrayList<PsiElement>();
        this.handleEscapedDeclarators(escapedDeclarators, beforeCallStatements);
        if (this.hasExitNodes && !this.nonVoidParentReturnType && this.hasStatementsAfter) {
            afterCallStatements.add(OCElementFactory.statementFromText("return;", (PsiElement)this.firstElement.getContainingFile()));
        }
        this.handler.getGeneratedInfo().setAfterCallStatements(afterCallStatements);
        this.handler.getGeneratedInfo().setBeforeCallStatements(beforeCallStatements);
    }

    private void setReturnType(OCType returnType, boolean isNonLocal, boolean canReturnConst) {
        OCFile file2 = this.parentCallable.getContainingOCFile();
        if (isNonLocal && OCTypeUtils.isPassableByReference(returnType.resolve(file2), false, this.parentCallable)) {
            returnType = OCCppReferenceType.to(canReturnConst ? returnType.cloneWithConstModifier(this.parentCallableSymbol.getProject()) : returnType);
        }
        this.handler.setReturnType(returnType);
        Collection<String> names = OCNameSuggester.suggestForType(returnType, this.firstElement, "get");
        if (!names.isEmpty()) {
            this.handler.setName(names.iterator().next());
        }
    }

    private void handleEscapedDeclarators(List<OCSymbol> escapedDeclarators, List<PsiElement> beforeCallStatements) {
        for (OCSymbol symbol : escapedDeclarators) {
            beforeCallStatements.add(OCElementFactory.declarationStatement(symbol.getName(), symbol.getType(), null, this.parentCallable));
        }
    }

    private void handleOneOutputVar(List<PsiElement> newStatements, StringBuilder callBuilder, Map<OCSymbol, OCParameterInfo> paramsMap, List<OCSymbol> escapedDeclarators) {
        OCReferenceElement referenceElement;
        OCSymbol var = this.analyzer.getOutputVariables().get(0);
        OCType varType = OCTypeUtils.decayType(var.getType().resolve(this.firstElement.getContainingFile()), this.project);
        this.setReturnType(varType, this.analyzer.getInputVariables().contains(var), false);
        if (this.selection.contains(var.getOffset())) {
            callBuilder.append(OCElementFactory.declarationText(var.getName(), varType, this.parentCallable));
            escapedDeclarators.remove(var);
        } else {
            callBuilder.append(var.getName());
        }
        callBuilder.append('=');
        OCReturnStatement returnStmt = (OCReturnStatement)OCElementFactory.statementFromText("return " + var.getName() + ";", (PsiElement)this.firstElement.getContainingFile());
        newStatements.add(returnStmt);
        OCParameterInfo param = paramsMap.get(var);
        if (param != null && (referenceElement = ((OCReferenceExpression)returnStmt.getExpression()).getReferenceElement()) != null) {
            param.getUsages().add(referenceElement.getReference());
        }
    }

    private void handleSeveralOutputVars(List<PsiElement> newStatements, List<OCSymbol> parameters2, Map<OCSymbol, OCParameterInfo> paramsMap, List<OCSymbol> escapedDeclarators) {
        int firstStatementIndex = 0;
        for (OCSymbol var : this.analyzer.getOutputVariables()) {
            OCStatement newStatement;
            Object declarator = var.locateDefinition();
            OCParameterInfo parameterInfo = this.addParameter(parameters2, paramsMap, var, true, true);
            if (!(declarator instanceof OCDeclarator) || !escapedDeclarators.contains(var) || (newStatement = this.removeDeclarator((OCDeclarator)declarator, parameterInfo)) == null) continue;
            newStatements.add(firstStatementIndex++, newStatement);
        }
    }

    private void handleOutsideDefinedVariables(List<PsiElement> newStatements, Set<OCSymbol> paramSymbols) {
        for (OCSymbol var : this.analyzer.getWrittenVariables()) {
            if (this.selection.contains(var.getOffset()) || paramSymbols.contains(var)) continue;
            newStatements.add(0, OCElementFactory.declarationStatement(var.getName(), var.getType(), null, this.parentCallable));
        }
    }

    @Nullable
    private OCStatement removeDeclarator(OCDeclarator declarator, OCParameterInfo parameter) {
        OCStatement statement2;
        this.handler.getGeneratedInfo().runOnSuccess(() -> OCChangeUtil.delete(declarator), 0);
        if (declarator.getInitializer() != null && (statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCStatement.class)) != null) {
            OCStatement assignment = OCElementFactory.statementFromText(declarator.getName() + "= 0;", (PsiElement)this.firstElement.getContainingFile());
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCReferenceElement referenceElement;
                OCAssignmentExpression expression2 = (OCAssignmentExpression)((OCExpressionStatement)assignment).getExpression();
                OCChangeUtil.replaceHandlingMacros(expression2.getSourceExpression(), declarator.getInitializer());
                if (parameter != null && (referenceElement = ((OCReferenceExpression)expression2.getReceiverExpression()).getReferenceElement()) != null) {
                    parameter.getUsages().add(referenceElement.getReference());
                }
            });
            return assignment;
        }
        return null;
    }

    private boolean canBeConst() {
        if (!(this.parentCallableSymbol instanceof OCFunctionSymbol) || ((OCFunctionSymbol)this.parentCallableSymbol).resolveIsStatic()) {
            return false;
        }
        final OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)this.parentCallableSymbol).getResolvedOwner();
        if (!(parent instanceof OCStructSymbol)) {
            return false;
        }
        final Ref canBeConst = new Ref((Object)true);
        for (PsiElement element : this.elements) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitQualifiedExpression(OCQualifiedExpression expression2) {
                    super.visitQualifiedExpression(expression2);
                    this.check(expression2);
                }

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    this.check(expression2);
                }

                @Override
                public void visitCallExpression(OCCallExpression expression2) {
                    OCFunctionSymbol functionSymbol;
                    super.visitCallExpression(expression2);
                    OCSymbol symbol = OCGetSymbolVisitor.getSymbol(expression2.getFunctionReferenceExpression());
                    if (symbol instanceof OCFunctionSymbol && OCCodeInsightUtil.isMemberAccess((OCSymbolWithQualifiedName)symbol, (OCStructSymbol)parent, expression2.getFunctionReferenceExpression()) && !(functionSymbol = (OCFunctionSymbol)symbol).isConst() && !functionSymbol.isCppConstructor() && !functionSymbol.resolveIsStatic() && !functionSymbol.isCppNonMemberOperator(new OCResolveContext(expression2))) {
                        canBeConst.set((Object)false);
                    }
                }

                private void check(OCExpression expression2) {
                    OCSymbol symbol = OCGetSymbolVisitor.getSymbol(expression2);
                    if (new OCReadWriteAccessDetector().getExpressionAccess(expression2) != ReadWriteAccessDetector.Access.Read && symbol instanceof OCDeclaratorSymbol && OCCodeInsightUtil.isNonStaticFieldAccess((OCDeclaratorSymbol)symbol, (OCStructSymbol)parent, expression2)) {
                        canBeConst.set((Object)false);
                    }
                }
            });
        }
        return (Boolean)canBeConst.get();
    }

    private void prepareBlockParameter() {
        this.handler.setNameVisible(true);
        OCCodeMoveValidator validator = new OCCodeMoveValidator(null);
        for (PsiElement element : this.elements) {
            element.accept((PsiElementVisitor)validator);
        }
        if (this.parentCallableSymbol instanceof OCMethodSymbol && !((OCMethodSymbol)this.parentCallableSymbol).isStatic() && validator.isOutOfScope() && ContainerUtil.exists(this.getParentMethodUsages(), info -> {
            PsiElement element = info.getElement();
            if (!(info instanceof OCMethodCallUsage) || !(element instanceof OCSendMessageExpression)) {
                return false;
            }
            OCExpression receiver2 = ((OCSendMessageExpression)element).getReceiverExpression();
            return !(receiver2 instanceof OCReferenceExpression) || ((OCReferenceExpression)receiver2).getSelfSuperToken() == null;
        })) {
            this.handler.addSelfParameter(((OCClassSymbol)((OCMethodSymbol)this.parentCallableSymbol).getParent()).getName());
        }
    }

    private void extractBlockParameter(OCBlockExpression block) {
        SmartPsiElementPointer blockPtr = SmartPointerManager.getInstance((Project)block.getProject()).createSmartPsiElementPointer((PsiElement)block);
        OCChangeSignatureHandler parentHandler = OCChangeSignatureActionHandler.getHandler(this.parentCallable, this.handler.getMethodDescriptor().getMethod(), false, true, !ApplicationManager.getApplication().isUnitTestMode(), false);
        String blockName = this.handler.getChangeInfo().getNewName();
        OCParameterInfo parameterInfo = parentHandler.addParameter("withBlock", blockName, block.getResolvedType(), -1, false);
        parameterInfo.setArgumentValue(block.getTextWithMacros());
        parentHandler.invokeSynchronously();
        this.handler.getChangeInfo().setNewMethod(parentHandler.getChangeInfo().getMethod());
        OCBlockExpression blockElement = (OCBlockExpression)blockPtr.getElement();
        if (blockElement != null) {
            CodeStyleManager.getInstance((Project)this.project).reformat((PsiElement)blockElement);
            OCChangeUtil.replaceHandlingMacros(blockElement, OCElementFactory.expressionFromText(blockName, block)).getParent();
        }
    }

    private List<UsageInfo> getParentMethodUsages() {
        HashSet<UsageInfo> methodUsages = new HashSet<UsageInfo>();
        OCSearchUtil.findAllMemberUsages((OCSymbolWithParent)this.parentCallableSymbol, methodUsages, true, true);
        return ContainerUtil.filter(methodUsages, info -> {
            PsiElement usageElement = info.getElement();
            return info instanceof OCMethodCallUsage || info instanceof OCFunctionUsage && usageElement.getParent().getParent() instanceof OCCallExpression;
        });
    }

    @Nullable
    private String checkValidity() {
        if (!OCSearchScope.isInProjectSources(this.firstElement)) {
            return RefactoringBundle.message((String)"error.out.of.project.element.default");
        }
        String messagePrefix = "Cannot extract a " + StringUtil.toLowerCase((String)this.callableKind.toString()) + ".\n";
        OCDataFlowAnalyzer selectionAnalyzer = new OCDataFlowAnalyzer(this.elements, null);
        selectionAnalyzer.buildControlFlowGraph();
        OCUnreachableCodeFinder finder = selectionAnalyzer.getUnreachableCodeFinder();
        this.hasExitNodes = finder.isExitNodeReached();
        if (this.analyzer.hasCrossSelectionJumps() || selectionAnalyzer.hasDanglingJumps() || finder.isDeadEndReached() && this.hasExitNodes && this.hasStatementsAfter) {
            return messagePrefix + "There are multiple exit points in the selected code fragment";
        }
        if (this.callableKind == OCCallableKind.BLOCK) {
            if (this.parentCallable instanceof OCBlockExpression || this.parentCallable instanceof OCLambdaExpression) {
                return "Selected statements should be inside a function or method";
            }
            if (this.getParentMethodUsages().isEmpty()) {
                return (this.parentCallableSymbol != null ? this.parentCallableSymbol.getNameWithKindUppercase() : this.parentCallable.getKind().toString()) + " is never called";
            }
        }
        return null;
    }
}

