/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureDialog;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureActionHandler
implements ChangeSignatureHandler {
    public static final DataKey<OCCallableKind> CALLABLE_KIND = DataKey.create((String)"callable_kind");

    public PsiElement findTargetMember(PsiFile file2, Editor editor) {
        return OCElementUtil.findRenameTargetDefinition(file2.findElementAt(editor.getCaretModel().getOffset()), true);
    }

    public PsiElement findTargetMember(PsiElement element) {
        return OCElementUtil.findRenameTargetDefinition(element, true);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        OCChangeSignatureActionHandler.invoke(project2, editor, this.findTargetMember(file2, editor), (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        OCChangeSignatureActionHandler.invoke(project2, (Editor)CommonDataKeys.EDITOR.getData(dataContext), elements[0], (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return OCBundle.message("changeSignature.targetNotFound", new Object[0]);
    }

    private static void invoke(Project project2, Editor editor, PsiElement element, OCCallableKind callableKind) {
        Object symbol;
        if (element instanceof OCSymbolHolderVirtualPsiElement && (symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol()) instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)REFACTORING_NAME, null);
            return;
        }
        if (!(element instanceof OCCallable)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)OCBundle.message("changeSignature.targetNotFound", new Object[0]), (String)REFACTORING_NAME, null);
            return;
        }
        if (!OCCodeInsightUtil.isValid(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)REFACTORING_NAME, null);
            return;
        }
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)element, true);
        if (OCChangeSignatureActionHandler.checkVariableArguments(project2, editor, handler2)) {
            return;
        }
        if (callableKind != null) {
            if (((OCCallable)element).getBody() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)("Select the implementation to convert to " + (Object)((Object)callableKind)), (String)REFACTORING_NAME, null);
                return;
            }
            handler2.setCallableKind(callableKind);
        }
        handler2.invoke();
    }

    public static boolean checkVariableArguments(Project project2, Editor editor, OCChangeSignatureHandler handler2) {
        OCMethodDescriptor methodDescriptor = handler2.getMethodDescriptor();
        if (methodDescriptor == null) {
            return false;
        }
        OCSymbol symbol = methodDescriptor.getMethodSymbol();
        if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isVararg() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isVararg()) {
            String message2 = "Can't refactor a " + symbol.getKind().getNameLowercase() + " with variable arguments";
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, null);
            return true;
        }
        return false;
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, boolean isChangeCallableKindPossible) {
        return OCChangeSignatureActionHandler.getHandler(callable, callable, isChangeCallableKindPossible, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, silentMode);
    }

    private static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, isChangeCallableKindPossible, silentMode, !silentMode, false);
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode, boolean askForSuperMethods, boolean sureThatConstructor) {
        OCSearchUtil.Ancestor ancestor;
        OCSymbol symbol = callable.getSymbol();
        Project project2 = callable.getProject();
        boolean refactorAncestors = false;
        if (symbol instanceof OCSymbolWithParent && (ancestor = OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol)) != null) {
            String subject = symbol.getKind().getNameLowercase();
            String message2 = symbol.getNameWithKindUppercase() + " overrides " + subject + " in " + ancestor.getSymbol().getParent().getNameWithKindLowercase() + (ancestor.isOutOfProject() ? " which is out of project" : "");
            if (ancestor.isOutOfProject()) {
                int result2;
                if (askForSuperMethods && (result2 = Messages.showYesNoDialog((Project)project2, (String)(message2 + ". Do you want to proceed the refactoring?"), (String)"Warning", (Icon)Messages.getQuestionIcon())) != 0) {
                    return OCEmptyChangeSignatureHandler.INSTANCE;
                }
            } else {
                int result3;
                if (askForSuperMethods) {
                    result3 = Messages.showYesNoCancelDialog((Project)project2, (String)(message2 + ". Do you want to refactor the base " + subject + "s?"), (String)"Warning", (Icon)Messages.getQuestionIcon());
                } else {
                    int n = result3 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 1;
                }
                if (result3 == 0) {
                    refactorAncestors = true;
                } else if (result3 != 1) {
                    return OCEmptyChangeSignatureHandler.INSTANCE;
                }
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)callable) || context == null) {
            return OCEmptyChangeSignatureHandler.INSTANCE;
        }
        if (!callable.getContainingOCFile().getKind().isObjC()) {
            isChangeCallableKindPossible = false;
        }
        OCMethodDescriptor methodDescriptor = OCMethodDescriptor.createMethodDescriptor(callable);
        methodDescriptor.setChangeCallableKindPossible(isChangeCallableKindPossible);
        methodDescriptor.setSureIsConstructor(sureThatConstructor);
        OCChangeSignatureHandlerImpl handler2 = silentMode ? new OCChangeSignatureHandlerImpl(methodDescriptor, context) : new OCChangeSignatureDialog(project2, methodDescriptor, context).getHandler();
        handler2.setChangeAncestors(refactorAncestors);
        return handler2;
    }
}

