/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public static Key<Boolean> CHECK_CONFLICTS = Key.create((String)"CHECK_CONFLICTS");
    private OCCallableKind myCallableKind;
    private OCCallable myCallable;
    private String myCommandName;
    private OCRenameProcessor.RenameUsages myOption;

    protected OCChangeSignatureProcessor(Project project2, OCCallableKind callableKind, OCCallable callable, OCChangeInfo changeInfo, String commandName) {
        super(project2, changeInfo);
        this.myCallableKind = callableKind;
        this.myCallable = callable;
        this.myCommandName = commandName;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new OCUsageViewDescriptor(this.myCallable, RefactoringBundle.message((String)"0.to.change.signature", (Object[])new Object[]{this.myCallableKind.toString()}));
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap conflictDescriptions = new MultiMap();
        OCChangeSignatureProcessor.collectConflictsFromExtensions(refUsages, (MultiMap<PsiElement, String>)conflictDescriptions, this.myChangeInfo);
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions(usagesIn, (MultiMap<PsiElement, String>)conflictDescriptions);
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set<UsageInfo>)usagesSet);
        if (!conflictDescriptions.isEmpty() && this.myCallable.getProject().getUserData(CHECK_CONFLICTS) != Boolean.FALSE) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StringBuilder message2 = new StringBuilder();
                for (String conflict : conflictDescriptions.values()) {
                    if (message2.length() != 0) {
                        message2.append("; ");
                    }
                    message2.append(conflict);
                }
                throw new CommonRefactoringUtil.RefactoringErrorHintException(message2.toString());
            }
            ConflictsDialog dialog2 = this.prepareConflictsDialog((MultiMap<PsiElement, String>)conflictDescriptions, usagesIn);
            if (!dialog2.showAndGet()) {
                if (dialog2.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        UsageInfo[] newUsages = usagesSet.toArray(new UsageInfo[usagesSet.size()]);
        refUsages.set((Object)newUsages);
        this.prepareSuccessful();
        this.myOption = this.myChangeInfo.isNameChanged() ? OCRenameProcessor.validateUsages(this.myCallable, refUsages) : OCRenameProcessor.RenameUsages.RENAME;
        return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        return super.isPreviewUsages(usages) || this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
    }

    @Override
    @NotNull
    protected ConflictsDialog createConflictsDialog(final @NotNull MultiMap<PsiElement, String> conflicts, final UsageInfo[] usages) {
        return new ConflictsDialog(this.myProject, conflicts, null){

            @Override
            protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
                return () -> {
                    Collection usagesToRefactor = OCChangeSignatureProcessor.getNonExcludedUsageInfos(usages, usageView);
                    OCChangeSignatureProcessor.this.execute(usagesToRefactor.toArray(new UsageInfo[usagesToRefactor.size()]));
                };
            }

            @NotNull
            protected Action getOKAction() {
                Action action = super.getOKAction();
                for (String conflict : conflicts.values()) {
                    if (OCChangeSignatureUsageProcessor.canProceedWithConflict(conflict)) continue;
                    action.setEnabled(false);
                }
                return action;
            }
        };
    }

    private static Collection<? extends UsageInfo> getNonExcludedUsageInfos(UsageInfo[] usages, @Nullable UsageView usageView) {
        MultiMap result2 = MultiMap.createLinked();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            result2.putValue((Object)element, (Object)usage);
        }
        if (usageView != null) {
            for (Usage usage : usageView.getExcludedUsages()) {
                if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
                result2.remove((Object)((UsageInfo2UsageAdapter)usage).getElement());
            }
        }
        return result2.values();
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiElement method2;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.changeSignature");
        PsiFile oldContainingFile = ((OCChangeInfo)this.myChangeInfo).getOldMethodDescriptor().getMethod().getContainingFile();
        Arrays.sort(usages, (u1, u2) -> {
            int rank1 = u1 instanceof OCUsageInfo ? ((OCUsageInfo)((Object)u1)).getUsageRank() : 0;
            int rank2 = u2 instanceof OCUsageInfo ? ((OCUsageInfo)((Object)u2)).getUsageRank() : 0;
            return rank2 - rank1;
        });
        RenameUtil.renameNonCodeUsages(this.myProject, ContainerUtil.filter((Object[])usages, info -> info instanceof NonCodeUsageInfo).toArray(new NonCodeUsageInfo[0]));
        super.performRefactoring(usages);
        if (((OCChangeInfo)this.myChangeInfo).getGenerated().getMethodReference() == null && (method2 = this.myChangeInfo.getMethod()) != null && method2.isValid() && !oldContainingFile.equals(method2.getContainingFile())) {
            OCCodeInsightUtil.selectElement(method2);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll(super.getElementsToWrite(descriptor));
        elements.addAll(((OCChangeInfo)this.myChangeInfo).getGenerated().getFilesToWrite());
        return elements;
    }

    public void runSynchronously() {
        this.doRun();
    }

    @Override
    protected String getCommandName() {
        if (this.myCommandName != null) {
            return this.myCommandName;
        }
        return super.getCommandName();
    }
}

