/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterInfo
implements ParameterInfo,
Cloneable {
    private final int myOldIndex;
    private String mySelector = "";
    private String myName = "";
    private OCType myType;
    private String myTypeText;
    private boolean myEllipsisType;
    private boolean mySelfParameter;
    private Collection<PsiReference> myUsages;
    private boolean myReferenceMode;
    private String myArgumentValue;
    private final PsiElement myTypeContext;

    public OCParameterInfo(String selector2, String name, OCType type2, int oldIndex, PsiElement context) {
        this(selector2, name, type2, OCParameterInfo.getTextFromType(type2, context), oldIndex, context);
    }

    public OCParameterInfo(String selector2, String name, OCType type2, String typeText, int oldIndex, PsiElement context) {
        this.myTypeContext = context;
        this.mySelector = selector2.endsWith(":") ? selector2.substring(0, selector2.length() - 1) : selector2;
        this.myName = name != null ? name : "";
        this.myType = type2;
        this.myTypeText = typeText;
        this.myOldIndex = oldIndex;
    }

    @NotNull
    private static String getTextFromType(OCType type2, PsiElement typeContext) {
        OCPointerType pointerType;
        Integer lengthInBrackets;
        if (type2 == null) {
            return "";
        }
        if (type2.getClass().equals(OCPointerType.class) && (lengthInBrackets = (pointerType = (OCPointerType)type2).getLengthInBrackets()) != null) {
            type2 = OCArrayType.to(pointerType.getRefType(), lengthInBrackets, pointerType.getARCAttribute());
        }
        return type2.getName(typeContext);
    }

    public void setSelfParameter(boolean selfParameter) {
        this.mySelfParameter = selfParameter;
    }

    public void setEllipsisType(boolean ellipsisType) {
        this.myEllipsisType = ellipsisType;
    }

    public void setReferenceMode(boolean referenceMode) {
        this.myReferenceMode = referenceMode;
    }

    public void setArgumentValue(String argumentValue) {
        this.myArgumentValue = argumentValue;
    }

    public String getSelector() {
        return this.mySelector;
    }

    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return null;
    }

    public void setName(String name) {
        this.myName = name != null ? name : "";
    }

    public void setSelector(String selector2) {
        this.mySelector = selector2;
    }

    @Nullable
    public OCType getType() {
        return this.myType != null ? (this.myReferenceMode ? OCPointerType.to(this.myType) : this.myType) : null;
    }

    public String getTypeText() {
        if (this.myReferenceMode) {
            return this.myTypeText + "*";
        }
        return this.myTypeText;
    }

    public void setType(OCType type2) {
        this.myType = type2;
        this.myTypeText = OCParameterInfo.getTextFromType(this.myType, this.myTypeContext);
    }

    public void setTypeText(String typeText) {
        this.myTypeText = typeText;
    }

    public boolean isEllipsisType() {
        return this.myEllipsisType;
    }

    public boolean isSelfParameter() {
        return this.mySelfParameter;
    }

    public String getParameterStubText(boolean appendSelectors, boolean isSelfSuperCall, @Nullable PsiElement usageContext) {
        StringBuilder result2 = new StringBuilder();
        if (appendSelectors) {
            result2.append(this.mySelector);
            if (this.myName.isEmpty()) {
                return result2.toString();
            }
            result2.append(':');
        }
        if (isSelfSuperCall) {
            result2.append(this.myName);
        } else if (this.isSelfParameter()) {
            result2.append("self");
        } else if (this.myArgumentValue != null) {
            result2.append(this.myArgumentValue);
        } else if (this.myType instanceof OCStructType) {
            result2.append(this.myType.getDefaultValue(usageContext != null ? usageContext : this.myTypeContext));
        } else if (this.myType != null) {
            result2.append(this.myType.getDefaultValue(this.myTypeContext));
        } else {
            result2.append("0");
        }
        return result2.toString();
    }

    public boolean isTypeChanged(String oldTypeText) {
        return !oldTypeText.replaceAll(" ", "").equals(this.myTypeText.replaceAll(" ", ""));
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setUsages(Collection<PsiReference> usages) {
        this.myUsages = usages;
    }

    public Collection<PsiReference> getUsages() {
        return this.myUsages;
    }

    public boolean isReferenceMode() {
        return this.myReferenceMode;
    }

    public OCParameterInfo clone() {
        try {
            return (OCParameterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

