/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageWithContext;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratedCallUsage
extends OCUsageWithContext {
    public OCGeneratedCallUsage(@NotNull PsiElement element) {
        super(element);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project2) {
        String callString = changeInfo.getGenerated().getCallString();
        OCElement newElement = callString.endsWith(";") ? OCElementFactory.statementFromText(callString, changeInfo.getContext(), true) : OCElementFactory.expressionFromText(callString, changeInfo.getContext(), true);
        List<PsiElement> beforeStatements = changeInfo.getGenerated().getBeforeCallStatements();
        List<PsiElement> afterStatements = changeInfo.getGenerated().getAfterCallStatements();
        if (!(this.getParent() instanceof OCBlockStatement) && beforeStatements.size() + afterStatements.size() > 0) {
            PsiElement block = OCElementFactory.statementFromText("{}", changeInfo.getContext());
            block = this.addElement(block);
            this.setElement(((OCBlockStatement)block).getOpeningBrace());
        }
        for (PsiElement statement2 : beforeStatements) {
            this.addElement(statement2);
        }
        newElement = this.addElement(newElement);
        for (PsiElement statement2 : afterStatements) {
            this.addElement(statement2);
        }
        OCCallExpression call = OCGeneratedCallUsage.getCallExpression(newElement);
        OCExpression receiver2 = OCElementFactory.expressionFromText("self", changeInfo.getContext());
        PsiElement newCall = OCChangeSignatureUsageProcessor.generateCall(receiver2, call.getArguments(), changeInfo);
        newCall = OCChangeUtil.replaceHandlingMacros(call, newCall);
        if (newElement == call) {
            newElement = newCall;
        }
        if (newCall instanceof OCCallExpression && ((OCCallExpression)newCall).getFunctionReferenceExpression() instanceof OCBlockExpression) {
            OCBlockExpression block = (OCBlockExpression)((OCCallExpression)newCall).getFunctionReferenceExpression();
            changeInfo.setNewMethod(block);
            OCBindUtil.decodeContextInfo(block);
            OCBindUtil.removeRedundantQualifiers(block);
        }
        if (!changeInfo.getGenerated().isSelectMethod()) {
            Editor editor = EditorHelper.openInEditor(newElement);
            OCCodeInsightUtil.selectRange(editor, newElement.getTextOffset(), newElement.getTextOffset() + newElement.getTextLength());
        }
        return true;
    }

    @Nullable
    private static OCCallExpression getCallExpression(PsiElement element) {
        if (element instanceof OCCallExpression) {
            return (OCCallExpression)element;
        }
        if (element instanceof OCExpressionStatement) {
            OCExpression expression2 = ((OCExpressionStatement)element).getExpression();
            if (expression2 instanceof OCCallExpression) {
                return (OCCallExpression)expression2;
            }
            if (expression2 instanceof OCAssignmentExpression) {
                return (OCCallExpression)((OCAssignmentExpression)expression2).getSourceExpression();
            }
            assert (false);
        } else {
            if (element instanceof OCReturnStatement) {
                return (OCCallExpression)((OCReturnStatement)element).getExpression();
            }
            if (element instanceof OCDeclarationStatement) {
                OCDeclarator declarator = ((OCDeclarationStatement)element).getDeclaration().getDeclarators().get(0);
                return (OCCallExpression)declarator.getInitializer();
            }
            assert (false);
        }
        return null;
    }

    @Override
    public int getUsageRank() {
        return -2;
    }
}

