/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCMethodCallUsage
extends OCUsageInfo<OCSendMessageExpression> {
    public OCMethodCallUsage(@NotNull PsiReference reference) {
        super(reference);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCSendMessageExpression call, @NotNull Project project2) {
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PsiElement newCall = OCChangeSignatureUsageProcessor.generateCall(call.getReceiverExpression(), call.getArgumentExpressions(), changeInfo);
            newCall = OCChangeUtil.replaceHandlingMacros(call, newCall);
            OCImportSymbolFix.fixAllSymbolsRecursively(newCall);
        } else if (changeInfo.isNameChanged()) {
            int paramIndex = 0;
            for (OCMessageArgument argument : call.getArguments()) {
                PsiElement selector2 = argument.getArgumentSelector().getSelectorIdentifier();
                if (selector2 == null) continue;
                String selectorName = changeInfo.getNewParameters()[paramIndex++].getSelector();
                if (selectorName.isEmpty()) {
                    OCChangeUtil.delete(selector2);
                    continue;
                }
                OCElementUtil.replaceWithIdentifier(selector2, selectorName, call);
            }
            TextRange range = call.getRangeWithMacros();
            CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)call.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        }
        return true;
    }
}

