/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCCallableDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCMethodDefinitionUsage
extends OCCallableDefinitionUsage<OCMethod> {
    public OCMethodDefinitionUsage(@NotNull OCMethod element, boolean isInherited) {
        super(element, isInherited);
    }

    @Override
    public int getUsageRank() {
        return 0;
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCMethod method2, @NotNull Project project2) {
        OCTypeElement typeElement;
        if (changeInfo.isParameterSetOrOrderChanged()) {
            return super.processUsage(changeInfo, method2, project2);
        }
        if (changeInfo.isNameChanged() || changeInfo.isParameterTypesChanged()) {
            int paramIndex = 0;
            for (OCMethodSelectorPart parameter : method2.getParameters()) {
                PsiElement selectorID = parameter.getSelectorIdentifier();
                PsiElement paramID = parameter.getParameter();
                OCTypeElement typeElement2 = parameter.getTypeElement();
                OCParameterInfo newParameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (selectorID != null) {
                    if (newParameterInfo.getSelector().isEmpty()) {
                        OCChangeUtil.delete(selectorID);
                    } else {
                        OCElementUtil.replaceWithIdentifier(selectorID, newParameterInfo.getSelector(), method2);
                    }
                }
                if (paramID != null) {
                    OCElementUtil.replaceWithIdentifier(paramID, changeInfo.getNewParameterName(this.myInherited, method2, newParameterInfo), method2);
                }
                if (typeElement2 == null || !newParameterInfo.isTypeChanged(typeElement2.getTextWithMacros())) continue;
                OCChangeUtil.replaceHandlingMacros(typeElement2, OCElementFactory.typeElementFromText(newParameterInfo.getTypeText(), method2));
            }
        }
        if (changeInfo.isReturnTypeChanged() && (typeElement = method2.getReturnTypeElement()) != null) {
            OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(changeInfo.getNewReturnType(), method2));
        }
        TextRange range = method2.getHeaderRange();
        CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)method2.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        return true;
    }
}

