/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCInlineMacroHandler
extends OCInlineActionHandlerBase<OCDefineDirective> {
    @Override
    protected String getElementKind(OCDefineDirective element) {
        return "macro";
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof OCDefineDirective;
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCDefineDirective element) {
        if (PsiTreeUtil.getParentOfType((PsiElement)usage, OCDefineDirective.class) != null) {
            return "Cannot inline the macro inside another macro definition";
        }
        return null;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDefineDirective element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)usage, OCMacroCall.class);
        if (call == null || !call.isValid()) {
            return;
        }
        PsiFile file2 = call.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        assert (document != null);
        String replacementText = call.getReplacementText();
        TextRange range = call.getTextRange();
        int offset = range.getStartOffset();
        document.replaceString(offset, range.getEndOffset(), (CharSequence)replacementText);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        OCChangeUtil.reformatTextIfNotInjected(file2, offset, offset + replacementText.length());
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineMacro";
    }
}

