/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.refactoring.OCExpressionTrimRenderer;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBaseIntroduceHandler<E extends PsiElement>
implements RefactoringActionHandler {
    private Class<? extends E>[] myExpressionClasses;
    private String myExpressionKind;
    private String myRefactoringName;
    private static final NotNullFunction<PsiElement, TextRange> RANGER = dom -> OCElementUtil.getRangeWithMacros(dom);

    @SafeVarargs
    protected OCBaseIntroduceHandler(String expressionKind, String refactoringName, Class<? extends E> ... expressionClasses) {
        this.myExpressionKind = expressionKind;
        this.myRefactoringName = refactoringName;
        this.myExpressionClasses = expressionClasses;
    }

    private OccurrencesChooser<E> getOccurrenceChooser(Editor editor) {
        return new OccurrencesChooser<E>(editor){

            @Override
            protected TextRange getOccurrenceRange(E occurrence) {
                return OCElementUtil.getRangeWithMacros(occurrence);
            }
        };
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        boolean result2;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean hasSelection = selectionModel.hasSelection();
        if (!hasSelection) {
            List<E> expressions2 = this.collectElements(editor, file2);
            if (expressions2.isEmpty()) {
                selectionModel.selectLineAtCaret();
            } else if (expressions2.size() == 1) {
                TextRange expr = OCElementUtil.getRangeWithMacros((PsiElement)expressions2.get(0));
                selectionModel.setSelection(expr.getStartOffset(), expr.getEndOffset());
            } else {
                IntroduceTargetChooser.showChooser(editor, expressions2, new Pass<E>(){

                    public void pass(E selectedValue) {
                        TextRange range = OCElementUtil.getRangeWithMacros(selectedValue);
                        OCBaseIntroduceHandler.this.invoke(project2, editor, file2, range.getStartOffset(), range.getEndOffset());
                    }
                }, new OCExpressionTrimRenderer.RenderFunction(), "Expressions", RANGER);
                return;
            }
        }
        if ((result2 = this.invoke(project2, editor, file2, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())) && LookupManager.getActiveLookup(editor) == null && !hasSelection) {
            selectionModel.removeSelection();
        }
    }

    private boolean invoke(Project project2, Editor editor, PsiFile file2, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String charsToSkip = ArrayUtil.indexOf((Object[])this.myExpressionClasses, OCExpression.class) != -1 ? " \t\n;" : " \t\n";
        startOffset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)startOffset, (String)charsToSkip);
        endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)charsToSkip) + 1;
        E expression2 = this.findElementAtRange(file2, startOffset, endOffset);
        if (!OCSearchScope.isInProjectSources((PsiElement)file2)) {
            this.showErrorMessage(project2, editor, RefactoringBundle.message((String)"error.out.of.project.element.default"));
            return false;
        }
        if (expression2 == null) {
            this.showErrorMessage(project2, editor, "Selected block should represent " + this.myExpressionKind);
            return false;
        }
        return this.invoke(project2, editor, expression2, null, false, true, null, null);
    }

    @Nullable
    protected E substituteElement(E element) {
        return element;
    }

    protected List<E> collectElements(Editor editor, PsiFile file2) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (Class<? extends E> clazz : this.myExpressionClasses) {
            ArrayList curElements = new ArrayList();
            OCCodeInsightUtil.collectElements(file2, editor, editor.getCaretModel().getOffset(), clazz, curElements);
            for (PsiElement element : curElements) {
                if ((element instanceof OCReferenceExpression || element instanceof OCQualifiedExpression) && element.getParent() instanceof OCCallExpression || (element = this.substituteElement(element)) == null) continue;
                elements.add(element);
            }
            if (!elements.isEmpty()) break;
        }
        return elements;
    }

    @Nullable
    protected E findElementAtRange(PsiFile file2, int startOffset, int endOffset) {
        for (Class<E> clazz : this.myExpressionClasses) {
            Object element = OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset, clazz, true);
            if (element != null) {
                element = this.substituteElement(element);
            }
            if (element instanceof OCExpression) {
                element = OCParenthesesUtils.topmostParenthesized((OCExpression)element);
            }
            if (element == null) continue;
            return element;
        }
        return null;
    }

    protected List<E> findElementOccurrences(E expression2) {
        return OCCodeInsightUtil.findElementOccurrences(this.getElementScope(expression2), expression2);
    }

    protected void showErrorMessage(Project project2, Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)this.myRefactoringName, null);
    }

    private boolean fillChoices(E expr, List<E> occurrences, LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<E>> occurrencesMap) {
        boolean hasWriteAccess;
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(expr));
        ArrayList<PsiElement> nonWrite = new ArrayList<PsiElement>();
        for (PsiElement occurrence : occurrences) {
            if (occurrence instanceof OCExpression && OCCodeInsightUtil.isAssignmentLHS((OCExpression)occurrence)) continue;
            nonWrite.add(occurrence);
        }
        boolean bl = hasWriteAccess = occurrences.size() > nonWrite.size() && occurrences.size() > 1;
        if (hasWriteAccess && nonWrite.size() > 0) {
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO_WRITE, nonWrite);
        }
        if (occurrences.size() > 1) {
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, occurrences);
        }
        return hasWriteAccess;
    }

    protected boolean filterUsages(E expression2) {
        return !ApplicationManager.getApplication().isUnitTestMode();
    }

    public boolean invoke(Project project2, Editor editor, E expression2, @Nullable OCType exprType, boolean createFromUsageMode, boolean filterUsages, @Nullable String usageName, @Nullable OCSymbol parentSymbol) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureID());
        if (expression2 == null) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus(expression2)) {
            return false;
        }
        final List<E> occurrences = this.findElementOccurrences(expression2);
        final OCBaseInplaceIntroducer<?, E> introducer = this.createIntroducer(project2, editor, expression2, occurrences, this.myRefactoringName);
        introducer.setExprType(exprType);
        introducer.setCreateFromUsageMode(createFromUsageMode);
        introducer.setParentSymbol(parentSymbol);
        introducer.setUsageName(usageName);
        String message2 = introducer.checkExpression(expression2);
        if (message2 != null) {
            introducer.cancelIntroduce();
            this.showErrorMessage(project2, editor, message2);
            return false;
        }
        final LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
        boolean hasWriteAccess = this.fillChoices(expression2, occurrences, occurrencesMap);
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                introducer.setOccurrences(choice != null ? (Collection)occurrencesMap.get((Object)choice) : occurrences);
                PsiElement anchor = introducer.evaluateAnchor();
                if (anchor != null) {
                    introducer.setAnchor(anchor);
                    introducer.configurePanel();
                    introducer.startInplaceIntroduceTemplate();
                }
            }
        };
        if (!this.filterUsages(expression2) || !filterUsages) {
            callback.pass(null);
        } else {
            this.getOccurrenceChooser(editor).showChooser(callback, occurrencesMap);
        }
        return true;
    }

    protected PsiElement getElementScope(E element) {
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getTopmostParentOfType(element, OCBlockStatement.class);
        return block != null ? block : PsiTreeUtil.getParentOfType(element, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
    }

    protected abstract OCBaseInplaceIntroducer<?, E> createIntroducer(Project var1, Editor var2, E var3, List<E> var4, String var5);

    @NotNull
    protected abstract String getFeatureID();

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        throw new UnsupportedOperationException("invoke is not implemented");
    }
}

