/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConstantInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myStaticCB;

    public OCConstantInplaceIntroducer(Project project2, Editor editor, OCExpression expression2, List<OCExpression> occurrences, String refactoringName) {
        super(project2, editor, expression2, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(OCCodeStyleSettings.class);
        this.myStaticCB = this.createCheckBox("Declare &static", settings.INTRODUCE_STATIC_CONSTS, () -> {
            settings.INTRODUCE_STATIC_CONSTS = this.myStaticCB.isSelected();
            this.rebuildDeclaration();
        });
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            OCDeclaration newDeclaration = this.createDeclaration(declarator.getName(), declarator.getInitializer());
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), newDeclaration);
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.GLOBAL_VARIABLE;
    }

    @Override
    @Nullable
    protected String checkExpression(OCExpression expression2) {
        String message2 = this.checkType();
        if (message2 != null) {
            return message2;
        }
        if (!new OCConstantExpressionVisitor(){

            @Override
            protected boolean isConstDeclarator(OCReferenceExpression expression2, OCSymbol symbol) {
                return super.isConstDeclarator(expression2, symbol) && symbol.isGlobal();
            }
        }.isConstant(expression2)) {
            return "Selected expression cannot be a constant initializer";
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private OCDeclaration createDeclaration(String name, OCExpression initializer) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.myStaticCB.isSelected()) {
            modifiers.add("static");
        }
        String declarationText = OCElementFactory.declarationText(modifiers, name, this.myExprType.cloneWithConstModifier(this.myProject), "0", initializer, null, false);
        if ((declarationText = OCElementFactory.declarationFromText(declarationText, initializer, true).getTextWithMacros()).endsWith("0;")) {
            declarationText = declarationText.substring(0, declarationText.length() - 2) + initializer.getTextWithMacros() + ";";
        } else {
            LOG.error(declarationText);
        }
        return OCElementFactory.declarationFromText(declarationText, initializer);
    }

    private OCDeclaration doIntroduce(String name, boolean isPreview) {
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCDeclaration newDeclaration = this.createDeclaration(name, mainExpression);
        OCDeclaration added = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), newDeclaration, anchor);
        if (isPreview) {
            this.setVariable((PsiNameIdentifierOwner)added.getDeclarators().get(0));
        }
        return added;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        OCDeclaration declaration2 = this.doIntroduce(name, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration2);
        for (OCExpression expression2 : (OCExpression[])this.myOccurrences) {
            OCChangeUtil.replaceHandlingMacros(expression2, OCElementFactory.expressionFromText(name, expression2));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceConstant";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

