/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefineInplaceIntroducer
extends OCBaseInplaceIntroducer<OCDefineDirective, OCElement> {
    private PsiFile myFileCopy;
    private TextRange myExpressionRange;
    private Class myExpressionClass;

    public OCDefineInplaceIntroducer(Project project2, Editor editor, OCElement expression2, List<OCElement> occurrences, String refactoringName) {
        super(project2, editor, expression2, occurrences, OCDefineDirective.class, OCElement.class, refactoringName);
        this.myFileCopy = (PsiFile)expression2.getContainingFile().copy();
        this.myExpressionRange = expression2.getTextRange();
        this.myExpressionClass = expression2.getClass();
    }

    @Override
    protected String[] suggestNames(boolean replaceAll, @Nullable OCDefineDirective variable) {
        if (this.myUsageName != null) {
            return new String[]{this.myUsageName};
        }
        return new String[]{"DEF"};
    }

    @Override
    protected String checkExpression(OCElement expression2) {
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private void doIntroduce(String name, boolean isPreview) {
        PsiElement anchor = this.getAnchor();
        OCDefineDirective declaration2 = (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText(this.getDefineText(name), anchor);
        OCDefineDirective added = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declaration2, anchor);
        if (isPreview) {
            this.setVariable(added);
        }
    }

    @Override
    protected OCDefineDirective getVariable() {
        OCDefineDirective variable = (OCDefineDirective)super.getVariable();
        if (variable != null && variable.getNameIdentifier() == null) {
            return null;
        }
        return variable;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        this.doIntroduce(name, false);
        OCElement mainExpression = (OCElement)this.getMainExpression();
        Document document = this.myEditor.getDocument();
        this.initOccurrencesMarkers();
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
        for (RangeMarker marker : this.myOccurrenceMarkers) {
            String macroCallText = name + (mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration ? ";" : "");
            document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)macroCallText);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceDefine";
    }

    @NotNull
    private static String getTextWithLineCommentsReplacedWithBlockComments(@NotNull OCElement expression2) {
        String text = expression2.getTextWithMacros().trim();
        int correction = 0;
        for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)expression2, PsiComment.class)) {
            int offset = comment.getStartOffsetInParent();
            int len = comment.getTextLength();
            if (!comment.getText().startsWith("//") || offset + len >= text.length()) continue;
            text = text.substring(0, offset + correction) + "/*" + comment.getText().substring(2) + "*/" + text.substring(offset + len + correction);
            correction += 2;
        }
        return text;
    }

    private String getDefineText(String name) {
        OCElement mainExpression = (OCElement)this.getMainExpression();
        String mainText = OCDefineInplaceIntroducer.getTextWithLineCommentsReplacedWithBlockComments((OCElement)this.getMainExpression());
        String[] lines = mainText.split("\n");
        for (int i2 = 0; i2 < lines.length - 1; ++i2) {
            if (lines[i2].trim().endsWith("\\")) continue;
            int n = i2;
            lines[n] = lines[n] + "\\";
        }
        String declarationText = "#define " + name + " " + String.join((CharSequence)"\n", Arrays.asList(lines));
        if ((mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration) && declarationText.endsWith(";")) {
            declarationText = declarationText.substring(0, declarationText.length() - 1);
        }
        declarationText = declarationText + "\n\n";
        return declarationText;
    }
}

