/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypedefInplaceIntroducer
extends OCBaseInplaceIntroducer<OCDeclarator, PsiElement> {
    public OCTypedefInplaceIntroducer(Project project2, Editor editor, PsiElement expression2, List<PsiElement> occurrences, String refactoringName) {
        super(project2, editor, expression2, occurrences, OCDeclarator.class, PsiElement.class, refactoringName);
    }

    @Override
    protected String checkExpression(PsiElement expression2) {
        if (expression2 instanceof OCDeclaration) {
            String message2 = OCTypedefInplaceIntroducer.checkTypeElement(((OCDeclaration)expression2).getTypeElement());
            if (message2 != null) {
                return message2;
            }
            if (((OCDeclaration)expression2).getDeclarators().size() != 1) {
                return "Declaration must have one declarator to introduce the type";
            }
        } else {
            if (expression2 instanceof OCTypeElement) {
                return OCTypedefInplaceIntroducer.checkTypeElement((OCTypeElement)expression2);
            }
            if (expression2 instanceof OCCppNamespaceQualifier && OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)expression2) == null) {
                return "Namespace qualifier should be resolved to the class";
            }
        }
        return null;
    }

    @Nullable
    private static OCType getTypeFromNamespaceQualifier(OCCppNamespaceQualifier qualifier) {
        for (OCSymbol symbol : qualifier.resolveToSymbols()) {
            if (!(symbol instanceof OCStructSymbol)) continue;
            return symbol.getType();
        }
        return null;
    }

    private static String checkTypeElement(OCTypeElement typeElement) {
        if (typeElement == null || OCElementUtil.isElementEmpty(typeElement)) {
            return "The type is empty";
        }
        OCType type2 = typeElement.getType();
        if (type2 instanceof OCStructType && !((OCStructType)type2).isPredeclaration()) {
            return "Can't extract type of " + ((OCStructType)type2).getKind().getNameLowercase() + " definition";
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    @Override
    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
        String[] stringArray;
        if (this.myUsageName != null) {
            return new String[]{this.myUsageName};
        }
        OCType type2 = this.myExpr instanceof OCDeclaration ? ((OCDeclaration)this.myExpr).getDeclarators().get(0).getType() : (this.myExpr instanceof OCTypeElement ? ((OCTypeElement)this.myExpr).getType() : OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)this.myExpr));
        assert (type2 != null);
        Collection<String> names = OCNameSuggester.suggestForType(type2 = type2.resolve(this.myExpr.getContainingFile()), this.myExpr, Collections.emptyList());
        if (names.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "x";
        } else {
            stringArray = names.toArray(new String[names.size()]);
        }
        return stringArray;
    }

    private OCDeclaration doIntroduce(String name, boolean isPreview) {
        OCDeclaration added;
        OCType type2;
        boolean modifyAnchor;
        Object mainExpression = this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        boolean bl = modifyAnchor = anchor == mainExpression;
        if (mainExpression instanceof OCTypeElement) {
            type2 = ((OCTypeElement)mainExpression).getType();
        } else if (mainExpression instanceof OCCppNamespaceQualifier) {
            type2 = OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)mainExpression);
        } else {
            OCDeclaration declaration2 = (OCDeclaration)mainExpression;
            OCDeclarator declarator = declaration2.getDeclarators().get(0);
            String oldDeclaratorName = declarator.getName();
            type2 = declarator.getType();
            String oldDeclarationText = name + " " + oldDeclaratorName;
            if (declaration2.isTypedef()) {
                oldDeclarationText = "typedef " + oldDeclarationText;
            }
            if (declarator.getInitializer() != null) {
                oldDeclarationText = oldDeclarationText + " = " + declarator.getInitializer().getTextWithMacros();
            }
            declaration2 = declaration2 instanceof OCParameterDeclaration ? OCElementFactory.paramDeclarationFromText(oldDeclarationText, anchor) : OCElementFactory.declarationFromText(oldDeclarationText, anchor);
            declaration2 = (OCDeclaration)OCChangeUtil.replaceHandlingMacros(mainExpression, declaration2);
            if (modifyAnchor) {
                anchor = declaration2;
            }
            this.myOccurrences[0] = declaration2.getTypeElement();
        }
        if (type2 instanceof OCFunctionType) {
            type2 = OCPointerType.to(type2);
        }
        Object context = mainExpression;
        if (anchor != null && anchor.getPrevSibling() != null) {
            context = anchor.getPrevSibling();
        }
        OCDeclaration newDeclaration = OCElementFactory.declaration("typedef", name, type2, context);
        PsiElement parent = this.getAnchorParent(anchor, isPreview);
        if (mainExpression instanceof OCCppNamespaceQualifier) {
            anchor = PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)anchor, (boolean)false) ? anchor : null;
            added = (OCDeclaration)OCChangeUtil.addHandlingMacros(parent, newDeclaration, anchor, true);
        } else {
            added = OCChangeUtil.addBefore(parent, newDeclaration, anchor);
        }
        if (isPreview) {
            this.setVariable((PsiNameIdentifierOwner)added.getDeclarators().get(0));
        }
        return added;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        OCDeclaration declaration2 = this.doIntroduce(name, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration2);
        for (PsiElement expression2 : this.myOccurrences) {
            if (expression2 instanceof OCTypeElement) {
                String typeText = name;
                if (expression2.getParent() instanceof OCDeclaration && ((OCDeclaration)expression2.getParent()).isTypedef()) {
                    typeText = "typedef " + typeText;
                }
                OCChangeUtil.replaceHandlingMacros(expression2, OCElementFactory.typeElementFromText(typeText, expression2));
                continue;
            }
            if (expression2 instanceof OCCppNamespaceQualifier) {
                OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + name + "::x;", expression2).getDeclarators().get(0).getNamespaceQualifier();
                OCChangeUtil.replaceHandlingMacros(expression2, qualifier);
                continue;
            }
            String declaratorName = ((OCDeclaration)expression2).getDeclarators().get(0).getName();
            OCChangeUtil.replaceHandlingMacros(expression2, OCElementFactory.declarationFromText(name + " " + declaratorName, expression2));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceTypedef";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

