/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCPreprocessorDirectiveElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.move.OCUpDownMover;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import org.jetbrains.annotations.NotNull;

public class OCStatementUpDownMover
extends OCUpDownMover {
    private static final Key<OCStatement> STATEMENT_KEY = Key.create((String)"OCStatementUpDownMover.STATEMENT_KEY");

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, @NotNull OCElementsRange range, boolean down) {
        int offset;
        int destEnd;
        PsiElement[] statements = OCCodeInsightUtil.findStatementsAtRange(range.getFile(), range.getStartOffset(), range.getEndOffset(), false);
        if (statements == null || statements.length == 0) {
            return false;
        }
        if (statements.length == 1 && statements[0] instanceof OCStatement) {
            PsiElement statement2 = statements[0];
            PsiElement parent = statement2.getParent();
            while (!(parent instanceof OCBlockStatement || parent instanceof OCLabeledStatement || parent instanceof OCCaseStatement)) {
                statement2 = parent;
                parent = statement2.getParent();
            }
            statements[0] = statement2;
        }
        LineRange lineRange = new LineRange(statements[0], statements[statements.length - 1]);
        lineRange.firstElement = statements[0];
        lineRange.lastElement = statements[statements.length - 1];
        info.toMove = lineRange;
        info.toMove2 = null;
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)statements[0], (Class[])new Class[]{OCFunctionDefinition.class, OCMethod.class});
        int destStart = down ? lineRange.endLine : lineRange.startLine - 1;
        int n = destEnd = down ? lineRange.endLine + 1 : lineRange.startLine - 1;
        if (callable == null) {
            return false;
        }
        OCBlockStatement body2 = callable.getBody();
        if (body2 == null) {
            return false;
        }
        TextRange callableRange = body2.getRangeWithMacros();
        while (destEnd >= 0 && destEnd < editor.getDocument().getLineCount() && callableRange.containsOffset(offset = editor.logicalPositionToOffset(new LogicalPosition(destEnd, 0)))) {
            PsiElement element = this.firstNonMacroWhiteElement(editor, offset, destEnd, range.getFile(), true, true);
            LineRange destRange = OCStatementUpDownMover.calcDestRange(down, destStart, destEnd);
            if (element == null) continue;
            IElementType elementType = OCElementUtil.getElementType(element);
            OCCallable callableOrBlock = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            if (callableOrBlock != null && !PsiTreeUtil.isAncestor((PsiElement)callableOrBlock, (PsiElement)statements[0], (boolean)false)) {
                destEnd += down ? 1 : -1;
                continue;
            }
            if (OCElementUtil.isWhitespace(element) && elementType != OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && (!(element instanceof PsiComment) || OCStatementUpDownMover.elementStartLine(editor, element) >= destEnd)) {
                info.toMove2 = destRange;
                break;
            }
            OCStatement statement3 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class, (boolean)false);
            if (statement3 instanceof OCBlockStatement) {
                if (((OCBlockStatement)statement3).getClosingBrace() == element || elementType instanceof OCPreprocessorDirectiveElementType && OCElementUtil.getTextWithMacros(element).startsWith("#if")) {
                    info.toMove2 = destRange;
                    break;
                }
                if (!(statement3.getParent() instanceof OCBlockStatement)) {
                    destEnd += down ? 1 : -1;
                    continue;
                }
            }
            if (statement3 != null && statement3.getTextOffset() >= offset) {
                info.toMove2 = destRange;
                info.putUserData(STATEMENT_KEY, (Object)statement3);
                break;
            }
            destEnd += down ? 1 : -1;
        }
        return true;
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement parent;
        OCStatement statement2 = (OCStatement)info.getUserData(STATEMENT_KEY);
        PsiElement psiElement = parent = statement2 != null ? statement2.getParent() : null;
        if (!(parent == null || parent instanceof OCBlockStatement || parent instanceof OCLabeledStatement || parent instanceof OCCaseStatement)) {
            int oldLine = OCStatementUpDownMover.elementStartLine(editor, statement2);
            statement2 = OCChangeUtil.ensureParentIsBlockStatement(statement2);
            PsiDocumentManager.getInstance((Project)statement2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            int sourceStart = info.toMove.startLine;
            int sourceEnd = info.toMove.endLine;
            int destEnd = OCStatementUpDownMover.elementStartLine(editor, statement2);
            int delta = destEnd - oldLine + 1;
            if (sourceStart >= destEnd) {
                sourceStart += delta;
            }
            if (sourceEnd >= destEnd) {
                sourceEnd += delta;
            }
            int destStart = down ? sourceEnd : sourceStart - 1;
            info.toMove = new LineRange(sourceStart, sourceEnd);
            info.toMove2 = OCStatementUpDownMover.calcDestRange(down, destStart, destEnd);
        }
    }
}

