/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import org.jetbrains.annotations.NotNull;

public class OCTopLevelModel
extends UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
    private boolean myImportTargetFromSource;
    private boolean myImportSourceFromTarget;
    private VirtualFile mySourceFile;
    private MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myUsesModel;

    public OCTopLevelModel(PsiElement source) {
        super(source);
        this.mySourceFile = source != null ? source.getContainingFile().getVirtualFile() : null;
        this.myUsesModel = new AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo>(source, null, false){

            @Override
            protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
                return problem;
            }
        };
    }

    public boolean importTargetFromSource() {
        return this.myImportTargetFromSource;
    }

    public boolean importSourceFromTarget() {
        return this.myImportSourceFromTarget && !this.myImportTargetFromSource;
    }

    @Override
    public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
        if (super.checkForProblems(memberInfo) != 0) {
            this.myImportTargetFromSource = this.mySourceFile != null && this.mySourceFile.equals(memberInfo.getSymbol().getContainingFile());
            return 1;
        }
        if (this.myUsesModel.checkForProblems((MemberInfoBase)memberInfo) != 0) {
            this.myImportSourceFromTarget = true;
            return 1;
        }
        return 0;
    }

    @Override
    public void memberInfoChanged(MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
        this.myImportTargetFromSource = false;
        this.myImportSourceFromTarget = false;
        super.memberInfoChanged(event);
        this.myUsesModel.memberInfoChanged(event);
    }
}

