/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCExtractSuperClassDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import org.jetbrains.annotations.NotNull;

public class OCExtractSuperClassHandler
extends OCMoveRefactoringHandler {
    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"extract.superclass.title");
    }

    @Override
    protected void showDialog(OCSymbolDeclarator clazz, Condition<PsiElement> selectedCond, Editor editor) {
        OCInterfaceSymbol mainInterface;
        Project project2 = clazz.getProject();
        Object symbol = clazz.getSymbol();
        if (symbol instanceof OCProtocolSymbol) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Use \"Extract Super Protocol\" instead", (String)this.getTitle(), null);
            return;
        }
        if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface()) != null && !OCSearchScope.isInProjectSources(mainInterface)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Selected element is a category on the class which is not located inside the project", (String)this.getTitle(), null);
            return;
        }
        super.showDialog(clazz, selectedCond, editor);
    }

    @Override
    protected OCAbstractMoveDialog createDialog(OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Editor editor) {
        return new OCExtractSuperClassDialog(clazz, classSymbol, selectedCondition);
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.extractSuperclass";
    }
}

