/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCExtractSubClassDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCPushDownDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;

public class OCPushDownRefactoringHandler
extends OCMoveRefactoringHandler {
    private boolean mySelectAllInheritors;

    public OCPushDownRefactoringHandler() {
    }

    public OCPushDownRefactoringHandler(boolean selectAllInheritors) {
        this.mySelectAllInheritors = selectAllInheritors;
    }

    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    @Override
    protected OCAbstractMoveDialog createDialog(OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Editor editor) {
        OCPushDownDialog dialog2 = new OCPushDownDialog(clazz, classSymbol, selectedCondition){

            @Override
            protected boolean selectAllInheritors() {
                return OCPushDownRefactoringHandler.this.mySelectAllInheritors;
            }
        };
        if (dialog2.isInheritorsSearchCancelled()) {
            return null;
        }
        if (dialog2.getInheritors().isEmpty()) {
            return OCNewFileActionBase.isNewFileActionSupported() ? new OCExtractSubClassDialog(clazz, classSymbol, selectedCondition) : null;
        }
        return dialog2;
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.pushDown";
    }
}

