/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCMemberSelectionPanel;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractMoveDialog
extends RefactoringDialog {
    protected OCMemberInfoStorage myStorage;
    protected List<OCMemberInfo> myMemberInfos;
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myMemberInfoModel;
    protected OCFile mySourceFile;
    protected final OCSymbolDeclarator mySourceClass;
    protected OCSymbol myClassSymbol;
    private Condition<PsiElement> mySelectedCondition;
    private boolean myEnableValidation;
    protected OCMemberSelectionPanel myMemberSelectionPanel;

    protected OCAbstractMoveDialog(@Nullable OCSymbolDeclarator clazz, @Nullable OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Project project2) {
        super(project2, true);
        this.mySourceClass = clazz;
        this.mySourceFile = clazz != null ? (OCFile)clazz.getContainingFile() : null;
        this.mySelectedCondition = selectedCondition;
        this.getRefactorAction().putValue("Name", this.getOKButtonText());
        this.myStorage = new OCMemberInfoStorage(clazz);
        this.myMemberInfoModel = this.createModel();
        this.myClassSymbol = classSymbol;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new OCMemberSelectionPanel(this.myMemberInfos, null);
        panel2.add((Component)this.myMemberSelectionPanel, "Center");
        this.myMemberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        for (MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> memberInfoModel : this.getAllModels()) {
            this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener(memberInfoModel);
        }
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener(new MemberInfoChangeListener<OCSymbolHolderVirtualPsiElement, OCMemberInfo>(){

            public void memberInfoChanged(MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
                OCAbstractMoveDialog.this.validateButtons();
            }
        });
        return panel2;
    }

    protected List<? extends MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo>> getAllModels() {
        return Collections.singletonList(this.myMemberInfoModel);
    }

    @Override
    protected final void canRun() throws ConfigurationException {
        if (!this.myEnableValidation) {
            return;
        }
        this.checkCanRun();
    }

    protected void checkCanRun() throws ConfigurationException {
        if (!this.allowsEmptySelection() && this.getSelectedMemberInfos().isEmpty()) {
            throw new ConfigurationException("No members are selected");
        }
    }

    public boolean checkConflicts() {
        return true;
    }

    @Override
    protected void doAction() {
        this.myEnableValidation = true;
        this.validateButtons();
        if (this.getRefactorAction().isEnabled() && this.checkConflicts()) {
            this.invokeRefactoring();
            this.closeOKAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<OCFile[], String> invokeRefactoring() {
        OCMoveProcessor processor2 = this.createProcessor();
        if (processor2 != null) {
            MultiMap<PsiElement, String> conflicts = this.getConflicts();
            processor2.setConflicts(conflicts);
            StringBuilder conflictsBuilder = new StringBuilder();
            for (OCMemberInfo info : this.myMemberInfos) {
                if (this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) == 1) {
                    conflictsBuilder.append("Warning: ").append(info.getDisplayName()).append("\n");
                }
                if (this.isMemberEnabled(info)) continue;
                conflictsBuilder.append("Disabled: ").append(info.getDisplayName()).append("\n");
            }
            try {
                OCFormattingModelBuilder.requestAlwaysCreateFullModel();
                this.invokeRefactoring(processor2);
            }
            finally {
                OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
            }
            ArrayList conflictStrings = new ArrayList(conflicts.values());
            Collections.sort(conflictStrings);
            for (String message2 : conflictStrings) {
                conflictsBuilder.append("Error: ").append(message2).append("\n");
            }
            return Pair.create((Object)processor2.getCreatedFiles(), (Object)conflictsBuilder.toString());
        }
        return null;
    }

    @Nullable
    protected abstract OCMoveProcessor createProcessor();

    protected abstract String getOKButtonText();

    @Override
    protected boolean hasPreviewButton() {
        return true;
    }

    public boolean allowsEmptySelection() {
        return false;
    }

    protected abstract MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel();

    protected abstract String getConflictMessage(OCMemberInfo var1, OCSymbol var2);

    private MultiMap<PsiElement, String> getConflicts() {
        MultiMap conflicts = new MultiMap();
        for (OCMemberInfo info : this.myMemberInfos) {
            if (this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) != 2) continue;
            Object symbol = ((OCSymbolHolderVirtualPsiElement)info.getMember()).getSymbol();
            assert (symbol != null);
            Object element = symbol.locateDefinition();
            if (element == null) continue;
            conflicts.putValue(element, (Object)this.getConflictMessage(info, (OCSymbol)symbol));
        }
        return conflicts;
    }

    public List<OCMemberInfo> getMemberInfos() {
        return this.myMemberInfos;
    }

    public List<OCMemberInfo> getSelectedMemberInfos() {
        ArrayList<OCMemberInfo> result2 = new ArrayList<OCMemberInfo>(this.myMemberInfos.size());
        for (OCMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.isMemberEnabled(info)) continue;
            result2.add(info);
        }
        return result2;
    }

    protected boolean isMemberEnabled(OCMemberInfo member) {
        return true;
    }

    protected boolean selectAllMembers() {
        return false;
    }

    protected void setMembersChecked() {
        if (this.selectAllMembers()) {
            for (OCMemberInfo info : this.myMemberInfos) {
                info.setChecked(this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) == 0 && this.isMemberEnabled(info));
            }
            return;
        }
        for (OCMemberInfo member : this.myMemberInfos) {
            if (!this.isMemberEnabled(member)) {
                member.setChecked(false);
                continue;
            }
            OCSymbol memberSymbol = member.getSymbol();
            if (this.mySourceClass instanceof OCClassDeclaration && memberSymbol instanceof OCProtocolSymbol) {
                PsiElement element = (PsiElement)ContainerUtil.find(((OCClassDeclaration)this.mySourceClass).getProtocolList().getProtocols(), element12 -> element12.getName().equals(memberSymbol.getName()));
                member.setChecked(this.mySelectedCondition.value((Object)element));
                continue;
            }
            if (this.mySourceClass instanceof OCStruct && memberSymbol instanceof OCStructSymbol && ((OCStructSymbol)memberSymbol).getParent() != this.myClassSymbol) {
                OCCppBaseClauseList baseClausesList = ((OCStruct)this.mySourceClass).getBaseClausesList();
                PsiElement element = baseClausesList != null ? (PsiElement)ContainerUtil.find(baseClausesList.getBaseClauses(), clause -> {
                    OCReferenceElement element1 = clause.getReferenceElement();
                    return element1 != null && element1.getName().equals(memberSymbol.getName());
                }) : null;
                member.setChecked(this.mySelectedCondition.value((Object)element));
                continue;
            }
            if (memberSymbol == null) continue;
            memberSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (memberSymbol instanceof OCClassSymbol && !((OCClassSymbol)memberSymbol).isSameCategory((OCSymbol)symbol)) {
                    return true;
                }
                if (this.mySelectedCondition.value(symbol.locateDefinition())) {
                    member.setChecked(true);
                }
                return true;
            }));
        }
    }
}

