/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCCppTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveCppProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCObjcTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractExtractDialog;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractSuperClassDialog
extends OCAbstractExtractDialog {
    public OCExtractSuperClassDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition) {
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle(RefactoringBundle.message((String)"extract.superclass.title"));
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.extract.superclass.dialog";
    }

    @Override
    protected String getClassType() {
        return "Superclass";
    }

    @Override
    protected OCMoveProcessor createProcessor() {
        if (this.mySourceClass instanceof OCClassDeclaration) {
            return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

                @Override
                @Nullable
                protected OCNewFileActionBase getNewClassAction() {
                    if (this.mySourceClass instanceof OCProtocol) {
                        return new OCNewProtocolAction();
                    }
                    return new OCNewClassAction();
                }

                @Override
                public void addSuperClasses() {
                    OCReferenceElement superClassElement = ((OCClassDeclaration)this.mySourceClass).getSuperClassRef().getReferenceElement();
                    if (superClassElement != null) {
                        this.myMover.setSuperClass((OCClassDeclaration)((OCObjcTargetClass)this.myTargetClasses.get(0)).getPsi(), superClassElement.getName());
                    }
                    this.myMover.setSuperClass(this.myMainInterface, this.myTargetClassName);
                }

                @Override
                protected boolean importTargetFromSource() {
                    return true;
                }

                @Override
                protected String getCommandName() {
                    return OCExtractSuperClassDialog.this.getTitle();
                }
            };
        }
        if (this.mySourceClass instanceof OCStruct) {
            return new OCMoveCppProcessor((OCStruct)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

                @Override
                protected OCNewFileActionBase getNewClassAction() {
                    OCStructSymbol symbol = (OCStructSymbol)((OCStruct)this.mySourceClass).getSymbol();
                    OCQualifiedName qualifiedName = symbol != null ? symbol.getResolvedQualifiedName() : null;
                    return new OCNewCppClassAction(qualifiedName != null ? qualifiedName.getQualifier() : null);
                }

                @Override
                protected void addSuperClasses() {
                    this.myMover.addBaseClass((OCStruct)this.mySourceClass, (OCStructSymbol)((OCCppTargetClass)this.myTargetClasses.get(0)).getSymbol(), OCVisibility.PUBLIC, true);
                }

                @Override
                protected boolean importTargetFromSource() {
                    return true;
                }

                @Override
                protected String getCommandName() {
                    return OCExtractSuperClassDialog.this.getTitle();
                }
            };
        }
        assert (false) : this.mySourceClass;
        return null;
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass, null, false){

            @Override
            protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
                if (problem == 2 && memberInfo.isStatic()) {
                    return 1;
                }
                return problem;
            }

            @Override
            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCExtractSuperClassDialog.this.isMemberEnabled(member);
            }
        };
    }
}

