/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @Override
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file2) {
        OCSymbol<PsiElement> symbol;
        PsiElement atCursor;
        if (!(file2 instanceof OCFile)) {
            return false;
        }
        if (!(element == null || element.getContainingFile() instanceof OCFile && file2.getManager().isInProject(element))) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = TargetElementUtil.findReference(editor, offset);
        if (reference != null && ((atCursor = reference.getElement()) instanceof OCReferenceElement || atCursor instanceof OCQualifiedExpression)) {
            return true;
        }
        if (element == null) {
            return false;
        }
        if (element instanceof OCMethod) {
            symbol = (OCMethodSymbol)((OCMethod)element).getSymbol();
            OCSymbol<PsiElement> oCSymbol = symbol = symbol != null ? symbol.getAssociatedSymbol() : null;
            if (symbol != null && symbol.getGeneratedFromProperty() != null) {
                return false;
            }
        } else if (element instanceof OCDeclarator) {
            symbol = ((OCDeclarator)element).getSymbol();
            if (symbol instanceof OCPropertySymbol) {
                if (reference != null && reference.getElement() instanceof OCSendMessageExpression && !symbol.getName().equals(((OCSendMessageExpression)reference.getElement()).getMessageSelector())) {
                    return false;
                }
            } else if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                return ((OCFunctionSymbol)symbol).isUDL();
            }
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement id = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            return id != null && !element.getTextRange().isEmpty();
        }
        return false;
    }

    @Override
    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        return OCInplaceRenameHandler.createRenamer(elementToRename, editor, null, null);
    }

    @Nullable
    static VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor, @Nullable String initialName, @Nullable String oldName) {
        if (elementToRename instanceof OCCategoryName) {
            OCClassSymbol symbol = ((OCClassDeclaration)elementToRename.getParent()).getSymbol();
            if (symbol != null) {
                return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, true, initialName, oldName);
            }
        } else {
            PsiElement element;
            OCSymbol<?> symbol = OCElementUtil.getRawSymbolFromNamedElement(elementToRename);
            if (symbol == null) {
                return null;
            }
            if (symbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                CommonRefactoringUtil.showErrorHint((Project)elementToRename.getProject(), (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), null);
                return null;
            }
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)elementToRename.getProject()).getPsiFile(editor.getDocument());
            PsiElement psiElement = element = currentFile != null ? currentFile.findElementAt(editor.getCaretModel().getOffset()) : null;
            if (currentFile != null && OCElementUtil.getElementType(element) != OCTokenTypes.IDENTIFIER) {
                element = currentFile.findElementAt(editor.getCaretModel().getOffset() - 1);
            }
            if (elementToRename instanceof OCMethod) {
                OCMethod method2 = (OCMethod)elementToRename;
                if (symbol instanceof OCMethodSymbol && element != null && OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER) {
                    PsiElement parent = element.getParent();
                    OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol;
                    int index = -1;
                    if (parent instanceof OCMethodSelectorPart && ((OCMethodSelectorPart)parent).getSelectorIdentifier() == element) {
                        index = method2.getSelectors().indexOf(element);
                    } else if (parent instanceof OCArgumentSelector && ((OCArgumentSelector)parent).getSelectorIdentifier() == element) {
                        OCSendMessageExpression sendMessageExpr = (OCSendMessageExpression)parent.getParent().getParent();
                        index = sendMessageExpr.getArgumentSelectors().indexOf(parent);
                    } else if (parent instanceof OCQualifiedExpression) {
                        index = 0;
                    } else if (parent instanceof OCSelectorExpression) {
                        index = ((OCSelectorExpression)parent).getSelectorParts().indexOf(element);
                    }
                    if (index != -1) {
                        return new OCInplaceRenamer(method2, methodSymbol, element, index, editor, initialName, oldName);
                    }
                }
                return new OCInplaceRenamer((OCMethod)elementToRename, symbol, editor, false, initialName, oldName){

                    @Override
                    public boolean performInplaceRename() {
                        return true;
                    }
                };
            }
            if (symbol instanceof OCInstanceVariableSymbol && elementToRename instanceof OCReferenceElement) {
                return new OCInplaceRenamer(new OCSymbolHolderVirtualPsiElement(symbol), symbol, editor, false, initialName, oldName);
            }
            if (symbol instanceof OCPropertySymbol && element != null && element.getParent() instanceof OCSelectorExpression && OCNameSuggester.isObjCSetter(((OCSelectorExpression)element.getParent()).getSelector())) {
                return null;
            }
            if (elementToRename instanceof OCLocalizedString) {
                int offset;
                if (OCElementUtil.getElementType(elementToRename.getFirstChild()) != OCTokenTypes.STRING_LITERAL || ((OCLocalizedString)elementToRename).getKey().isEmpty()) {
                    return null;
                }
                if (currentFile != null && (element = currentFile.findElementAt(offset = editor.getCaretModel().getOffset())) != null && OCElementUtil.getElementType(element) == OCTokenTypes.STRING_LITERAL && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                }
            }
            return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, false, initialName, oldName);
        }
        return null;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement psiElement = element = dataContext != null ? PsiElementRenameHandler.getElement(dataContext) : null;
        if (element == null) {
            PsiReference reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            PsiElement psiElement2 = element = reference != null && reference.resolve() == null ? reference.getElement() : null;
            if (element != null) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                if (ApplicationManager.getApplication().isUnitTestMode() || this.checkAvailable(element, editor, dataContext)) {
                    String initialName = dataContext != null ? (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext) : null;
                    OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, editor, file2, project2, reference, initialName, reference.getCanonicalText());
                    ((VariableInplaceRenamer)renamer).performInplaceRename();
                }
                return;
            }
        }
        super.invoke(project2, editor, file2, dataContext);
    }

    @Override
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, Editor editor, @Nullable DataContext dataContext) {
        VariableInplaceRenamer renamer = this.createRenamer(elementToRename, editor);
        if (renamer != null) {
            renamer.performInplaceRename();
        }
        return renamer;
    }
}

