/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class OCInplaceRenamer
extends MemberInplaceRenamer {
    private OCSymbol<?> mySymbol;
    private boolean myCategoryMode;
    private PsiElement mySelectorIdentifier;
    private int mySelectorIndex;
    private boolean myConvertToSetter;

    public OCInplaceRenamer(@NotNull OCMethod elementToRename, @NotNull OCMethodSymbol symbol, PsiElement selectorIdentifier, int selectorIndex, Editor editor, String initialName, String oldName) {
        super((PsiNamedElement)elementToRename, elementToRename, editor, initialName != null ? initialName : selectorIdentifier.getText(), oldName != null ? oldName : selectorIdentifier.getText());
        this.mySymbol = symbol;
        this.myCategoryMode = false;
        this.mySelectorIdentifier = selectorIdentifier;
        this.mySelectorIndex = selectorIndex;
        boolean bl = this.myConvertToSetter = this.mySelectorIdentifier.getParent() instanceof OCQualifiedExpression && new OCReadWriteAccessDetector().getExpressionAccess(this.mySelectorIdentifier.getParent()) == ReadWriteAccessDetector.Access.Write;
        assert (this.mySelectorIndex != -1);
    }

    public OCInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull OCSymbol symbol, Editor editor, boolean categoryMode, String initialName, String oldName) {
        super(elementToRename, (PsiElement)elementToRename, editor, initialName != null ? initialName : OCInplaceRenamer.getElementName(elementToRename), oldName != null ? oldName : OCInplaceRenamer.getElementName(elementToRename));
        this.mySymbol = symbol;
        this.myCategoryMode = categoryMode;
    }

    private static String getElementName(PsiNamedElement elementToRename) {
        OCSymbolWithQualifiedName symbol;
        if (elementToRename instanceof OCDeclarator && elementToRename.getParent() instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)elementToRename.getParent()).getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
            return symbol.getName().substring(1);
        }
        return elementToRename.getName();
    }

    @Override
    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        boolean showChooser = super.appendAdditionalElement(refs, stringUsages);
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        VirtualFile curVirtualFile = currentFile != null ? currentFile.getVirtualFile() : null;
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCSymbolWithQualifiedName owner;
            OCFunctionSymbol function;
            if (Comparing.equal((Object)symbol.getContainingFile(), (Object)curVirtualFile)) {
                Object definition = symbol.locateDefinition();
                if (this.myCategoryMode) {
                    if (definition instanceof OCClassDeclaration && Comparing.equal((String)((OCClassSymbol)this.mySymbol).getCategoryName(), (String)((OCClassSymbol)symbol).getCategoryName())) {
                        PsiElement identifier = ((OCClassDeclaration)definition).getCategoryElement().getNameIdentifier();
                        OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
                    }
                } else if (definition instanceof PsiNameIdentifierOwner) {
                    if (definition instanceof OCMethod) {
                        PsiElement selector2;
                        List<OCMethodSelectorPart> parameters2 = ((OCMethod)definition).getParameters();
                        if (this.mySelectorIndex < parameters2.size() && (selector2 = parameters2.get(this.mySelectorIndex).getSelectorIdentifier()) != null && this.mySelectorIdentifier != null && selector2.getText().equals(this.mySelectorIdentifier.getText())) {
                            OCInplaceRenamer.appendStringUsage(selector2, stringUsages);
                        }
                    } else {
                        OCInplaceRenamer.appendStringUsage(((PsiNameIdentifierOwner)definition).getNameIdentifier(), stringUsages);
                    }
                }
                if (symbol instanceof OCLocalizedStringSymbol) {
                    refs.add(new OCStringResourceReference(this.myElementToRename.getFirstChild(), FileUtil.getNameWithoutExtension((String)this.myElementToRename.getContainingFile().getName())));
                }
            }
            if (symbol instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)symbol, stringUsages, refs, currentFile);
            } else if (symbol instanceof OCFunctionSymbol && ((function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor()) && (owner = function.getResolvedOwner()) instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbol(owner, stringUsages, refs, currentFile);
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)owner, stringUsages, refs, currentFile);
            }
            return true;
        }));
        if (this.mySelectorIdentifier != null) {
            for (PsiReference ref : refs) {
                PsiElement element = ref.getElement();
                PsiElement selector2 = null;
                if (element instanceof OCSendMessageExpression) {
                    List<OCArgumentSelector> selectors = ((OCSendMessageExpression)element).getArgumentSelectors();
                    if (this.mySelectorIndex < selectors.size()) {
                        selector2 = selectors.get(this.mySelectorIndex).getSelectorIdentifier();
                    }
                } else if (element instanceof OCQualifiedExpression) {
                    selector2 = ((OCQualifiedExpression)element).getNameIdentifier();
                } else if (element instanceof OCSelectorExpression) {
                    selector2 = ((OCSelectorExpression)element).getSelectorParts().get(this.mySelectorIndex);
                }
                if (selector2 == null || !selector2.getText().equals(this.mySelectorIdentifier.getText())) continue;
                OCInplaceRenamer.appendStringUsage(selector2, stringUsages);
            }
            refs.clear();
        }
        return showChooser;
    }

    private static void appendStringUsage(PsiElement element, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (element != null && !OCElementUtil.isPartOfMacroSubstitution(element)) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)element, (Object)new TextRange(0, element.getTextLength())));
        }
    }

    private static void appendAdditionalSymbolsForStruct(OCStructSymbol symbol, Collection<Pair<PsiElement, TextRange>> stringUsages, Collection<PsiReference> refs, PsiFile currentFile) {
        Processor processor2 = symbol1 -> {
            OCInplaceRenamer.appendAdditionalSymbol(symbol1, stringUsages, refs, currentFile);
            return true;
        };
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true);
        symbol.processDestructors((Processor<OCFunctionSymbol>)processor2, true);
    }

    private static void appendAdditionalSymbol(OCSymbol symbol, Collection<Pair<PsiElement, TextRange>> stringUsages, Collection<PsiReference> refs, PsiFile currentFile) {
        PsiElement identifier;
        if (!Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return;
        }
        Object definition = symbol.locateDefinition();
        if (definition instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)definition).getNameIdentifier()) != null) {
            OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
            for (PsiReference reference : ReferencesSearch.search(definition, (SearchScope)new LocalSearchScope((PsiElement)currentFile), (boolean)false).findAll()) {
                if (reference.getElement() instanceof OCDeclarator) continue;
                refs.add(reference);
            }
        }
    }

    @Override
    protected PsiElement checkLocalScope() {
        PsiFile currentFile;
        if (this.mySymbol.getKind() == OCSymbolKind.PARAMETER && this.mySymbol.getAssociatedSymbol() != null && (currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return currentFile;
        }
        return super.checkLocalScope();
    }

    @Override
    protected PsiNamedElement getVariable() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString ? this.myElementToRename : super.getVariable();
    }

    @Override
    public PsiElement getSubstituted() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString ? this.myElementToRename : super.getSubstituted();
    }

    @Override
    protected JComponent getComponent() {
        if (this.myCategoryMode) {
            return null;
        }
        final OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(OCCodeStyleSettings.class);
        final JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(null);
        OCRenameProcessor.processAssociatedSymbols(this.mySymbol, new OCRenameProcessor.AssociatedElementsProcessor(){

            @Override
            public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                if (ivar.isClang4ImplicitIvar()) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel2, "&Rename " + ivar.getNameWithKindLowercase(), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processPropertyAccessors(OCPropertySymbol property) {
                return false;
            }

            @Override
            public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                if (!(fromSymbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)fromSymbol).isClang4ImplicitIvar()) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel2, "&Rename " + property.getNameWithKindLowercase(), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel2, "&Rename class aliases", settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }

            @Override
            public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel2, "&Rename " + clazz.getNameWithKindLowercase(), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }
        }, (SearchScope)OCSearchScope.getProjectSourcesScope(this.myProject));
        return panel2.getComponentCount() > 0 ? panel2 : null;
    }

    @Override
    public void performRenameInner(final PsiElement element, String newName) {
        if (this.mySelectorIdentifier != null || this.mySymbol instanceof OCFunctionSymbol && !this.mySymbol.getKind().isConstructorOrDestructor()) {
            PsiElement definition;
            if (this.myConvertToSetter) {
                newName = "set" + StringUtil.capitalize((String)newName);
            }
            if ((definition = OCElementUtil.findRenameTargetDefinition(element, false)) instanceof OCCallable) {
                OCCallable callable = (OCCallable)definition;
                OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler(callable, element, false, true, !ApplicationManager.getApplication().isUnitTestMode(), false);
                handler2.setTitle(this.getCommandName());
                if (this.mySymbol instanceof OCFunctionSymbol) {
                    handler2.setName(newName);
                } else {
                    handler2.renameSelector(this.mySelectorIndex, newName);
                }
                handler2.invoke();
            }
        } else {
            if (this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar() && !newName.startsWith("_")) {
                newName = "_" + newName;
            }
            final String newNameFinal = newName;
            RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(element);
            RenameProcessor renameProcessor = new RenameProcessor(this.myProject, element, newName, elementProcessor.isToSearchInComments(element), elementProcessor.isToSearchForTextOccurrences(element)){
                private OCRenameProcessor.RenameUsages myOption;

                @Override
                public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                    if (!super.preprocessUsages(refUsages)) {
                        return false;
                    }
                    this.myOption = OCRenameProcessor.validateUsages(OCInplaceRenamer.this.myElementToRename, refUsages);
                    return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
                }

                @Override
                protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
                    return this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
                }

                @Override
                @NotNull
                public UsageInfo[] findUsages() {
                    ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(Arrays.asList(super.findUsages()));
                    ReferencesSearch.SearchParameters parameters2 = new ReferencesSearch.SearchParameters(element, element.getUseScope(), false);
                    new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(parameters2, (Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)((Processor)usage -> {
                        PsiElement e = usage.getElement();
                        if (OCElementUtil.getElementType(e) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                            TextRange range = usage.getTextRange();
                            result2.add((UsageInfo)NonCodeUsageInfo.create((PsiFile)e.getContainingFile(), (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)element, (String)newNameFinal));
                        }
                        return true;
                    }));
                    return result2.toArray(new UsageInfo[result2.size()]);
                }

                @Override
                @NotNull
                protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                    LinkedHashMap<PsiElement, String> renamesMap = new LinkedHashMap<PsiElement, String>();
                    for (PsiElement psiElement : this.myAllRenames.keySet()) {
                        if (!(psiElement instanceof OCSymbolDeclarator) || ((OCSymbolDeclarator)psiElement).getSymbol() == null) continue;
                        renamesMap.put(psiElement, (String)this.myAllRenames.get(psiElement));
                    }
                    return new RenameViewDescriptor(renamesMap);
                }

                @Override
                public void doRun() {
                    try {
                        super.doRun();
                    }
                    finally {
                        OCInplaceRenamer.this.restoreCaretOffsetAfterRename();
                    }
                }
            };
            renameProcessor.run();
        }
    }

    @Override
    public boolean performInplaceRename() {
        LinkedHashSet<String> suggestedNames = new LinkedHashSet<String>();
        String originalName = this.myElementToRename.getName();
        if (this.myElementToRename instanceof OCDeclarator) {
            List<String> predefinedNames = originalName == null ? Collections.emptyList() : Collections.singletonList(originalName);
            suggestedNames.addAll(OCNameSuggester.suggestForDeclaration((OCDeclarator)this.myElementToRename, true, predefinedNames));
        } else if (this.myElementToRename instanceof OCMethodSelectorPart) {
            ArrayList<String> paramNames = new ArrayList<String>();
            OCMethod method2 = (OCMethod)this.myElementToRename.getParent();
            List<OCMethodSelectorPart> parameters2 = method2.getParameters();
            Iterator<OCMethodSelectorPart> iterator = parameters2.iterator();
            while (iterator.hasNext()) {
                OCMethodSelectorPart part = iterator.next();
                String parameterName = part.getParameterName();
                if (parameterName == null) continue;
                paramNames.add(parameterName);
            }
            OCMethodSelectorPart selectorPart = (OCMethodSelectorPart)this.myElementToRename;
            suggestedNames.addAll(OCNameSuggester.suggestForType(selectorPart.getType(), (PsiElement)selectorPart, paramNames));
            suggestedNames.add(OCNameSuggester.suggestForParameter(paramNames, parameters2.get(0) == this.myElementToRename, selectorPart.getSelectorPart(), selectorPart.getType(), (OCMethodSymbol)method2.getSymbol(), null));
        }
        SearchScope scope = this.getReferencesSearchScope(this.myElementToRename.getContainingFile().getVirtualFile());
        Collection<PsiReference> references = this.collectRefs(scope);
        for (PsiReference ref : references) {
            OCExpression expr = null;
            PsiElement element = ref.getElement();
            if (element instanceof OCQualifiedExpression) {
                expr = (OCExpression)element;
            } else if (element instanceof OCReferenceElement && element.getParent() instanceof OCReferenceExpression) {
                expr = (OCExpression)element.getParent();
            }
            if (expr == null) continue;
            suggestedNames.addAll(OCNameSuggester.suggestForExpression(this.mySymbol.getKind(), expr));
        }
        Iterator iterator = suggestedNames.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (originalName == null || !name.startsWith(originalName) || !name.substring(originalName.length()).matches("[0-9]*")) continue;
            iterator.remove();
        }
        return this.performInplaceRefactoring(suggestedNames);
    }

    public void performRefactoringForTest(String newName) {
        this.performRefactoringRename(newName, null);
    }

    @Override
    protected boolean acceptReference(PsiReference reference) {
        return !OCElementUtil.isPartOfMacroSubstitution(reference.getElement()) && Comparing.equal((String)reference.getCanonicalText(), (String)this.myElementToRename.getName());
    }

    @Override
    protected boolean isIdentifier(String newName, Language language) {
        return this.myElementToRename instanceof OCLocalizedString && !newName.isEmpty() || this.mySelectorIdentifier != null && newName.isEmpty() || super.isIdentifier(newName, language);
    }

    @Override
    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return OCInplaceRenameHandler.createRenamer((PsiElement)variable, editor, this.myOldName, this.myOldName);
    }

    @Override
    protected PsiElement getNameIdentifier() {
        PsiElement identifier = this.mySelectorIdentifier != null ? this.mySelectorIdentifier : super.getNameIdentifier();
        return identifier != null && OCElementUtil.isPartOfMacroSubstitution(identifier) ? null : identifier;
    }

    @Override
    protected String getCommandName() {
        PsiNamedElement variable = this.getVariable();
        return variable != null && !variable.isValid() ? "Rename" : super.getCommandName();
    }

    @Override
    protected void showDialogAdvertisement(String actionId) {
    }

    @Override
    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
        return false;
    }
}

