/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.search.OCElementInMacroSubstitutionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameProcessor
extends RenamePsiElementProcessor {
    private OCSynthesizeProperty myOldSynthesize;
    private OCSynthesizeProperty myNewSynthesize;

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof OCElement && element instanceof PsiNamedElement || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty || element instanceof OCLocalizedString;
    }

    @Override
    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames, final SearchScope scope) {
        OCClassDeclaration clazz;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        this.myNewSynthesize = null;
        this.myOldSynthesize = null;
        OCSymbol symbol = OCElementUtil.getRawSymbolFromNamedElement(element);
        if (symbol != null) {
            OCSymbolWithQualifiedName owner;
            if (symbol instanceof OCStructSymbol) {
                OCRenameProcessor.prepareStruct((OCStructSymbol)symbol, newName, allRenames);
            } else if (!(symbol instanceof OCClassSymbol)) {
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol12);
                    return true;
                }));
            }
            if (symbol instanceof OCSymbolWithParent) {
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1);
                    return true;
                }, false, true);
            }
            if (symbol instanceof OCFunctionSymbol && (((OCFunctionSymbol)symbol).isCppConstructor() || ((OCFunctionSymbol)symbol).isCppDestructor()) && (owner = ((OCFunctionSymbol)symbol).getResolvedOwner()) instanceof OCStructSymbol) {
                OCRenameProcessor.addSymbol(newName, allRenames, owner);
                OCRenameProcessor.prepareStruct((OCStructSymbol)owner, newName, allRenames);
            }
            if ((symbol = symbol.getDefinitionSymbol()) != null) {
                element = symbol.locateDefinition();
                OCRenameProcessor.processAssociatedSymbols(symbol, new AssociatedElementsProcessor(){

                    @Override
                    public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                        OCRenameProcessor.this.prepareInstanceVariable(newName, allRenames, fromProperty, ivar);
                        return true;
                    }

                    @Override
                    public boolean processPropertyAccessors(OCPropertySymbol property) {
                        OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property);
                        return true;
                    }

                    @Override
                    public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                        OCRenameProcessor.this.prepareProperty(newName, allRenames, fromSymbol, property);
                        return true;
                    }

                    @Override
                    public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                        OCRenameProcessor.prepareClassAlias(newName, allRenames, clazz, alias);
                        return true;
                    }

                    @Override
                    public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                        OCRenameProcessor.prepareClass(newName, allRenames, alias, clazz, scope);
                        return true;
                    }
                }, scope);
            }
        }
        if (element instanceof OCFile) {
            OCRenameProcessor.prepareFile((OCFile)element, newName, allRenames, scope);
        } else if (element instanceof OCClassDeclaration) {
            clazz = (OCClassDeclaration)element;
            String category = clazz.getCategory();
            OCRenameProcessor.prepareClass(clazz.getName(), category, category != null ? newName + "+" + category : newName, allRenames, scope, element instanceof OCProtocol, element.getProject());
        } else if (element instanceof OCCategoryName) {
            clazz = (OCClassDeclaration)element.getParent();
            OCRenameProcessor.prepareClass(clazz.getName(), clazz.getCategory(), clazz.getName() + "+" + newName, allRenames, scope, false, element.getProject());
        }
        Iterator<PsiElement> iterator = allRenames.keySet().iterator();
        while (iterator.hasNext()) {
            if (OCSearchScope.isInProjectSources(iterator.next())) continue;
            iterator.remove();
        }
    }

    private static void addSymbol(String newName, Map<PsiElement, String> allRenames, OCSymbol symbol) {
        Object element;
        if (symbol != null && (element = symbol.locateDefinition()) != null) {
            allRenames.put((PsiElement)element, newName);
        }
    }

    public static void processAssociatedSymbols(OCSymbol symbol, AssociatedElementsProcessor processor2, SearchScope scope) {
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            OCInstanceVariableSymbol ivar = property.getAssociatedIvar();
            if (ivar != null && OCElementUtil.endsWithIgnoringFirstLetterCase(ivar.getName(), symbol.getName())) {
                ivar.processSameSymbols((Processor<OCSymbol>)((Processor)symbol14 -> processor2.processIvar((OCInstanceVariableSymbol)symbol14, property)));
            }
            property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol13 -> processor2.processPropertyAccessors((OCPropertySymbol)symbol13)));
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCPropertySymbol property = ivar.getAssociatedProperty();
            if (property != null && OCElementUtil.endsWithIgnoringFirstLetterCase(symbol.getName(), property.getName())) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> processor2.processProperty((OCPropertySymbol)symbol12, ivar)));
            }
        } else if (symbol instanceof OCMethodSymbol) {
            OCPropertySymbol property = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
            if (property == null) {
                OCMethodSymbol associatedSymbol = (OCMethodSymbol)symbol.getAssociatedSymbol();
                OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            }
            if (property != null) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)property1 -> processor2.processProperty((OCPropertySymbol)property1, symbol)));
            }
        } else if (symbol instanceof OCCompatibilityAliasSymbol) {
            OCClassSymbol clazz;
            OCCompatibilityAliasSymbol alias = (OCCompatibilityAliasSymbol)symbol;
            OCType type2 = alias.getResolvedType();
            if (type2 instanceof OCObjectType && (clazz = ((OCObjectType)type2).getClassSymbol()) != null && OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), alias.getName())) {
                processor2.processClass(alias, clazz);
            }
        } else if (symbol instanceof OCClassSymbol) {
            OCClassSymbol clazz = (OCClassSymbol)symbol;
            Project project2 = clazz.getProject();
            if (project2 == null) {
                return;
            }
            OCGlobalProjectSymbolsCache.processAliasNamesForType(project2, clazz.getName(), (Processor<String>)((Processor)s -> {
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)symbol1 -> {
                    if (symbol1 instanceof OCCompatibilityAliasSymbol && OCRenameProcessor.isInScope(symbol1, scope)) {
                        OCType type2 = symbol1.getResolvedType();
                        if (!(type2 instanceof OCObjectType)) {
                            return true;
                        }
                        OCClassSymbol classSymbol = ((OCObjectType)type2).getClassSymbol();
                        if (classSymbol == null || !classSymbol.equals(clazz)) {
                            return true;
                        }
                        if (OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), symbol1.getName()) && !processor2.processClassAlias(clazz, (OCCompatibilityAliasSymbol)symbol1)) {
                            return false;
                        }
                    }
                    return true;
                }), s);
                return true;
            }));
        }
    }

    private static boolean isInScope(OCSymbol symbol, SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || ((LocalSearchScope)scope).isInScope(symbol.getContainingFile());
    }

    private void prepareInstanceVariable(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, OCInstanceVariableSymbol ivar) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)ivar.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String newIvarName = OCRenameProcessor.getNewIvarName(newName, ivar.getName(), property.getName());
        if (ivar.isClang4ImplicitIvar()) {
            allRenames.put(new OCSymbolHolderVirtualPsiElement(ivar), newIvarName);
        } else if (settings.REFACTOR_PROPERTIES_AND_IVARS) {
            OCRenameProcessor.addSymbol(newIvarName, allRenames, ivar);
        } else {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ivar.processSynthesizes((Processor<OCSynthesizeSymbol>)finder);
            OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)finder.getFoundValue();
            if (synthesizeSymbol != null && !synthesizeSymbol.hasIvar()) {
                this.myOldSynthesize = (OCSynthesizeProperty)synthesizeSymbol.locateDefinition();
                this.myNewSynthesize = OCElementFactory.synthesize(newName, ivar.getName(), this.myOldSynthesize);
            }
        }
    }

    private static String getNewIvarName(String newPropName, String ivarName, String propName) {
        int prefixLength = ivarName.length() - propName.length();
        String suffix = newPropName;
        if (prefixLength < ivarName.length() && Character.isUpperCase(ivarName.charAt(prefixLength)) && (!Character.isUpperCase(propName.charAt(0)) || Character.isUpperCase(newPropName.charAt(0)) || prefixLength != 0 && Character.isLetter(ivarName.charAt(prefixLength - 1)))) {
            suffix = StringUtil.capitalize((String)suffix);
        }
        return ivarName.substring(0, prefixLength) + suffix;
    }

    private static void preparePropertyAccessors(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property) {
        ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == property) {
                if (symbol.isGetter() && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.GETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol), newName);
                } else if (symbol.isSetter() && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.SETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol), OCNameSuggester.getObjCSetterFromGetter(newName));
                }
            }
            return true;
        });
        property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method2 -> {
            String oldName = method2.getName();
            if (oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER)) || oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) + ":")) {
                return true;
            }
            OCRenameProcessor.addSymbol(OCElementUtil.startsWithWord(oldName, "set") ? "set" + StringUtil.capitalize((String)newName) : newName, allRenames, method2);
            List<OCMethodSymbol.SelectorPartSymbol> selectors = method2.getSelectors();
            OCDeclaratorSymbol parameter = selectors.get(0).getParameter();
            if (parameter != null && OCElementUtil.endsWithIgnoringFirstLetterCase(parameter.getName(), property.getName())) {
                OCRenameProcessor.addSymbol(OCRenameProcessor.getNewIvarName(newName, parameter.getName(), property.getName()), allRenames, parameter);
            }
            return true;
        }), true);
    }

    private void prepareProperty(String newName, Map<PsiElement, String> allRenames, OCSymbol fromSymbol, OCPropertySymbol property) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)fromSymbol.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        if (fromSymbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)fromSymbol;
            if (settings.REFACTOR_PROPERTIES_AND_IVARS || ivar.isClang4ImplicitIvar()) {
                String newPropertyName;
                String prefix = ivar.getName().substring(0, ivar.getName().length() - property.getName().length());
                if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
                    newPropertyName = newName.substring(prefix.length());
                    if (Character.isLowerCase(property.getName().charAt(0))) {
                        newPropertyName = StringUtil.decapitalize((String)newPropertyName);
                    }
                } else {
                    newPropertyName = newName;
                }
                OCRenameProcessor.addSymbol(newPropertyName, allRenames, property);
                OCRenameProcessor.preparePropertyAccessors(newPropertyName, allRenames, property);
            } else {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                ivar.processSynthesizes((Processor<OCSynthesizeSymbol>)finder);
                OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)finder.getFoundValue();
                if (synthesizeSymbol != null && !synthesizeSymbol.hasIvar()) {
                    this.myOldSynthesize = (OCSynthesizeProperty)synthesizeSymbol.locateDefinition();
                    this.myNewSynthesize = OCElementFactory.synthesize(property.getName(), newName, this.myOldSynthesize);
                }
            }
        } else if (fromSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol accessor = (OCMethodSymbol)fromSymbol;
            if (accessor.isSetter()) {
                String getter = OCNameSuggester.getObjCGetterFromSetter(newName);
                newName = getter != null ? getter : newName;
            }
            OCRenameProcessor.addSymbol(newName, allRenames, property);
            OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property);
        }
    }

    private static void prepareClassAlias(String newName, Map<PsiElement, String> allRenames, @NotNull OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
        int endPrefixIndex = clazz.getName().length() - alias.getName().length();
        String prefix = clazz.getName().substring(0, endPrefixIndex);
        if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)clazz.getProject()).getCustomSettings(OCCodeStyleSettings.class);
            if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
                String newAliasName = newName.substring(prefix.length());
                OCRenameProcessor.addSymbol(newAliasName, allRenames, alias);
            }
        }
    }

    private static void prepareFile(OCFile file2, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        if (!FileUtilRt.extensionEquals((String)newName, (String)FileUtilRt.getExtension((String)file2.getName()))) {
            allRenames.put(file2, newName);
            return;
        }
        Project project2 = file2.getProject();
        OCSymbol mainClass = file2.getSameNamedClass();
        if (mainClass instanceof OCClassSymbol) {
            OCRenameProcessor.prepareClass(mainClass.getName(), ((OCClassSymbol)mainClass).getCategoryName(), FileUtil.getNameWithoutExtension((String)newName), allRenames, scope, mainClass instanceof OCProtocolSymbol, project2);
        } else if (mainClass instanceof OCStructSymbol) {
            OCRenameProcessor.prepareStruct((OCStructSymbol)mainClass, FileUtil.getNameWithoutExtension((String)newName), allRenames);
        } else {
            OCRenameProcessor.processAssociatedFiles(file2, newName, allRenames);
        }
    }

    private static void processAssociatedFiles(OCFile file2, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put(file2, newName);
        file2 = file2.getAssociatedFileWithSameName();
        if (file2 != null) {
            allRenames.put(file2, FileUtil.getNameWithoutExtension((String)newName) + '.' + FileUtilRt.getExtension((String)file2.getName()));
        }
    }

    private static void prepareStruct(OCStructSymbol struct, String newName, Map<PsiElement, String> allRenames) {
        struct.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCStructSymbol struct1 = (OCStructSymbol)symbol;
            OCRenameProcessor.addSymbol(newName, allRenames, struct1);
            if (!struct1.isPredeclaration()) {
                Processor processor2 = symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1);
                    return true;
                };
                struct1.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true);
                struct1.processDestructors((Processor<OCFunctionSymbol>)processor2, true);
            }
            return true;
        }));
        OCFile file2 = struct.getContainingOCFile();
        if (file2 != null && FileUtil.getNameWithoutExtension((String)file2.getName()).equals(struct.getName())) {
            OCRenameProcessor.processAssociatedFiles(file2, newName + '.' + FileUtilRt.getExtension((String)file2.getName()), allRenames);
        }
    }

    private static void prepareClass(String newName, Map<PsiElement, String> allRenames, OCCompatibilityAliasSymbol alias, OCClassSymbol clazz, SearchScope scope) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)alias.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
            int endPrefixIndex = clazz.getName().length() - alias.getName().length();
            String prefix = clazz.getName().substring(0, endPrefixIndex);
            String newClassName = prefix + newName;
            String categoryName = clazz.getCategoryName();
            if (categoryName != null) {
                newClassName = newClassName + "+" + categoryName;
            }
            OCRenameProcessor.prepareClass(clazz.getName(), categoryName, newClassName, allRenames, scope, clazz instanceof OCProtocolSymbol, clazz.getProject());
        }
    }

    private static void prepareClass(String oldClassName, String oldCategoryName, String newName, Map<PsiElement, String> allRenames, SearchScope scope, boolean isProtocol, Project project2) {
        int categoryIdx = newName.lastIndexOf(43);
        String newClassName = categoryIdx > 0 ? newName.substring(0, categoryIdx) : newName;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCClassSymbol && OCRenameProcessor.isInScope(ocSymbol, scope) && isProtocol == ocSymbol instanceof OCProtocolSymbol) {
                boolean sameCategory = Comparing.equal((String)((OCClassSymbol)ocSymbol).getCategoryName(), (String)oldCategoryName);
                if (!sameCategory && oldClassName.equals(newClassName)) {
                    return true;
                }
                Object def = ocSymbol.locateDefinition();
                if (def != null) {
                    if (sameCategory) {
                        allRenames.put((PsiElement)def, newName);
                    } else {
                        allRenames.put((PsiElement)def, newClassName);
                    }
                    PsiFile file2 = def.getContainingFile();
                    String fileName = file2.getName();
                    String name = FileUtil.getNameWithoutExtension((String)fileName);
                    int categoryIdx1 = name.lastIndexOf(43);
                    String category = null;
                    if (categoryIdx1 > 0) {
                        category = name.substring(categoryIdx1 + 1);
                        name = name.substring(0, categoryIdx1);
                    }
                    if (name.equals(oldClassName)) {
                        if (Comparing.equal((String)oldCategoryName, (String)category)) {
                            allRenames.put((PsiElement)file2, newName + "." + FileUtilRt.getExtension((String)fileName));
                        } else {
                            allRenames.put((PsiElement)file2, newClassName + fileName.substring(name.length()));
                        }
                    }
                }
            }
            return true;
        }), oldClassName);
    }

    private static boolean isSetter(OCMethod method2) {
        return method2.getSelector().endsWith(":");
    }

    private static boolean isSetter(OCSendMessageExpression call) {
        return call.getMessageSelector().endsWith(":");
    }

    private static boolean isSetter(OCPropertyAttribute attribute) {
        return "setter".equals(attribute.getName());
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        return this.findReferences(element, null);
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, SearchScope scope) {
        Object elementToSearch = element;
        OCMethodSymbol accessor = null;
        if (OCRenameProcessor.isAccessor(element)) {
            accessor = (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            elementToSearch = accessor.getGeneratedFromProperty().locateDefinition();
        }
        if (elementToSearch == null) {
            return Collections.emptyList();
        }
        if (elementToSearch instanceof OCClassDeclaration && ((OCClassDeclaration)elementToSearch).getCategoryElement() != null) {
            return Collections.emptyList();
        }
        Collection result2 = ReferencesSearch.search((ReferencesSearch.SearchParameters)new OCElementInMacroSubstitutionReferenceSearch.MySearchParameters((PsiElement)elementToSearch, scope != null ? scope : elementToSearch.getUseScope(), false, true)).findAll();
        Iterator itr = result2.iterator();
        while (itr.hasNext()) {
            PsiElement usage = ((PsiReference)itr.next()).getElement();
            if (usage instanceof OCSendMessageExpression) {
                if (accessor != null && accessor.isSetter() == OCRenameProcessor.isSetter((OCSendMessageExpression)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCMethod) {
                if (accessor != null && accessor.isSetter() == OCRenameProcessor.isSetter((OCMethod)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCPropertyAttribute) {
                if (accessor != null && accessor.isSetter() == OCRenameProcessor.isSetter((OCPropertyAttribute)usage)) continue;
                itr.remove();
                continue;
            }
            if (accessor != null) {
                itr.remove();
                continue;
            }
            if (!(element instanceof OCDeclarator) || !(usage instanceof OCDeclarator)) continue;
            itr.remove();
        }
        return result2;
    }

    private static boolean isAccessor(PsiElement element) {
        return element instanceof OCSymbolHolderVirtualPsiElement && ((OCSymbolHolderVirtualPsiElement)element).getSymbol() instanceof OCMethodSymbol;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        ArrayList<UsageInfo> nonMacroUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            PsiElement refElement = usage.getElement();
            if (refElement != null && OCElementUtil.isPartOfMacroSubstitution(refElement)) {
                OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(refElement);
                if (macroRange != null && !macroRange.mapsToArguments() && element instanceof PsiNamedElement) {
                    OCDefineDirective macro;
                    String name = ((PsiNamedElement)element).getName();
                    OCMacroSymbol macroSymbol = macroRange.getMacroCall().resolveToSymbol();
                    OCDefineDirective oCDefineDirective = macro = macroSymbol != null ? (OCDefineDirective)macroSymbol.locateDefinition() : null;
                    if (macro != null) {
                        PsiElement macroNameId = macro.getNameIdentifier();
                        for (ASTNode child : macro.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER}))) {
                            PsiElement psi = child.getPsi();
                            if (psi == macroNameId || !psi.getText().equals(name)) continue;
                            OCElementUtil.replaceWithIdentifier(psi, newName, refElement);
                        }
                    }
                }
                FileSymbolTablesCache.getInstance(element.getProject()).scheduleReparseFile((OCFile)element.getContainingFile());
                continue;
            }
            nonMacroUsages.add(usage);
        }
        super.renameElement(element, newName, nonMacroUsages.toArray(new UsageInfo[nonMacroUsages.size()]), listener2);
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        OCSymbol symbol;
        OCSymbol duplicate = null;
        if (element instanceof OCCategoryName) {
            OCSymbol oCSymbol = symbol = (element = element.getParent()) instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            if (symbol instanceof OCClassSymbol) {
                duplicate = OCCodeInsightUtil.resolveNameInScope(symbol.getKind(), symbol.getName(), newName, null, element.getProject());
            }
        } else {
            if (element instanceof OCFile) {
                if (!OCSearchUtil.getProjectVirtualFilesByName(element.getProject(), newName).isEmpty()) {
                    conflicts.putValue((Object)element, (Object)("File '" + newName + "' already exists in the project"));
                }
                return;
            }
            symbol = element instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            String categoryName = symbol instanceof OCClassSymbol ? ((OCClassSymbol)symbol).getCategoryName() : null;
            PsiElement scope = symbol instanceof OCClassSymbol ? null : element;
            duplicate = OCCodeInsightUtil.resolveNameInScope(symbol != null ? symbol.getKind() : null, newName, categoryName, scope, element.getProject());
        }
        if (duplicate != null && (symbol == null || symbol.isGlobal() == duplicate.isGlobal())) {
            String scope = duplicate.isGlobal() ? duplicate.getContainingFile().getName() : "the scope";
            Object definition = duplicate.locateDefinition();
            if (definition != null) {
                conflicts.putValue(definition, (Object)(duplicate.getNameWithKindUppercase() + " already exists in " + scope));
            }
        }
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(@Nullable PsiElement element, @Nullable Editor editor) {
        OCSymbolWithQualifiedName struct;
        OCSymbol symbol;
        PsiElement originalElement = element;
        if (element instanceof OCDeclarator) {
            element = ((OCDeclarator)element).getExtendedContext();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            element = OCElementUtil.substituteNamedElementToRename(element, false);
        }
        if (element instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol()) != null && ((OCSymbolBase)symbol).getKind().isConstructorOrDestructor() && (struct = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner()) instanceof OCStructSymbol) {
            return struct.locateDefinition();
        }
        if (OCRenameProcessor.isAccessor(element) || element instanceof OCCallable) {
            OCSymbol oCSymbol = symbol = element instanceof OCCallable ? ((OCCallable)element).getSymbol() : (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                OCPropertySymbol property;
                OCPropertySymbol oCPropertySymbol = property = (symbol = symbol.getAssociatedSymbol()) != null ? ((OCMethodSymbol)symbol).getGeneratedFromProperty() : null;
                if (property != null) {
                    return property.locateDefinition();
                }
            }
            if (element instanceof OCCallable && !ApplicationManager.getApplication().isUnitTestMode()) {
                OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)element, element);
                if (!OCChangeSignatureActionHandler.checkVariableArguments(element.getProject(), editor, handler2)) {
                    handler2.invoke();
                }
                return null;
            }
        }
        return super.substituteElementToRename(originalElement, editor);
    }

    @Override
    public Runnable getPostRenameCallback(PsiElement element, String newName, RefactoringElementListener elementListener) {
        return () -> {
            if (this.myOldSynthesize != null) {
                this.myOldSynthesize.replace(this.myNewSynthesize);
                this.myNewSynthesize = null;
                this.myOldSynthesize = null;
            }
        };
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return true;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        Object symbol;
        return !(element instanceof OCSymbolDeclarator) || (symbol = ((OCSymbolDeclarator)element).getSymbol()) == null || !symbol.getKind().isLocal();
    }

    @Override
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        if (element instanceof OCClassDeclaration && ((OCClassDeclaration)element).getCategoryElement() != null) {
            return null;
        }
        if (element instanceof OCFile) {
            return null;
        }
        return element;
    }

    @NotNull
    public static RenameUsages validateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            if (!(processor2 instanceof OCRenameProcessor)) continue;
            return ((OCRenameProcessor)processor2).doValidateUsages(elementToRename, refUsages);
        }
        return RenameUsages.CANCEL;
    }

    public RenameUsages doValidateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        int code2;
        String message2;
        String oldName = elementToRename.getName();
        int nonCodeUsages = 0;
        OCSymbolBase badMacro = null;
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                if (this.skipNonCodeUsage(elementToRename, usageInfo)) continue;
                ++nonCodeUsages;
                filteredUsages.add(usageInfo);
                continue;
            }
            filteredUsages.add(usageInfo);
            if (!(usageInfo.getReference() instanceof OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)) continue;
            badMacro = ((OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)usageInfo.getReference()).getMacroSymbol();
        }
        refUsages.set((Object)filteredUsages.toArray(new UsageInfo[filteredUsages.size()]));
        if (badMacro != null) {
            String[] options;
            message2 = badMacro.getNameWithKindUppercase() + " has several usages with different mappings for \"" + oldName + "\". Rename may break the code. Would you like to proceed?";
            code2 = Messages.showDialog((String)message2, (String)"Rename", (String[])(options = new String[]{"Show usages", "Cancel", "Proceed"}), (int)0, (int)1, (Icon)Messages.getQuestionIcon(), null);
            if (code2 == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            if (code2 == 1 || code2 == -1) {
                return RenameUsages.CANCEL;
            }
        }
        if (nonCodeUsages > 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
            String[] options;
            message2 = nonCodeUsages + " usage" + (nonCodeUsages > 1 ? "s were" : " was") + " found in comments and non-code files.\nWould you like to rename " + (nonCodeUsages > 1 ? "them" : "it") + "?";
            code2 = Messages.showDialog((String)message2, (String)"Rename", (String[])(options = new String[]{"Show Usages", "Cancel", "Rename Only Code Usages", "Rename All Usages"}), (int)0, (int)2, (Icon)Messages.getQuestionIcon(), null);
            if (code2 == 3) {
                return RenameUsages.RENAME;
            }
            if (code2 == 2) {
                refUsages.set((Object)ContainerUtil.filter((Object[])((Object[])refUsages.get()), info -> !(info instanceof NonCodeUsageInfo)).toArray(UsageInfo.EMPTY_ARRAY));
                return RenameUsages.RENAME;
            }
            if (code2 == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            return RenameUsages.CANCEL;
        }
        return RenameUsages.RENAME;
    }

    private boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo) {
        PsiElement parent;
        PsiElement element = usageInfo.getElement();
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof OCLocalizedString) {
            return true;
        }
        if (element != null && parent instanceof OCLiteralExpression && elementToRename instanceof OCLocalizedString) {
            OCReferenceElement macro;
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)parent, OCMacroCall.class);
            OCReferenceElement oCReferenceElement = macro = macroCall != null ? macroCall.getMacroReferenceElement() : null;
            if (macro != null && macro.getName().startsWith("NSLocalizedString")) {
                return true;
            }
        }
        for (OCRenameProcessorExtension each : (OCRenameProcessorExtension[])Extensions.getExtensions(OCRenameProcessorExtension.EP)) {
            if (!each.skipNonCodeUsage(elementToRename, usageInfo)) continue;
            return true;
        }
        return false;
    }

    public static enum RenameUsages {
        RENAME,
        CANCEL,
        SHOW_USAGES;

    }

    static interface AssociatedElementsProcessor {
        public boolean processIvar(OCInstanceVariableSymbol var1, OCPropertySymbol var2);

        public boolean processPropertyAccessors(OCPropertySymbol var1);

        public boolean processProperty(OCPropertySymbol var1, OCSymbol var2);

        public boolean processClassAlias(OCClassSymbol var1, OCCompatibilityAliasSymbol var2);

        public boolean processClass(OCCompatibilityAliasSymbol var1, OCClassSymbol var2);
    }
}

