/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnresolvedReferenceRenamer
extends VariableInplaceRenamer {
    private PsiFile myFile;
    private PsiReference myReference;

    public OCUnresolvedReferenceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull Project project2, @NotNull PsiReference reference, @Nullable String initialName, @Nullable String oldName) {
        super(elementToRename, editor, project2, initialName, oldName);
        this.myFile = file2;
        this.myReference = reference;
        this.myInitialName = initialName;
    }

    @Override
    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        final ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        final String referenceName = this.myReference.getCanonicalText();
        this.myFile.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    if (!reference.getCanonicalText().equals(referenceName) || reference.resolve() != null || reference.getElement() instanceof OCDeclarator) continue;
                    refs.add(reference);
                }
            }
        });
        return refs;
    }

    @Override
    protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
        TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myFile, this.myReference.getCanonicalText(), true, (PairProcessor<PsiElement, TextRange>)((PairProcessor)(psiElement, textRange) -> {
            if (psiElement.getContainingFile() == this.myFile) {
                stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
            }
            return true;
        }));
    }

    @Override
    public boolean performInplaceRename() {
        this.myNameSuggestions = null;
        Collection<PsiReference> refs = this.collectRefs((SearchScope)new LocalSearchScope((PsiElement)this.myFile));
        this.myEditor.putUserData(INPLACE_RENAMER, (Object)this);
        ourRenamersStack.push((Object)this);
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            HashSet<String> suggestions = new HashSet<String>();
            if (element instanceof OCQualifiedExpression) {
                OCType qualifierType = ((OCQualifiedExpression)element).getQualifier().getResolvedType();
                OCSymbolGroupContext symbolContext = ((OCQualifiedExpression)element).getSymbolContext();
                ((OCQualifiedExpression)element).processTargets(null, this.getProcessor((OCExpression)element, qualifierType, symbolContext, suggestions), false, OCTokenTypes.DEREF, true, false, null);
            } else {
                if (!(element instanceof OCReferenceElement) || !(element.getParent() instanceof OCReferenceExpression)) continue;
                OCSymbolGroupContext symbolContext = ((OCReferenceElement)element).getSymbolContext();
                if (symbolContext != null) {
                    OCResolveUtil.processLocalAndMemberSymbols(null, element, this.getProcessor((OCExpression)element.getParent(), null, symbolContext, suggestions));
                }
            }
            if (this.myNameSuggestions == null) {
                this.myNameSuggestions = new LinkedHashSet<String>(suggestions);
                continue;
            }
            this.myNameSuggestions.retainAll(suggestions);
        }
        ArrayList<Pair<PsiElement, TextRange>> stringUsages = new ArrayList<Pair<PsiElement, TextRange>>();
        this.collectAdditionalElementsToRename(stringUsages);
        return this.buildTemplateAndStart(refs, stringUsages, (PsiElement)this.myFile, this.myFile);
    }

    private Processor<OCSymbol> getProcessor(OCExpression expression2, @Nullable OCType qualifierType, @Nullable OCSymbolGroupContext symbolContext, Set<String> suggestions) {
        OCType type2 = OCExpectedTypeUtil.getExpectedType(expression2).resolve(this.myFile);
        return symbol -> {
            if ((symbolContext == null || symbolContext.isSuitableSymbol((OCSymbol)symbol)) && (type2.isUnknown() || type2.isCompatible(symbol.getResolvedType(), expression2) || symbol.getResolvedType().isCompatible(type2, expression2)) && OCVisibility.isVisible(symbol, expression2, qualifierType) && this.isIdentifier(symbol.getName(), OCLanguage.getInstance())) {
                suggestions.add(symbol.getName());
            }
            return true;
        };
    }

    @Override
    protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
        PsiElement element = this.myReference.getElement();
        this.restoreCaretOffset(element.getTextOffset());
        JBPopupFactory.getInstance().createConfirmation("Inserted identifier is not valid", "Continue editing", "Cancel", () -> {
            OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, this.myEditor, this.myFile, this.myProject, this.myReference, newName, this.myOldName);
            ((VariableInplaceRenamer)renamer).performInplaceRename();
        }, 0).showInBestPositionFor(this.myEditor);
    }

    @Override
    public String getInitialName() {
        return this.myInitialName != null ? this.myInitialName : this.myReference.getCanonicalText();
    }

    @Override
    protected String getCommandName() {
        return "Rename reference";
    }

    @Override
    protected void showDialogAdvertisement(String actionId) {
    }
}

