/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentsList<E extends OCTypeOwner> {
    @NotNull
    private List<OCType> types;
    @Nullable
    private List<E> exprs;
    private boolean nonExpandedVariadics;

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs, boolean nonExpandedVariadics) {
        this.types = Collections.unmodifiableList(types);
        this.exprs = exprs != null ? Collections.unmodifiableList(exprs) : null;
        this.nonExpandedVariadics = nonExpandedVariadics;
    }

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs) {
        this(types, exprs, false);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList) {
        return OCArgumentsList.getArgumentList(expressionsList, null);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList, @Nullable OCResolveContext context) {
        ArrayList<OCType> types = new ArrayList<OCType>();
        boolean nonExpandedVariadics = false;
        ArrayList<OCExpression> expressions2 = new ArrayList<OCExpression>();
        for (OCExpression expression2 : expressionsList) {
            if (expression2 instanceof OCVariadicPackExpression) {
                nonExpandedVariadics = true;
                continue;
            }
            expressions2.add(expression2);
            types.add(expression2.getResolvedType(context != null ? context : new OCResolveContext(expression2)));
        }
        return new OCArgumentsList<OCExpression>(types, expressions2, nonExpandedVariadics);
    }

    @NotNull
    public static OCArgumentsList<OCExpressionSymbol> expandVariadicExpressions(@NotNull List<OCExpressionSymbol> expressionsList, @NotNull OCResolveContext context) {
        ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
        ArrayList<OCExpressionSymbol> expandedExprs = new ArrayList<OCExpressionSymbol>();
        boolean nonExpandedVariadics = false;
        for (OCExpressionSymbol expression2 : expressionsList) {
            if (expression2 instanceof OCVariadicPackExpressionSymbol) {
                List<OCType> expansions = ((OCVariadicPackExpressionSymbol)expression2).getExpandedResolvedTypes(context);
                if (expansions != null) {
                    for (OCType type2 : expansions) {
                        expandedExprs.add(((OCVariadicPackExpressionSymbol)expression2).getExpression());
                        expandedTypes.add(type2);
                    }
                    continue;
                }
                nonExpandedVariadics = true;
                continue;
            }
            expandedExprs.add(expression2);
            expandedTypes.add(expression2.getResolvedType(context));
        }
        return new OCArgumentsList<OCExpressionSymbol>(expandedTypes, expandedExprs, nonExpandedVariadics);
    }

    @NotNull
    public static <T extends OCTypeArgument> List<T> expandVariadicTypes(@NotNull List<T> types, @NotNull OCResolveContext context) {
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        if (context.isDontExpandVariadics()) {
            return types;
        }
        for (OCTypeArgument type2 : types) {
            List<OCTypeArgument> expandedTypes = null;
            if (type2 instanceof OCVariadicType) {
                OCType underlyingType = ((OCVariadicType)type2).getUnderlyingType();
                expandedTypes = OCArgumentsList.expandExpansionPacks(underlyingType, context);
                if (expandedTypes == null) {
                    expandedTypes = OCArgumentsList.expandVariadicType(underlyingType, context);
                }
            } else if (type2.isVariadic()) {
                expandedTypes = OCArgumentsList.expandVariadicPackExpression((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)type2).getSymbol(), context);
            }
            if (expandedTypes != null) {
                result2.addAll(expandedTypes);
                continue;
            }
            result2.add(type2);
        }
        return result2;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandExpansionPacks(@NotNull OCType type2, final @NotNull OCResolveContext context) {
        final Ref expansionsCnt = new Ref();
        OCType resolvedType = type2.resolve(context);
        resolvedType.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitExpansionPackType(OCExpansionPackType type2) {
                OCLog.LOG.assertTrue(expansionsCnt.isNull() || ((Integer)expansionsCnt.get()).intValue() == type2.getExpansionsCnt(), (Object)context.getFile());
                expansionsCnt.set((Object)type2.getExpansionsCnt());
                return true;
            }
        });
        if (!expansionsCnt.isNull()) {
            ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
            int i2 = 0;
            while (i2 < (Integer)expansionsCnt.get()) {
                final int expansionIndex = i2++;
                expandedTypes.add(resolvedType.accept(new OCNonPrimitiveTypeCloneVisitor(){

                    @Override
                    public OCType visitExpansionPackType(OCExpansionPackType type2) {
                        OCTypeArgument argument;
                        if (expansionIndex < type2.getExpansionsCnt() && (argument = type2.getExpansions().get(expansionIndex)) instanceof OCType) {
                            return (OCType)argument;
                        }
                        return OCUnknownType.INSTANCE;
                    }
                }));
            }
            return expandedTypes;
        }
        return null;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicPackExpression(@NotNull OCVariadicPackExpressionSymbol expressionSymbol, @NotNull OCResolveContext context) {
        final OCExpressionSymbol symbol = expressionSymbol.getExpression();
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCTypeArgument>(){

            public OCTypeArgument fun(OCResolveContext context) {
                return symbol.evaluateToTypeArgument(context);
            }
        }, new OCTypeOwner(){

            @Override
            @Nullable
            public OCType getResolvedType(@NotNull OCResolveContext context) {
                return symbol.getResolvedType(context);
            }
        }, context);
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicType(final @NotNull OCType underlyingType, @NotNull OCResolveContext context) {
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCType>(){

            @Nullable
            public OCType fun(@NotNull OCResolveContext context2) {
                return context2.getSubstitution().substitute(underlyingType, context2);
            }
        }, new OCTypeOwner(){

            @Override
            @Nullable
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                return underlyingType.resolve(context2);
            }
        }, context);
    }

    @Nullable
    public static List<OCType> getExpandedResolvedTypes(final @NotNull OCTypeOwner operand2, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        return OCArgumentsList.getExpandedResolvedTypes(new Function<OCResolveContext, OCType>(){

            public OCType fun(OCResolveContext context) {
                return operand2.getResolvedType(context);
            }
        }, dependency, context);
    }

    @Nullable
    public static <T extends OCTypeArgument> List<T> getExpandedResolvedTypes(@NotNull Function<OCResolveContext, T> operand2, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        while (context.isVariadicExpansionMode()) {
            context = context.getOriginalContext();
        }
        Set<OCTypeParameterSymbol> dependencies = OCArgumentsList.getTypeParameterDependencies(dependency, context);
        List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> expansions = OCArgumentsList.getExpansions(dependencies, context);
        if (expansions == null || expansions.isEmpty()) {
            return null;
        }
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        for (int i2 = 0; i2 < ((OCExpansionPackType)expansions.get((int)0).second).getExpansionsCnt(); ++i2) {
            Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
            for (Pair<OCTypeParameterSymbol, OCExpansionPackType> expansion : expansions) {
                map2.put((OCTypeParameterSymbol)expansion.first, ((OCExpansionPackType)expansion.second).getExpansions().get(i2));
            }
            OCResolveContext resolveContext = context.substitute(OCSimpleTypeSubstitution.create(map2), true, false);
            resolveContext.setVariadicExpansionMode(true);
            OCTypeArgument argument = (OCTypeArgument)operand2.fun((Object)resolveContext);
            if (argument == null) {
                return null;
            }
            result2.add(argument);
        }
        return result2;
    }

    @Nullable
    private static List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> getExpansions(@NotNull Set<OCTypeParameterSymbol> dependencies, @NotNull OCResolveContext context) {
        HashSet processed2 = new HashSet();
        ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>> pairs = new ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>>();
        if (!context.getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)arg_0 -> OCArgumentsList.lambda$getExpansions$0(dependencies, (Set)processed2, pairs, arg_0)))) {
            return null;
        }
        return pairs;
    }

    @NotNull
    private static Set<OCTypeParameterSymbol> getTypeParameterDependencies(@NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        OCResolveContext contextWithoutSubstitutions = context.clearSubstitution();
        contextWithoutSubstitutions.setDontExpandVariadics(true);
        OCType resolvedDependency = dependency.getResolvedType(contextWithoutSubstitutions);
        return contextWithoutSubstitutions.getTypeDependencies(resolvedDependency);
    }

    @NotNull
    public List<OCType> getTypes() {
        return this.types;
    }

    @Nullable
    public List<E> getExprs() {
        return this.exprs;
    }

    public int getCount() {
        return this.types.size();
    }

    public boolean hasNonExpandedVariadics() {
        return this.nonExpandedVariadics;
    }

    private static /* synthetic */ boolean lambda$getExpansions$0(@NotNull Set dependencies, Set processed2, List pairs, Map.Entry entry) {
        OCTypeParameterSymbol parameter = (OCTypeParameterSymbol)entry.getKey();
        OCTypeArgument argument = (OCTypeArgument)entry.getValue();
        if (dependencies.contains(parameter) && !processed2.contains(parameter) && argument instanceof OCExpansionPackType) {
            processed2.add(parameter);
            if (!pairs.isEmpty() && ((OCExpansionPackType)((Pair)pairs.get((int)0)).second).getExpansionsCnt() != ((OCExpansionPackType)argument).getExpansionsCnt()) {
                return false;
            }
            pairs.add(Pair.create((Object)parameter, (Object)((OCExpansionPackType)argument)));
        }
        return true;
    }
}

