/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.resolve.OCExprSymbolClassifier;
import com.jetbrains.cidr.lang.resolve.OCPsiExprClassifierVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCExprValueCategory {
    LValue,
    PRValue,
    XValue;


    public boolean isLValue() {
        return this == LValue;
    }

    public boolean isRValue() {
        return this == PRValue || this == XValue;
    }

    public boolean isGLValue() {
        return this == LValue || this == XValue;
    }

    @NotNull
    public static OCExprValueCategory classify(@Nullable OCExpression expr) {
        return OCExprValueCategory.classify(expr, new OCResolveContext(expr));
    }

    @NotNull
    public static OCExprValueCategory classify(@Nullable OCTypeOwner expr, @NotNull OCResolveContext context) {
        if (expr instanceof OCExpression) {
            OCForeachStatement foreach = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)((OCExpression)expr), OCForeachStatement.class);
            if (foreach != null && foreach.isCpp11Foreach() && expr == foreach.getCollectionExpression()) {
                return LValue;
            }
            OCPsiExprClassifierVisitor visitor = new OCPsiExprClassifierVisitor(context);
            ((OCExpression)expr).accept(visitor);
            return visitor.getResult();
        }
        if (expr instanceof OCExpressionSymbol) {
            return new OCExprSymbolClassifier(context).classify((OCExpressionSymbol)expr);
        }
        return PRValue;
    }
}

