/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.TemplatesUtils;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveOverloadsUtil {
    private static final int MAX_FUNCTIONS_TO_FILTER_OUT_IDENTICAL = 6;

    @Nullable
    public static OCSymbol resolveConstructorOverloads(@NotNull OCStructType type2, Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable OCType leftType, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs, boolean allowImplicitConversions, boolean acceptOnlyCompatible, @NotNull OCResolveContext context) {
        OCSymbol<PsiElement> badResult = type2.getSymbol();
        List<?> argExprs = arguments.getExprs();
        if (argExprs != null && argExprs.size() == 1 && argExprs.get(0) instanceof OCCompoundInitializer) {
            cases = new LinkedHashSet<OCSymbol>(cases);
            if (OCCodeInsightUtil.isInitializerListType(type2, context.getFile())) {
                return type2.getSymbol();
            }
            OCCompoundInitializer compInitializer = (OCCompoundInitializer)argExprs.get(0);
            arguments = OCArgumentsList.getArgumentList(compInitializer.getInitializerExpressions(), context);
            ArrayList<OCSymbol> ctorsWithInitList = new ArrayList<OCSymbol>();
            OCSymbol result2 = OCResolveOverloadsUtil.findCtorWithInitializerList(type2, arguments, ctorsWithInitList, context.getFile(), allowImplicitConversions);
            cases.removeAll(ctorsWithInitList);
            if (result2 != null) {
                return result2;
            }
            if (ctorsWithInitList.size() == 1) {
                badResult = (OCSymbol)ctorsWithInitList.get(0);
            }
            if (!allowImplicitConversions) {
                return badResult;
            }
        }
        if (badResult instanceof OCFunctionSymbol || arguments.getCount() == 1 && type2.checkCompatible(arguments.getTypes().get(0), null, context.getElement(), allowImplicitConversions, true, context).getState() == OCType.TypeCheckState.OK) {
            filterByTemplates = true;
            filterByParameters = true;
        }
        if (type2.isMagicInside(context)) {
            filterAmbigs = false;
        }
        OCSymbol result3 = OCResolveOverloadsUtil.resolveOverloads(cases, arguments, leftType, null, null, filterByParameters, filterByTemplates, filterAmbigs, allowImplicitConversions, type2.isMagicInside(context) || type2.hasSeveralSpecializations(), context);
        return result3 != null || acceptOnlyCompatible ? result3 : badResult;
    }

    private static boolean hasUnevaluatedSubstitutions(@NotNull OCSymbol symbol) {
        Ref result2 = Ref.create((Object)false);
        if (symbol instanceof OCSymbolWithSubstitution) {
            ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)entry -> {
                OCTypeArgument arg = (OCTypeArgument)entry.getValue();
                if (arg instanceof OCExpressionTypeArgument && !(((OCExpressionTypeArgument)arg).getSymbol() instanceof OCLiteralExpressionSymbol)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }));
        }
        return (Boolean)result2.get();
    }

    @Nullable
    public static OCSymbol resolveOverloads(@NotNull Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable OCType leftType, @Nullable OCExprValueCategory leftValueCategory, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs, boolean allowImplicitConversions, boolean hasMagic, @NotNull OCResolveContext context) {
        Collection filteredByFunctions = cases.stream().filter(s -> s instanceof OCFunctionSymbol || s instanceof OCStructSymbol).collect(Collectors.toList());
        if (!cases.isEmpty() && filteredByFunctions.isEmpty()) {
            return (OCSymbol)ContainerUtil.getFirstItem(cases);
        }
        hasMagic |= arguments.hasNonExpandedVariadics();
        filterByParameters |= context.isInSFINAE();
        CVQualifiers cvQualifiers = leftType != null ? leftType.getCVQualifiers() : null;
        List<OCSymbol> filtered = OCResolveOverloadsUtil.resolveTemplateSpecializations(cases, arguments, cvQualifiers, operatorPlacement, filterByTemplates, allowImplicitConversions, context);
        if (leftValueCategory == null) {
            leftValueCategory = OCExprValueCategory.XValue;
        }
        if (!filterByParameters) {
            if (filtered.size() == 1) {
                return (OCSymbol)ContainerUtil.getFirstItem(filtered);
            }
            if (filtered.size() == 0) {
                return filterByTemplates ? null : OCResolveOverloadsUtil.groupAmbiguousFunctions(new ArrayList<OCSymbol>(cases), context, filterAmbigs && !hasMagic, OCFunctionGroupSymbol.Cause.NoViable);
            }
        }
        ArrayList<Overload> viable = new ArrayList<Overload>(filtered.size());
        block0: for (OCSymbol oCSymbol : filtered) {
            List<Object> paramTypes;
            ProgressManager.checkCanceled();
            ArrayList<ImplicitConversionSequence> paramConversions = new ArrayList<ImplicitConversionSequence>(arguments.getCount());
            if (oCSymbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)oCSymbol;
                paramTypes = OCResolveOverloadsUtil.getParameterTypes(function, operatorPlacement, context, cvQualifiers);
                OCSymbolWithQualifiedName resolvedOwner = function.getResolvedOwner(context, false);
                if (resolvedOwner != null && OCResolveOverloadsUtil.hasUnevaluatedSubstitutions(resolvedOwner)) {
                    paramConversions.add(ImplicitConversionSequence.magic());
                } else if (leftType != null && !function.isCppConstructor() && resolvedOwner instanceof OCStructSymbol) {
                    OCStructType objectType = ((OCStructSymbol)resolvedOwner).getType();
                    ImplicitConversionSequence conversion = null;
                    if (leftType instanceof OCCppReferenceType) {
                        leftType = ((OCCppReferenceType)leftType).getRefType();
                    }
                    if (leftType.isMagicInside(context) || leftType instanceof OCStructType && ((OCStructType)leftType).hasSeveralSpecializations() || objectType.isMagicInside(context)) {
                        conversion = ImplicitConversionSequence.magic();
                    } else if (!function.isFriendOrStatic()) {
                        if (!(leftType instanceof OCStructType) && (!(leftType instanceof OCPointerType) || !(((OCPointerType)leftType).getRefType() instanceof OCStructType))) continue;
                        conversion = Conversions.TryObjectArgumentInitialization(objectType, leftType, function, leftValueCategory, context);
                    }
                    if (conversion != null) {
                        if (conversion.isBad()) continue;
                        paramConversions.add(conversion);
                    }
                }
            } else {
                paramTypes = oCSymbol instanceof OCStructSymbol ? Collections.singletonList(((OCStructSymbol)oCSymbol).getType()) : Collections.emptyList();
            }
            for (int i2 = 0; i2 < arguments.getCount(); ++i2) {
                List<OCType> parameterTypes;
                ProgressManager.checkCanceled();
                OCEllipsisType declType = i2 >= paramTypes.size() ? OCEllipsisType.instance() : ((OCType)paramTypes.get(i2)).resolve(context);
                OCType actualType = arguments.getTypes().get(i2);
                if (declType instanceof OCAutoType) continue;
                if (OCTypeUtils.isUnresolvedLambdaAutoType(actualType) && declType.getTerminalType() instanceof OCFunctionType && ((actualType = OCTypeUtils.resolveLambdaAutoType(actualType, context, new OCArgumentsList(parameterTypes = ((OCFunctionType)declType.getTerminalType()).getParameterTypes(), null), true)) == null || actualType == OCUnknownType.INSTANCE)) continue block0;
                OCTypeOwner argExpression = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(i2) : null;
                ImplicitConversionSequence conversion = Conversions.calculateConversion(argExpression, actualType, declType, allowImplicitConversions, true, false, false, context);
                paramConversions.add(conversion);
                if (conversion.isBad()) continue block0;
            }
            if (("operator++".equals(oCSymbol.getName()) || "operator--".equals(oCSymbol.getName())) && (operatorPlacement == OCOperatorReference.OperatorPlacement.POSTFIX && paramTypes.size() == arguments.getCount() || operatorPlacement == OCOperatorReference.OperatorPlacement.PREFIX && paramTypes.size() == arguments.getCount() + 1)) continue;
            viable.add(new Overload(oCSymbol, paramConversions));
        }
        Overload bestViable = null;
        for (Overload overload : viable) {
            hasMagic |= overload.myHasMagic;
            if (bestViable != null && !overload.myHasMagic && !OCResolveOverloadsUtil.isBetterOverload(overload, bestViable, arguments.getCount(), context)) continue;
            bestViable = overload;
        }
        if (bestViable == null) {
            if (filterByParameters) {
                return null;
            }
            if (filtered.size() > 1) {
                return OCResolveOverloadsUtil.groupAmbiguousFunctions(filtered, context, filterAmbigs && !hasMagic, OCFunctionGroupSymbol.Cause.NoViable);
            }
            return (OCSymbol)ContainerUtil.getFirstItem(filtered);
        }
        ArrayList<OCSymbol> arrayList = new ArrayList<OCSymbol>();
        for (Overload overload : viable) {
            ProgressManager.checkCanceled();
            if (overload != bestViable && !bestViable.myHasMagic && !overload.myHasMagic && OCResolveOverloadsUtil.isBetterOverload(bestViable, overload, arguments.getCount(), context)) continue;
            arrayList.add(overload.mySymbol);
            if (!(overload.mySymbol instanceof OCSymbolWithSubstitution) || !OCResolveUtil.hasNonResolvedTemplateParameters((OCSymbolWithSubstitution)((Object)overload.mySymbol), context)) continue;
            hasMagic = true;
        }
        if (arrayList.size() > 1) {
            return OCResolveOverloadsUtil.groupAmbiguousFunctions(arrayList, context, filterAmbigs && !hasMagic, hasMagic ? OCFunctionGroupSymbol.Cause.Magic : OCFunctionGroupSymbol.Cause.Ambiguous);
        }
        return bestViable.mySymbol;
    }

    private static boolean isBetterOverload(@NotNull Overload overload1, @NotNull Overload overload2, int argCount, @NotNull OCResolveContext context) {
        OCTemplateSymbol BetterTemplate;
        boolean Cand2IsSpecialization;
        OCSymbol Cand1 = overload1.mySymbol;
        OCSymbol Cand2 = overload2.mySymbol;
        boolean HasBetterConversion = false;
        int arg1Index = 0;
        int arg2Index = 0;
        if (overload1.myConversionSequences.size() == overload2.myConversionSequences.size() + 1) {
            arg1Index = 1;
        } else if (overload1.myConversionSequences.size() + 1 == overload2.myConversionSequences.size()) {
            arg2Index = 1;
        } else assert (overload1.myConversionSequences.size() == overload2.myConversionSequences.size()) : "Incorrect num of conversions";
        while (arg1Index < overload1.myConversionSequences.size()) {
            switch (Conversions.CompareImplicitConversionSequences(overload1.myConversionSequences.get(arg1Index), overload2.myConversionSequences.get(arg2Index), context)) {
                case Better: {
                    HasBetterConversion = true;
                    break;
                }
                case Worse: {
                    return false;
                }
            }
            ++arg1Index;
            ++arg2Index;
        }
        if (HasBetterConversion) {
            return true;
        }
        boolean Cand1IsSpecialization = Cand1 instanceof OCFunctionSymbol && ((OCFunctionSymbol)Cand1).isTemplateSymbol();
        boolean bl = Cand2IsSpecialization = Cand2 instanceof OCFunctionSymbol && ((OCFunctionSymbol)Cand2).isTemplateSymbol();
        if (Cand1IsSpecialization != Cand2IsSpecialization) {
            return Cand2IsSpecialization;
        }
        if (Cand1IsSpecialization && Cand2IsSpecialization && (BetterTemplate = TemplatesUtils.getMoreSpecializedTemplate((OCFunctionSymbol)Cand1, (OCFunctionSymbol)Cand2, argCount, context)) != null) {
            return BetterTemplate == Cand1;
        }
        return false;
    }

    @NotNull
    public static List<OCType> getParameterTypes(@NotNull OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context, @Nullable CVQualifiers cvQualifiers) {
        List<OCType> paramTypes = OCArgumentsList.expandVariadicTypes(function.getType().getParameterTypes(), context);
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ArrayList<OCType> newParamTypes = new ArrayList<OCType>(paramTypes.size() + 1);
            OCStructType objectType = ((OCStructSymbol)function.getResolvedOwner(context, false)).getType();
            if (cvQualifiers != null) {
                objectType = (OCStructType)objectType.cloneWithAddedCVQualifiers(cvQualifiers, context.getProject());
            }
            newParamTypes.add(objectType);
            newParamTypes.addAll(paramTypes);
            paramTypes = newParamTypes;
        }
        return paramTypes;
    }

    private static boolean needsPseudoParamAdded(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        return operatorPlacement != null && function.isCppMemberOperator(context);
    }

    private static int getNonInitializedParametersCount(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        int parametersCount = function.getNonInitializedParametersCount(context);
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ++parametersCount;
        }
        return parametersCount;
    }

    private static OCSymbol filterPredeclarations(Collection<OCSymbol> cases) {
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCFunctionSymbol) || symbol.isPredeclaration()) continue;
            return symbol;
        }
        for (OCSymbol symbol : cases) {
            if (symbol.isPredeclaration()) continue;
            return symbol;
        }
        Iterator<OCSymbol> iterator = cases.iterator();
        if (iterator.hasNext()) {
            OCSymbol symbol;
            symbol = iterator.next();
            return symbol;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static OCSymbol groupAmbiguousFunctions(List<OCSymbol> symbols, @NotNull OCResolveContext context, boolean filterAmbigs, OCFunctionGroupSymbol.Cause cause) {
        OCSymbol implicitConstructorDef = null;
        OCSymbol implicitConstructorPredef = null;
        Collections.sort(symbols, (f1, f2) -> OCSymbolOffsetUtil.compare(f1.getComplexOffset(), f2.getComplexOffset()));
        ArrayList<FuncDescriptor> allFunctions = new ArrayList<FuncDescriptor>(symbols.size());
        for (OCSymbol oCSymbol : symbols) {
            if (oCSymbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol func = (OCFunctionSymbol)oCSymbol;
                OCQualifiedName qn = func.getResolvedQualifiedName();
                if (qn == null) {
                    OCLog.LOG.warn("null qn " + func.getName());
                    continue;
                }
                allFunctions.add(new FuncDescriptor((OCFunctionSymbol)oCSymbol, (OCFunctionType)func.getType().resolve(context), qn, context));
                continue;
            }
            if (!(oCSymbol instanceof OCStructSymbol)) continue;
            if (oCSymbol.isPredeclaration()) {
                implicitConstructorPredef = oCSymbol;
                continue;
            }
            implicitConstructorDef = oCSymbol;
        }
        ArrayList<Object> differentFunctions = new ArrayList<Object>(allFunctions.size());
        if (allFunctions.size() < 6) {
            for (FuncDescriptor newFunc : allFunctions) {
                boolean distinguishable = true;
                for (FuncDescriptor existingFunc : differentFunctions) {
                    if (!newFunc.isUndistinguishable(existingFunc)) continue;
                    distinguishable = false;
                    break;
                }
                if (!distinguishable) continue;
                differentFunctions.add(newFunc);
            }
        } else if (!allFunctions.isEmpty()) {
            void var8_11;
            Object var8_10 = null;
            boolean allUndistinguishable = true;
            for (FuncDescriptor function : allFunctions) {
                if (var8_11 == null) {
                    FuncDescriptor funcDescriptor = function;
                    continue;
                }
                if (var8_11.isUndistinguishable(function)) continue;
                allUndistinguishable = false;
                break;
            }
            if (allUndistinguishable) {
                differentFunctions.add(var8_11);
            } else {
                differentFunctions.addAll(allFunctions);
            }
        }
        Object var8_14 = null;
        for (FuncDescriptor desc : differentFunctions) {
            void var8_15;
            OCType returnType = desc.symbol.getType().getReturnType().resolve(context);
            if (var8_15 == null) {
                OCType oCType = returnType;
                continue;
            }
            if (new OCTypeEqualityVisitor((OCType)var8_15, true, false, false, false, false, true, false, context).equal(returnType)) continue;
            Object var8_17 = null;
            break;
        }
        if (differentFunctions.size() == 1) {
            return ((FuncDescriptor)differentFunctions.get((int)0)).symbol;
        }
        if (differentFunctions.size() > 1) {
            void var8_18;
            return filterAmbigs ? null : new OCFunctionGroupSymbol(differentFunctions.stream().map(d -> d.symbol).collect(Collectors.toList()), (OCType)var8_18, cause);
        }
        if (implicitConstructorDef != null) {
            return implicitConstructorDef;
        }
        if (implicitConstructorPredef != null) {
            return implicitConstructorPredef;
        }
        return null;
    }

    private static OCSymbol findCtorWithInitializerList(OCStructType clazz, final @NotNull OCArgumentsList<?> arguments, final Collection<OCSymbol> allCandidates, final @Nullable PsiFile file2, final boolean implicitCtors) {
        final Ref result2 = new Ref();
        final OCResolveContext context = new OCResolveContext((PsiElement)file2);
        clazz.processMembers(clazz.getSymbol().getName(), new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCFunctionSymbol function;
                if (symbol instanceof OCFunctionSymbol && (function = (OCFunctionSymbol)symbol).isCppConstructor() && function.getNonInitializedParametersCount(context) == 1) {
                    OCType paramType = function.getParameterSymbols().get(0).getType().resolve(file2);
                    if (paramType instanceof OCCppReferenceType) {
                        paramType = ((OCCppReferenceType)paramType).getRefType();
                    }
                    if (paramType instanceof OCStructType) {
                        OCStructSymbol paramTypeSymbol = ((OCStructType)paramType).getSymbol();
                        List<OCTypeParameterSymbol> parameters2 = paramTypeSymbol.getTemplateParameters();
                        if (OCCodeInsightUtil.isInitializerListType(paramType, file2) && parameters2.size() == 1) {
                            allCandidates.add(function);
                            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameters2.get(0));
                            if (paramSubstitution instanceof OCType) {
                                boolean isCompatible = true;
                                for (int i2 = 0; i2 < arguments.getExprs().size(); ++i2) {
                                    OCTypeOwner expr = (OCTypeOwner)arguments.getExprs().get(i2);
                                    OCType type2 = arguments.getTypes().get(i2);
                                    isCompatible &= ((OCType)paramSubstitution).isCompatible(type2, expr, (PsiElement)file2);
                                }
                                if (isCompatible) {
                                    result2.set((Object)function);
                                    return false;
                                }
                            }
                        }
                        if (implicitCtors && OCResolveOverloadsUtil.findCtorWithInitializerList((OCStructType)paramType, arguments, new ArrayList(), file2, false) != null) {
                            result2.set((Object)function);
                            return false;
                        }
                    }
                }
                return true;
            }
        }, context);
        return (OCSymbol)result2.get();
    }

    private static <E extends OCTypeOwner> List<OCSymbol> resolveTemplateSpecializations(@NotNull Collection<OCSymbol> symbols, @NotNull OCArgumentsList<E> arguments, @Nullable CVQualifiers cvQualifiers, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean acceptOnlyCompatible, boolean allowImplicitConversions, final @NotNull OCResolveContext context) {
        ArrayList<OCSymbol> unified = new ArrayList<OCSymbol>();
        ArrayList<OCSymbol> allSymbols = new ArrayList<OCSymbol>();
        int argumentsCount = arguments.getCount();
        for (OCSymbol symbol : symbols) {
            ProgressManager.checkCanceled();
            final Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
            HashSet dependentTypes = new HashSet();
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                if (function.isTemplateSymbol() && function.isExtern()) continue;
                List<OCType> parameterTypes = OCResolveOverloadsUtil.getParameterTypes(function, operatorPlacement, context, cvQualifiers);
                int paramsCount = OCArgumentsChecker.getNonVariadicParametersCount(parameterTypes);
                if (OCResolveOverloadsUtil.getNonInitializedParametersCount(function, operatorPlacement, context) > argumentsCount && !arguments.hasNonExpandedVariadics() || argumentsCount > paramsCount && !function.isVararg()) continue;
                boolean isUnified = OCArgumentsChecker.processArguments(parameterTypes, null, arguments, context, new OCArgumentsChecker.ArgumentsProcessor<E>((Set)dependentTypes, allowImplicitConversions){
                    final /* synthetic */ Set val$dependentTypes;
                    final /* synthetic */ boolean val$allowImplicitConversions;
                    {
                        this.val$dependentTypes = set2;
                        this.val$allowImplicitConversions = bl;
                    }

                    @Override
                    public boolean process(@NotNull OCType paramType, @Nullable OCDeclaratorSymbol parameterSymbol, @NotNull OCType argumentType, @Nullable E argument, boolean isVariadic) {
                        if (paramType instanceof OCPointerType && argumentType instanceof OCIntType && OCExpressionEvaluator.isNullCompatible(OCExpressionEvaluator.evaluate(argument, context))) {
                            return true;
                        }
                        if (paramType instanceof OCTypeParameterType) {
                            argumentType = OCTypeUtils.decayType(argumentType, context.getProject());
                        }
                        return paramType instanceof OCEllipsisType || OCSimpleTypeSubstitution.unify(paramType, argumentType, argument, substitutionMap, this.val$dependentTypes, true, isVariadic, context) != OCTypeUnificationVisitor.NOT_UNIFIED || !(paramType instanceof OCTypeParameterType) && paramType.checkCompatible(argumentType, (OCTypeOwner)argument, context.getElement(), this.val$allowImplicitConversions, true, context).getState() == OCType.TypeCheckState.OK;
                    }
                });
                OCResolveOverloadsUtil.addDefaultSubstitutions(function, substitutionMap);
                OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create(substitutionMap);
                if (isUnified && OCResolveOverloadsUtil.isPrunedBySFINAE(function, substitution, (Set<OCTypeParameterSymbol>)dependentTypes, context)) {
                    isUnified = false;
                }
                OCSymbol substitutedFunction = substitution.substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (!isUnified) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentsCount == 1 && !((OCStructSymbol)symbol).hasDeclaredConstructor() && !((OCStructSymbol)symbol).isPredefinition()) {
                OCType argumentType = arguments.getTypes().get(0);
                OCTypeOwner argumentExpr = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(0) : null;
                OCTypeUnificationVisitor.UnificationResult unifyResult = OCSimpleTypeSubstitution.unify(symbol.getType(), argumentType, argumentExpr, substitutionMap, (Set<OCTypeParameterSymbol>)dependentTypes, true, false, context);
                OCSymbol substitutedFunction = OCSimpleTypeSubstitution.create(substitutionMap).substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (unifyResult == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentsCount == 0 && !((OCStructSymbol)symbol).hasDeclaredConstructor() && !((OCStructSymbol)symbol).isPredefinition()) {
                unified.add(symbol);
                continue;
            }
            if (symbol instanceof OCStructSymbol || symbol.getKind() == OCSymbolKind.TEMPLATE_TYPE_PARAMETER) continue;
            unified.add(symbol);
        }
        return unified.isEmpty() && !acceptOnlyCompatible ? allSymbols : unified;
    }

    private static void addDefaultSubstitutions(OCFunctionSymbol function, Map<OCTypeParameterSymbol, OCTypeArgument> map2) {
        for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
            if (parameter.getDefaultValue() == null || map2.containsKey(parameter)) continue;
            map2.put(parameter, (OCTypeArgument)parameter.getDefaultValue());
        }
    }

    private static <T> boolean containsAny(Set<T> set2, Collection<T> collection) {
        for (T element : collection) {
            if (!set2.contains(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPrunedBySFINAE(OCFunctionSymbol function, OCSimpleTypeSubstitution substitution, Set<OCTypeParameterSymbol> dependentTypes, @NotNull OCResolveContext context) {
        context = context.substituteFirst(substitution);
        context = context.useFor(function);
        boolean oldSfinaeFlag = OCResolveContext.setInSFINAEFlag(context, true);
        try {
            for (OCDeclaratorSymbol parameter : function.getParameterSymbols(context)) {
                OCType paramType = parameter.getType().resolve(context);
                if (!paramType.isUnresolved(context)) continue;
                boolean bl = true;
                return bl;
            }
            OCType returnType = function.getEffectiveType().resolve(context);
            if ((returnType.isUnresolved(context) || returnType.isUnknown()) && !OCResolveOverloadsUtil.containsAny(dependentTypes, context.getTypeDependencies(returnType))) {
                boolean bl = true;
                return bl;
            }
            for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
                OCType type2;
                Object defaultValue = parameter.getDefaultValue();
                if (defaultValue == null && !dependentTypes.contains(parameter) && !parameter.isVariadic() && function.getSubstitution().getSubstitutionFor(parameter) == null && substitution.getSubstitutionFor(parameter) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (parameter instanceof OCTypeParameterValueSymbol && (type2 = ((OCTypeParameterValueSymbol)parameter).getType().resolve(context)).isUnresolved(context)) {
                    boolean bl = true;
                    return bl;
                }
                if (!(defaultValue instanceof OCType) || !(type2 = ((OCType)defaultValue).resolve(context)).isUnresolved(context) || OCResolveOverloadsUtil.containsAny(dependentTypes, context.getTypeDependencies(type2))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            OCResolveContext.setInSFINAEFlag(context, oldSfinaeFlag);
        }
    }

    private static class FuncDescriptor {
        @NotNull
        public final OCFunctionSymbol symbol;
        @NotNull
        private final OCFunctionType myResolvedType;
        @NotNull
        private final OCQualifiedName myName;
        @NotNull
        private final OCTypeEqualityAfterResolvingVisitor myVisitor;

        public FuncDescriptor(@NotNull OCFunctionSymbol symbol, @NotNull OCFunctionType type2, @NotNull OCQualifiedName name, @NotNull OCResolveContext context) {
            this.symbol = symbol;
            this.myResolvedType = type2;
            this.myName = name;
            this.myVisitor = new OCTypeEqualityAfterResolvingVisitor(this.myResolvedType, false, context);
        }

        public boolean isUndistinguishable(@NotNull FuncDescriptor other) {
            return (this.symbol.isFriend() || other.symbol.isFriend() || this.myName.equals(other.myName)) && this.myVisitor.isFunctionSignatureEqual(other.myResolvedType);
        }
    }

    private static class Overload {
        OCSymbol mySymbol;
        List<ImplicitConversionSequence> myConversionSequences;
        boolean myHasMagic;

        public Overload(OCSymbol symbol, List<ImplicitConversionSequence> paramConversions) {
            this.mySymbol = symbol;
            this.myConversionSequences = paramConversions;
            this.myHasMagic = symbol.getKind().isTemplateParameter() || paramConversions.stream().anyMatch(c -> c.hasMagic()) || OCResolveOverloadsUtil.hasUnevaluatedSubstitutions(symbol);
        }
    }

    public static class OCFunctionGroupSymbol
    extends OCFunctionSymbol {
        private List<OCFunctionSymbol> myOverloads;
        private Cause myCause;

        public OCFunctionGroupSymbol(@NotNull List<OCFunctionSymbol> overloads, @Nullable OCType returnType, @NotNull Cause cause) {
            super(overloads.get(0).getProject(), overloads.get(0).getContainingFile(), 0L, overloads.get(0).getParent(), overloads.get(0).getQualifiedName(), Collections.emptyList(), Collections.emptyList(), 0, OCSymbolAttribute.STATIC.getMask(), Collections.emptyList(), OCFunctionGroupSymbol.getFunctionType(overloads, returnType), OCFunctionGroupSymbol.getParameters(overloads), OCFunctionGroupSymbol.getSymbolKind(overloads, OCSymbolKind.FUNCTION_PREDECLARATION), null);
            this.myOverloads = overloads;
            this.myCause = cause;
        }

        private static List<OCDeclaratorSymbol> getParameters(List<OCFunctionSymbol> overloads) {
            return overloads.get(0).getParameterSymbols();
        }

        private static OCFunctionType getFunctionType(List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
            if (returnType == null) {
                returnType = new OCMagicType(overloads.get(0).getType().getReturnType());
            }
            return new OCFunctionType(returnType, Collections.singletonList(OCEllipsisType.instance()));
        }

        private static OCSymbolKind getSymbolKind(List<OCFunctionSymbol> overloads, OCSymbolKind defaultKind) {
            OCSymbolKind kind2 = null;
            for (OCFunctionSymbol symbol : overloads) {
                if (kind2 == null) {
                    kind2 = symbol.getKind();
                    continue;
                }
                if (symbol.getKind().isSame(kind2)) continue;
                return defaultKind;
            }
            return kind2 != null ? kind2 : defaultKind;
        }

        public List<OCFunctionSymbol> getOverloads() {
            return this.myOverloads;
        }

        public Cause getCause() {
            return this.myCause;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
            throw new UnsupportedOperationException("this symbol is synthetic and should not be interned");
        }

        public static enum Cause {
            Ambiguous,
            NoViable,
            Magic;

        }
    }
}

