/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.OCGroupedFileNaming;
import com.jetbrains.cidr.lang.OCGroupedFileNamings;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.PsiCachingReferenceBase;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileResourceReference
extends PsiCachingReferenceBase<PsiElement>
implements OCResourceReference {
    private Set<String> myExtensions;
    private boolean myExtensionInLiteral;
    private final boolean myIsDirectory;

    public OCFileResourceReference(PsiElement literal, Set<String> extensions, boolean extensionInLiteral, boolean isDirectory) {
        super(literal, false);
        this.myExtensions = extensions;
        this.myExtensionInLiteral = extensionInLiteral;
        this.myIsDirectory = isDirectory;
    }

    @Override
    public PsiElement resolveInner() {
        VirtualFile result2;
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        File file2 = new File(this.getCanonicalText());
        String fileName = file2.getName();
        if (this.myExtensionInLiteral || this.myExtensions != null && this.myExtensions.size() == 1) {
            fileName = FileUtil.getNameWithoutExtension((String)fileName);
        }
        ArrayList<String> parentPath = new ArrayList<String>();
        for (File parent = file2.getParentFile(); parent != null; parent = parent.getParentFile()) {
            parentPath.add(0, parent.getName());
        }
        this.processResources(fileName, parentPath, (Processor<VirtualFile>)finder);
        if (!finder.isFound() && this.myExtensions != null && this.myExtensions.contains("png") && !fileName.endsWith("@2x")) {
            this.processResources(fileName + "@2x", parentPath, (Processor<VirtualFile>)finder);
        }
        if ((result2 = (VirtualFile)finder.getFoundValue()) != null && result2.isValid()) {
            return this.findPsiElement(result2);
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement instanceof OCLiteralExpression ? ((OCLiteralExpression)this.getElement()).getUnescapedLiteralText() : StringUtil.unquoteString((String)this.getElement().getText());
        if (this.myExtensionInLiteral || this.myExtensions == null || this.myExtensions.size() != 1) {
            return text;
        }
        return text + "." + this.myExtensions.iterator().next();
    }

    public TextRange getRangeInElement() {
        if (OCElementUtil.getElementType(this.myElement) == OCTokenTypes.STRING_LITERAL) {
            return new TextRange(1, this.myElement.getTextLength() - 1);
        }
        return super.getRangeInElement();
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(boolean includeQuotes) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        HashSet processed2 = new HashSet();
        this.processResources(null, null, (Processor<VirtualFile>)((Processor)arg_0 -> this.lambda$getLookupElements$0((Set)processed2, includeQuotes, variants, arg_0)));
        return variants;
    }

    private PsiElement findPsiElement(VirtualFile virtualFile) {
        PsiManager manager = this.myElement.getManager();
        return virtualFile.isDirectory() ? manager.findDirectory(virtualFile) : manager.findFile(virtualFile);
    }

    private boolean processResources(final VirtualFile file2, final @Nullable String fileName, List<String> parentPath, int pathIndex, final Processor<VirtualFile> processor2) {
        if (pathIndex < parentPath.size()) {
            if (file2.isDirectory()) {
                VirtualFile child = file2.findChild(parentPath.get(pathIndex));
                return child == null || this.processResources(child, fileName, parentPath, pathIndex + 1, processor2);
            }
            return true;
        }
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile child) {
                if (child.isDirectory() == OCFileResourceReference.this.myIsDirectory && this.accepted(child) && !processor2.process((Object)child)) {
                    return 3.skipTo((VirtualFile)file2);
                }
                return CONTINUE;
            }

            private boolean accepted(VirtualFile child) {
                String iconBaseName;
                OCGroupedFileNaming groupedNaming;
                String extension = child.getExtension();
                if (!(OCFileResourceReference.this.myExtensions == null || extension != null && OCFileResourceReference.this.myExtensions.contains(extension.toLowerCase()))) {
                    return false;
                }
                if (fileName == null) {
                    return true;
                }
                if (child.getNameWithoutExtension().equals(fileName)) {
                    return true;
                }
                return OCFileResourceReference.this.myExtensions != null && (groupedNaming = OCGroupedFileNamings.getGroupedFileNaming(child)) != null && (iconBaseName = groupedNaming.getBaseName(child.getNameWithoutExtension())).equals(fileName);
            }
        });
        return result2.skipToParent == null;
    }

    private boolean processResources(@Nullable String fileName, @Nullable List<String> parentPath, Processor<VirtualFile> processor2) {
        for (VirtualFile file2 : OCResourceFilesProvider.getAccessibleResources(this.myElement)) {
            if (!this.processResources(file2, fileName, Collections.emptyList(), 0, processor2)) {
                return false;
            }
            if (!file2.isDirectory() || parentPath == null || fileName == null) continue;
            for (int i2 = 0; i2 < parentPath.size(); ++i2) {
                if (this.processResources(file2, fileName, parentPath, i2, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(this.myExtensionInLiteral ? newElementName : FileUtil.getNameWithoutExtension((String)newElementName));
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return element;
    }

    private /* synthetic */ boolean lambda$getLookupElements$0(Set processed2, boolean includeQuotes, List variants, final VirtualFile virtualFile) {
        if (processed2.contains(virtualFile)) {
            return true;
        }
        processed2.add(virtualFile);
        String name = this.myExtensionInLiteral ? virtualFile.getName() : virtualFile.getNameWithoutExtension();
        final String text = includeQuotes ? "@\"" + name + "\"" : name;
        LookupElementBuilder builder = LookupElementBuilder.create((Object)new ResolveResult(){

            public PsiElement getElement() {
                return OCFileResourceReference.this.findPsiElement(virtualFile);
            }

            public boolean isValidResult() {
                PsiElement element = this.getElement();
                return element != null && element.isValid();
            }
        }, (String)text);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setIcon(AllIcons.FileTypes.UiForm);
                presentation.setItemText(text);
                presentation.setTypeText(virtualFile.getParent().getName());
            }
        });
        variants.add(OCCompletionPriority.elementWithPriority((LookupElement)builder, OCCompletionPriority.HIGHEST_PRIORITY));
        return true;
    }
}

