/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.resolve.references.OCStatefulReference;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOperatorReference
extends OCPolyVariantReferenceImpl<OCSymbol>
implements OCStatefulReference {
    private final OCElement myElement;
    private final String mySign;
    private final OperatorPlacement myPlacement;
    protected final List<? extends OCTypeOwner> myArguments;
    private final List<OCType> myParamTypes;
    private final PsiElement mySignElement;
    private static Key<MyResolver>[] RESOLVER_KEYS = new Key[]{Key.create((String)"RESOLVER_KEY1"), Key.create((String)"RESOLVER_KEY2")};

    public OCOperatorReference(@NotNull OCElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, OCExpression ... arguments) {
        this(element, sign, placement, signElement, Arrays.asList(arguments), null);
    }

    public OCOperatorReference(@NotNull OCElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, @Nullable List<? extends OCTypeOwner> arguments, @Nullable List<OCType> paramTypes) {
        this.myElement = element;
        this.mySign = sign;
        this.myPlacement = placement;
        this.myArguments = arguments;
        this.myParamTypes = paramTypes;
        this.mySignElement = signElement;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.mySignElement != null ? OCElementUtil.getRangeInParent(this.mySignElement) : TextRange.EMPTY_RANGE;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean isValid() {
        return !(!this.myElement.isValid() || this.mySignElement != null && !this.mySignElement.isValid() || this.myArguments != null && !ContainerUtil.and(this.myArguments, owner -> !(owner instanceof OCExpression) || ((OCExpression)owner).isValid()));
    }

    public boolean isSoft() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCOperatorReference reference = (OCOperatorReference)o;
        if (this.myElement != null ? !this.myElement.equals(reference.myElement) : reference.myElement != null) {
            return false;
        }
        if (this.mySignElement != null ? !this.mySignElement.equals(reference.mySignElement) : reference.mySignElement != null) {
            return false;
        }
        return !(this.mySign != null ? !this.mySign.equals(reference.mySign) : reference.mySign != null);
    }

    public int hashCode() {
        int result2 = this.myElement != null ? this.myElement.hashCode() : 0;
        result2 = 31 * result2 + (this.mySign != null ? this.mySign.hashCode() : 0);
        result2 = 31 * result2 + (this.mySignElement != null ? this.mySignElement.hashCode() : 0);
        return result2;
    }

    @Nullable
    public List<? extends OCTypeOwner> getArgumentExpressions() {
        return this.myArguments;
    }

    @NotNull
    public String getCanonicalText() {
        if (this.mySignElement != null) {
            return this.mySignElement.getText();
        }
        return this.mySign;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.mySignElement != null) {
            OCElementUtil.replaceWithIdentifier(this.mySignElement, newElementName, this.getElement());
        }
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        return this.handleElementRename(symbol.getName());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> types, @Nullable List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        OCOperatorReference reference = new OCOperatorReference((OCElement)context.getElement(), sign, placement, null, arguments, types);
        List symbols = (List)new MyResolver((boolean)true, (boolean)true, (OCResolveContext)context).resolve((OCOperatorReference)reference, (OCResolveContext)context).first;
        OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem((List)symbols);
        return symbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull OCElement element, @NotNull OCStructType struct) {
        OCResolveContext context = new OCResolveContext(element);
        OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem((List)new MyResolver(true, true, context).doResolveOperator(sign, placement, Collections.singletonList(struct), null, context, null));
        return symbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveDerefOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        return OCOperatorReference.resolveOperator(OCTokenTypes.DEREF.getName(), OperatorPlacement.INFIX, element, struct);
    }

    @NotNull
    private List<OCSymbol> resolveToSymbols(@NotNull MyResolver resolver) {
        Pair<List<OCSymbol>, Boolean> pair = null;
        ResolveCache resolveCache = ResolveCache.getInstance(this.myElement.getProject());
        if (resolveCache != null) {
            pair = resolveCache.resolveWithCaching(this, resolver, false, false);
        }
        return pair != null ? (List)pair.getFirst() : Collections.emptyList();
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads) {
        return this.resolveToSymbols(MyResolver.getInstance(resolveOverloads));
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads, boolean filterAmbigs) {
        Pair<List<OCSymbol>, Boolean> pair = new MyResolver(resolveOverloads, filterAmbigs).resolve(this, false);
        return pair != null ? (Collection)pair.getFirst() : Collections.emptyList();
    }

    public boolean hasMagicOperands() {
        Pair<List<OCSymbol>, Boolean> pair = ResolveCache.getInstance(this.myElement.getProject()).resolveWithCaching(this, MyResolver.getInstance(true), false, false);
        return pair != null ? (Boolean)pair.getSecond() : false;
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return new ArrayList<OCSymbol>(this.resolveToSymbols(true));
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        return this.resolveToSymbols(true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean resolveOverloads, @NotNull OCResolveContext context) {
        MyResolver resolver;
        Key<MyResolver> key2 = RESOLVER_KEYS[resolveOverloads ? 1 : 0];
        OCResolveContext oCResolveContext = context;
        synchronized (oCResolveContext) {
            resolver = (MyResolver)context.getUserData(key2);
            if (resolver == null) {
                resolver = new MyResolver(resolveOverloads, false, context);
                context.putUserData(key2, resolver);
            }
        }
        return this.resolveToSymbols(resolver);
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<OCOperatorReference, Pair<List<OCSymbol>, Boolean>> {
        private boolean myResolveOverloads;
        private boolean myFilterAmbigs;
        private OCResolveContext myContext;
        private static final MyResolver[] INSTANCES = new MyResolver[]{new MyResolver(false, false), new MyResolver(true, false)};
        private static final Pair<List<OCSymbol>, Boolean> EMPTY = new Pair(Collections.emptyList(), (Object)false);
        private static final Pair<List<OCSymbol>, Boolean> EMPTY_MAGIC = new Pair(Collections.emptyList(), (Object)true);

        public static MyResolver getInstance(boolean resolveOverloads) {
            return resolveOverloads ? INSTANCES[1] : INSTANCES[0];
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs, @NotNull OCResolveContext context) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
            this.myContext = context;
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
        }

        @Override
        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, boolean incompleteCode) {
            return this.resolve(reference, this.myContext != null ? this.myContext : new OCResolveContext(reference.getElement()));
        }

        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, @NotNull OCResolveContext context) {
            if (reference.myArguments != null) {
                return this.resolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, reference.myArguments, context, reference.getElement());
            }
            return Pair.create(this.doResolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, null, context, reference.getElement()), (Object)false);
        }

        @NotNull
        private Pair<List<OCSymbol>, Boolean> resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @Nullable List<OCType> paramTypes, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
            if (OCUDLiteralExpression.isUDLOperator(sign)) {
                return this.resolveUDLOperator(sign, placement, arguments, context, localContext);
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            boolean hasCppStructType = false;
            boolean wasNonLiteral = false;
            boolean hasMagicParameter = false;
            for (OCTypeOwner oCTypeOwner : arguments) {
                if (oCTypeOwner instanceof OCLiteralExpression || oCTypeOwner instanceof OCLiteralExpressionSymbol) continue;
                wasNonLiteral = true;
            }
            if (!wasNonLiteral) {
                return EMPTY;
            }
            for (int i2 = 0; i2 < arguments.size(); ++i2) {
                OCType derefType;
                OCTypeOwner oCTypeOwner = arguments.get(i2);
                OCType type2 = paramTypes != null && i2 < paramTypes.size() ? paramTypes.get(i2).resolve(context) : oCTypeOwner.getResolvedType(context);
                args.add(oCTypeOwner);
                OCType oCType = derefType = type2 instanceof OCCppReferenceType ? ((OCCppReferenceType)type2).getRefType() : type2;
                if (derefType instanceof OCMagicType) {
                    hasMagicParameter = true;
                }
                if (derefType instanceof OCStructType && ((OCStructType)derefType).getKind() != OCSymbolKind.ENUM) {
                    hasCppStructType = true;
                } else if (i2 == 0 && sign.equals("()")) {
                    return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
                }
                types.add(type2);
            }
            if (hasCppStructType) {
                List<OCSymbol> symbols = this.doResolveOperator(sign, placement, types, args, context, localContext);
                return !symbols.isEmpty() ? Pair.create(symbols, (Object)hasMagicParameter) : EMPTY;
            }
            return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
        }

        @NotNull
        private Pair<List<OCSymbol>, Boolean> resolveUDLOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            if (arguments.size() == 1 && arguments.get(0) instanceof OCLiteralExpression) {
                List<OCSymbol> symbols;
                boolean numericLiteral;
                OCType type2;
                OCLiteralExpression literal = (OCLiteralExpression)arguments.get(0);
                IElementType elementType = OCElementUtil.getElementType(literal.getFirstChild());
                if (elementType == OCTokenTypes.INTEGER_LITERAL) {
                    type2 = OCIntType.ULONGLONG;
                    numericLiteral = true;
                } else if (elementType == OCTokenTypes.FLOAT_LITERAL) {
                    type2 = OCRealType.LONG_DOUBLE;
                    numericLiteral = true;
                } else {
                    type2 = literal.getType(context);
                    numericLiteral = false;
                }
                args.add(literal);
                types.add(type2);
                if (literal.isStringLiteral()) {
                    types.add(OCIntType.SIZE_T);
                    args.add(null);
                }
                if (!(symbols = this.doResolveOperator(sign, placement, types, args, context, localContext)).isEmpty()) {
                    return Pair.create(symbols, (Object)false);
                }
                if (numericLiteral) {
                    args.clear();
                    types.clear();
                    types.add(OCPointerType.to(OCIntType.CHAR_CONST));
                    args.add(null);
                    List<OCSymbol> rawChars = this.doResolveOperator(sign, placement, types, args, context, localContext);
                    types.clear();
                    List<OCSymbol> template = this.doResolveOperator(sign, placement, types, null, context, localContext);
                    if (!rawChars.isEmpty() && template.isEmpty()) {
                        symbols = rawChars;
                    } else if (rawChars.isEmpty() && !template.isEmpty()) {
                        symbols = template;
                    } else if (!rawChars.isEmpty() && !template.isEmpty()) {
                        ArrayList<OCSymbol> functionSymbols = new ArrayList<OCSymbol>(2);
                        functionSymbols.addAll(rawChars);
                        functionSymbols.addAll(template);
                        symbols = Collections.singletonList(new OCResolveOverloadsUtil.OCFunctionGroupSymbol(ContainerUtil.map(functionSymbols, symbol -> (OCFunctionSymbol)symbol), null, OCResolveOverloadsUtil.OCFunctionGroupSymbol.Cause.Ambiguous));
                    }
                    if (!symbols.isEmpty()) {
                        return Pair.create(symbols, (Object)false);
                    }
                }
            }
            return EMPTY;
        }

        @NotNull
        private List<OCSymbol> doResolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> argTypes, @Nullable List<OCTypeOwner> args, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
            String name = OCTokenTypes.OPERATOR_CPP_KEYWORD.getName() + sign;
            OCType leftType = argTypes.isEmpty() ? null : argTypes.get(0);
            OCExprValueCategory leftValueCategory = args == null || args.isEmpty() ? null : OCExprValueCategory.classify(args.get(0), context);
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            if (leftType instanceof OCCppReferenceType) {
                leftType = ((OCCppReferenceType)leftType).getRefType();
            }
            if (leftType instanceof OCStructType) {
                List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)leftType, name, null, context, true);
                ContainerUtil.process((List)members, (Processor)collector);
            }
            if (localContext != null) {
                OCSymbolReference.getLocalReference(name, localContext).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            for (OCType oCType : argTypes) {
                OCType terminalType = oCType.getTerminalType();
                if (!(terminalType instanceof OCStructType)) continue;
                OCSymbolWithQualifiedName parent = ((OCStructType)terminalType).getSymbol().getParent();
                OCSymbolReference.getGlobalReference(name, parent).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            Collection<OCSymbol> symbols = collector.getResults();
            if (args != null && args.get(0) instanceof OCExpression) {
                symbols = OCArgumentDepLookupAccumulator.doArgDepLookup(collector.getResults(), argTypes, args, OCQualifiedName.with(name), context);
            }
            if (this.myResolveOverloads) {
                if (OCUDLiteralExpression.isUDLOperator(sign)) {
                    for (OCSymbol symbol : symbols) {
                        if (!(symbol instanceof OCFunctionSymbol)) continue;
                        OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                        List<OCType> paramTypes = OCResolveOverloadsUtil.getParameterTypes(functionSymbol, placement, context, CVQualifiers.EMPTY);
                        if (argTypes.size() != paramTypes.size() || argTypes.size() != 0 && !paramTypes.get(0).equals(argTypes.get(0).transformType(OCArrayToPointerChanger.INSTANCE), false, context)) continue;
                        return Collections.singletonList(symbol);
                    }
                } else {
                    OCArgumentsList<OCTypeOwner> oCArgumentsList = new OCArgumentsList<OCTypeOwner>(argTypes, args);
                    OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(symbols, oCArgumentsList, leftType, leftValueCategory, placement, true, true, this.myFilterAmbigs, true, false, context);
                    if (result2 != null) {
                        return Collections.singletonList(result2);
                    }
                }
                return Collections.emptyList();
            }
            return (List)collector.getResults();
        }
    }

    public static enum OperatorPlacement {
        PREFIX,
        INFIX,
        POSTFIX;

    }
}

