/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceFilesProvider {
    private static final ExtensionPointName<OCResourceFilesProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.resourceFilesProvider");

    @NotNull
    public static Collection<VirtualFile> getAccessibleResources(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        HashSet result2 = new HashSet();
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            result2.addAll(provider2.getAccessibleResourceFiles(project2, virtualFile));
        }
        return result2;
    }

    @NotNull
    public static Collection<VirtualFile> getAccessibleResources(@NotNull PsiElement element) {
        VirtualFile file2 = OCResourceFilesProvider.getFileFromElement(element);
        if (file2 != null) {
            return OCResourceFilesProvider.getAccessibleResources(element.getProject(), file2);
        }
        return Collections.emptyList();
    }

    public static boolean isAccessible(@NotNull Project project2, @Nullable VirtualFile from, @Nullable VirtualFile who) {
        if (from == null) {
            return false;
        }
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            if (!provider2.isAccessibleInner(project2, from, who)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(@NotNull PsiElement element, @NotNull VirtualFile file2) {
        return OCResourceFilesProvider.isAccessible(element.getProject(), OCResourceFilesProvider.getFileFromElement(element), file2);
    }

    @Nullable
    private static VirtualFile getFileFromElement(@NotNull PsiElement element) {
        VirtualFile elementFile = element.getContainingFile().getVirtualFile();
        if (elementFile == null) {
            elementFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        }
        return elementFile;
    }

    @NotNull
    protected abstract Collection<VirtualFile> getAccessibleResourceFiles(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isAccessibleInner(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable VirtualFile var3);
}

