/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProviders;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCResourceReferenceContributor
extends PsiReferenceContributor {
    private static final OCResourceCompletionProvider[] PROVIDERS;

    public static boolean processReferenceProviders(Processor<OCResourceCompletionProvider> processor2) {
        return ContainerUtil.process((Object[])PROVIDERS, processor2);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        for (OCResourceCompletionProvider provider2 : PROVIDERS) {
            registrar.registerReferenceProvider(OCResourceReferenceContributor.isResourceReference(provider2), (PsiReferenceProvider)provider2);
        }
    }

    private static PsiElementPattern.Capture<OCLiteralExpression> isResourceReference(OCResourceCompletionProvider provider2) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(OCLiteralExpression.class).with((PatternCondition)new IsStringLiteral())).inside((ElementPattern)PlatformPatterns.psiElement(OCMessageArgument.class).with((PatternCondition)new IsResourceMethod(provider2)));
    }

    static {
        ArrayList ps = ContainerUtil.newArrayList();
        for (OCResourceCompletionProviders each : (OCResourceCompletionProviders[])Extensions.getExtensions(OCResourceCompletionProviders.EP_NAME)) {
            ps.addAll(each.getProviders());
        }
        PROVIDERS = ps.toArray(new OCResourceCompletionProvider[ps.size()]);
    }

    private static class IsResourceMethod
    extends PatternCondition<OCMessageArgument> {
        private OCResourceCompletionProvider myProvider;

        public IsResourceMethod(OCResourceCompletionProvider provider2) {
            super(null);
            this.myProvider = provider2;
        }

        public boolean accepts(@NotNull OCMessageArgument argument, ProcessingContext context) {
            return argument.getArgumentSelector().getSelectorName().equals(this.myProvider.getArgumentSelector());
        }
    }

    public static class IsStringLiteral
    extends PatternCondition<OCLiteralExpression> {
        public IsStringLiteral() {
            super(null);
        }

        public boolean accepts(@NotNull OCLiteralExpression literal, ProcessingContext context) {
            return OCElementUtil.getStringLiteral(literal) != null;
        }
    }
}

