/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionSequence;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public class TypeProperties {
    public static boolean isAggregateType(@NotNull OCType type2, @NotNull OCResolveContext context) {
        if (!(type2 instanceof OCStructType) || !type2.isCppStructType()) {
            return false;
        }
        OCStructSymbol symbol = ((OCStructType)type2).getSymbol();
        if (symbol.hasDeclaredConstructor()) {
            return false;
        }
        return !symbol.hasBaseClasses();
    }

    public static boolean isEnum(@NotNull OCType type2) {
        return type2 instanceof OCStructType && ((OCStructType)type2).isEnum();
    }

    public static boolean isRecordType(@NotNull OCType type2) {
        return type2 instanceof OCStructType && !((OCStructType)type2).isEnum();
    }

    public static boolean isPromotableIntegerType(@NotNull OCType type2, @NotNull OCResolveContext context) {
        if (type2 instanceof OCIntType) {
            switch (((OCIntType)type2).getCTypeId()) {
                case BOOL: 
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: 
                case SHORT: {
                    return true;
                }
            }
            return false;
        }
        if (TypeProperties.isEnum(type2)) {
            return !type2.isMagicInside(context) && !((OCStructType)type2).getSymbol().isEnumClass();
        }
        return false;
    }

    public static boolean isIntegerLikeType(@NotNull OCType type2) {
        return type2 instanceof OCIntType || TypeProperties.isEnum(type2) && !((OCStructType)type2).getSymbol().isEnumClass();
    }

    public static boolean isIntegralType(@NotNull OCType type2, @NotNull OCResolveContext context) {
        return type2 instanceof OCIntType || !context.isCpp() && TypeProperties.isEnum(type2);
    }

    public static boolean isArithmeticType(@NotNull OCType type2) {
        return type2 instanceof OCNumericType || TypeProperties.isEnum(type2);
    }

    public static boolean isSignedIntegerType(@NotNull OCType type2) {
        return type2 instanceof OCIntType && ((OCIntType)type2).isSigned() || TypeProperties.isEnum(type2);
    }

    public static boolean isAnyCharacterType(@NotNull OCType type2) {
        if (type2 instanceof OCIntType) {
            switch (((OCIntType)type2).getCTypeId()) {
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCharacterType(@NotNull OCType type2) {
        if (type2 instanceof OCIntType) {
            switch (((OCIntType)type2).getCTypeId()) {
                case SIGNED_CHAR: 
                case CHAR: {
                    return true;
                }
            }
        }
        return false;
    }

    public static OCType getEnumPromotionType(OCType enumType) {
        return OCIntType.INT;
    }

    public static int getTypeSize(@NotNull OCType type2, @NotNull OCResolveContext context) {
        if (type2 instanceof OCNumericType) {
            return type2.getSizeInBytes(context.getFile(), null);
        }
        if (TypeProperties.isEnum(type2)) {
            return TypeProperties.getEnumPromotionType(type2).getSizeInBytes(context.getFile(), null);
        }
        throw new IllegalArgumentException(type2.getName());
    }

    public static boolean hasSameUnqualifiedType(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        return T1.equals(T2, false, context);
    }

    public static boolean isIncompleteOrObjectType(@NotNull OCType type2) {
        return !(type2 instanceof OCFunctionType);
    }

    public static boolean IsDerivedFrom(OCType Derived, OCType Base2, @NotNull OCResolveContext context) {
        if (!(Derived instanceof OCStructType) || !(Base2 instanceof OCStructType)) {
            return false;
        }
        for (OCStructSymbol symbol : ((OCStructType)Derived).getStructs()) {
            if (!((OCStructType)Base2).getSymbol().isAncestor(symbol, context)) continue;
            return true;
        }
        return false;
    }

    public static boolean canAssignObjCInterfaces(OCType LHSOPT, OCType RHSOPT, @NotNull OCResolveContext context) {
        return LHSOPT.isCompatible(RHSOPT, context.getElement());
    }

    public static boolean AreSimilarPointerTypes(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        if (!(T1 instanceof OCPointerType) || !(T2 instanceof OCPointerType)) {
            return false;
        }
        OCPointerType t1Ptr = (OCPointerType)T1;
        OCPointerType t2Ptr = (OCPointerType)T2;
        if (T1.isPointerToObject() || T2.isPointerToObject()) {
            return T1.isPointerToObject() && T2.isPointerToObject();
        }
        if (t1Ptr.getClassQualifier() != null || t2Ptr.getClassQualifier() != null) {
            return t1Ptr.getClassQualifier() != null && t2Ptr.getClassQualifier() != null && TypeProperties.hasSameUnqualifiedType(t1Ptr.getClassQualifier(), t2Ptr.getClassQualifier(), context);
        }
        return true;
    }

    public static OCType getArrayDecayedType(OCArrayType Ty, @NotNull OCResolveContext context) {
        OCPointerType PtrTy = OCPointerType.to(Ty.getRefType());
        return PtrTy.cloneWithCVQualifiers(Ty.getArrayElementType().getCVQualifiers(), context.getProject());
    }

    public static boolean hasDeprecatedStringLiteralToCharPtrConversion(ImplicitConversionSequence ICS) {
        return ICS.isStandard() && ICS.Standard.DeprecatedStringLiteralToCharPtr || ICS.isUserDefined() && ICS.UserDefined.Before.DeprecatedStringLiteralToCharPtr;
    }

    public static boolean isMoreQualifiedThan(OCType type1, OCType type2) {
        return TypeProperties.isMoreQualifiedThan(type1.getCVQualifiers(), type2.getCVQualifiers());
    }

    public static boolean isMoreQualifiedThan(CVQualifiers Quals1, CVQualifiers Quals2) {
        return Quals1 != Quals2 && Quals1.isSuperset(Quals2);
    }

    public static boolean hasSimilarType(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        while (TypeProperties.AreSimilarPointerTypes(T1, T2, context)) {
            T1 = ((OCPointerType)T1).getRefType();
            T2 = ((OCPointerType)T2).getRefType();
            T1 = T1.cloneWithoutCVQualifiers(context.getProject());
            T2 = T2.cloneWithoutCVQualifiers(context.getProject());
        }
        return T1.equals(T2, false, context);
    }

    public static Pair<OCType, CVQualifiers> getUnqualifiedArrayType(@NotNull OCType type2, @NotNull Project project2) {
        if (!(type2 instanceof OCArrayType)) {
            return Pair.create((Object)type2.cloneWithoutCVQualifiers(project2), (Object)((Object)type2.getCVQualifiers()));
        }
        Pair<OCType, CVQualifiers> refPair = TypeProperties.getUnqualifiedArrayType(((OCArrayType)type2).getRefType(), project2);
        return Pair.create((Object)OCArrayType.to((OCType)refPair.first, ((OCArrayType)type2).getLength()), (Object)((Object)type2.getCVQualifiers().or((CVQualifiers)((Object)refPair.second))));
    }

    public static RefQualifier getRefQualifier(@NotNull OCType type2) {
        if (type2 instanceof OCFunctionType) {
            if (((OCFunctionType)type2).isLValueRef()) {
                return RefQualifier.RQ_LValue;
            }
            if (((OCFunctionType)type2).isRValueRef()) {
                return RefQualifier.RQ_RValue;
            }
            return RefQualifier.RQ_None;
        }
        return RefQualifier.RQ_None;
    }

    public static enum RefQualifier {
        RQ_None,
        RQ_LValue,
        RQ_RValue;

    }
}

