/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement subj, @NotNull Processor<PsiElement> consumer2) {
        return (Boolean)ReadAction.compute(() -> {
            if (!(subj instanceof OCSymbolDeclarator)) {
                return true;
            }
            Object symbol = ((OCSymbolDeclarator)subj).getSymbol();
            if (symbol == null) {
                return true;
            }
            if (!(subj instanceof OCMethod || subj instanceof OCDeclarator && subj.getParent() instanceof OCFunctionDeclaration)) {
                return OCDefinitionsSearch.processSymbolDefinition(symbol, consumer2);
            }
            OCSymbol selfDefinitionSymbol = symbol.getDefinitionSymbol();
            OCDefinitionsSearch.consume(consumer2, selfDefinitionSymbol);
            OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> !symbol1.isDefinition() && symbol1.getDefinitionSymbol() != null || symbol1 == selfDefinitionSymbol || OCDefinitionsSearch.consume(consumer2, symbol1), false, true, false);
            return true;
        });
    }

    @Contract(value="null, _ -> true")
    private static boolean processSymbolDefinition(OCSymbol<?> symbol, Processor<PsiElement> consumer2) {
        if (symbol instanceof OCPropertySymbol) {
            return ((OCPropertySymbol)symbol).processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)accessor -> OCDefinitionsSearch.consume(consumer2, accessor)), true) && ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)synthesize -> OCDefinitionsSearch.consume(consumer2, synthesize)));
        }
        if (symbol instanceof OCClassSymbol) {
            return symbol.processSameSymbols((Processor<OCSymbol>)((Processor)curSymbol -> {
                if (curSymbol.equals(symbol) || curSymbol.isPredeclaration()) {
                    return true;
                }
                if (curSymbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)curSymbol).getImplementation(((OCInterfaceSymbol)curSymbol).getCategoryName()) != null) {
                    return true;
                }
                return OCDefinitionsSearch.consume(consumer2, curSymbol);
            })) && OCClassInheritorsSearch.search((OCClassSymbol)symbol).forEach(symbol12 -> OCDefinitionsSearch.consume(consumer2, symbol12));
        }
        if (symbol instanceof OCStructSymbol) {
            Object element = symbol.locateDefinition();
            Query<OCStructSymbol> query = OCStructInheritorsSearch.search((OCStruct)element);
            query.forEach(s -> OCDefinitionsSearch.consume(consumer2, s));
            OCSearchUtil.getRelatedSymbols((OCStructSymbol)symbol).forEach(s -> OCDefinitionsSearch.consume(consumer2, s));
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                OCDefinitionsSearch.consume(consumer2, symbol1);
                return true;
            }));
        }
        return true;
    }

    @Contract(value="_, null -> true")
    private static <T> boolean consume(Processor<T> consumer2, OCSymbol subj) {
        if (subj == null) {
            return true;
        }
        Object psi = subj.locateDefinition();
        if (psi != null) {
            return consumer2.process(psi);
        }
        return true;
    }
}

