/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import org.jetbrains.annotations.NotNull;

public class OCDollarMacroReferenceSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)OCDollarMacroReferenceSearch.doExecute(queryParameters, (Processor<PsiReference>)consumer2));
            }
        }.execute().getResultObject();
    }

    private static Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer2) {
        final PsiElement macro = queryParameters.getElementToSearch();
        if (!(macro instanceof OCDefineDirective)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)macro.getProject());
        String name = ((OCDefineDirective)macro).getName();
        if (name == null || !name.startsWith("$")) {
            return true;
        }
        return helper.processElementsWithWord(new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                for (PsiReference reference : element.getReferences()) {
                    if (!reference.isReferenceTo(macro) || consumer2.process((Object)reference)) continue;
                    return false;
                }
                return true;
            }
        }, queryParameters.getEffectiveSearchScope(), name.substring(1), (short)1, true);
    }
}

