/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import org.jetbrains.annotations.NotNull;

public class OCElementDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (!(element instanceof OCSymbolDeclarator) || !element.isValid()) {
            return null;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null || symbol instanceof OCForeignSymbol) {
            return null;
        }
        if (location instanceof UsageViewShortNameLocation || location instanceof UsageViewLongNameLocation || location instanceof DeleteNameDescriptionLocation || location instanceof NonCodeSearchDescriptionLocation) {
            return symbol.getName();
        }
        if (location instanceof UsageViewTypeLocation) {
            return symbol.getKindLowercase();
        }
        if (location instanceof DeleteTypeDescriptionLocation) {
            String name = symbol.getKindLowercase();
            return ((DeleteTypeDescriptionLocation)location).isPlural() ? StringUtil.pluralize((String)name) : name;
        }
        if (location instanceof UsageViewNodeTextLocation) {
            String result2 = symbol.getNameWithKindLowercase();
            if (symbol instanceof OCMemberSymbol) {
                result2 = result2 + " of " + ((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).getNameWithKindLowercase();
            } else if (symbol.isPredeclaration()) {
                result2 = "predefinition of " + result2;
            }
            return result2;
        }
        return symbol.getNameWithKindLowercase();
    }
}

