/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementInMacroAndNonCompiledCodeReferencesSearch
implements QueryExecutor<Usage, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<Usage> consumer2) {
        return this.execute(queryParameters, queryParameters.getEffectiveSearchScope(), consumer2);
    }

    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull SearchScope searchScope, final @NotNull Processor<Usage> consumer2) {
        boolean searchInMacroCalls;
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator) || OCElementInMacroAndNonCompiledCodeReferencesSearch.isDumb(element.getProject())) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        String stringToSearch = symbol.getName();
        final boolean searchForMacro = element instanceof OCDefineDirective;
        boolean bl = searchInMacroCalls = symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol || symbol.getKind().isType();
        if (symbol instanceof OCMethodSymbol) {
            String selectorName;
            List<OCMethodSymbol.SelectorPartSymbol> selectors = ((OCMethodSymbol)symbol).getSelectors();
            OCMethodSymbol.SelectorPartSymbol firstSelector = selectors.isEmpty() ? null : selectors.get(0);
            String string = selectorName = firstSelector != null ? firstSelector.getSelectorName() : null;
            if (selectorName != null) {
                String string2 = stringToSearch = selectorName.endsWith(":") ? selectorName.substring(0, selectorName.length() - 1) : selectorName;
            }
        }
        if (!stringToSearch.isEmpty()) {
            final int searchStringLength = stringToSearch.length();
            return helper.processElementsWithWord(new TextOccurenceProcessor(){

                public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                    OCDefineDirective define;
                    IElementType type2 = OCElementUtil.getElementType(element);
                    PsiElement parent = element.getParent();
                    IElementType parentType = OCElementUtil.getElementType(parent);
                    if (type2 == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                        int startOffset = element.getTextRange().getStartOffset() + offsetInElement;
                        TextRange range = new TextRange(startOffset, startOffset + searchStringLength);
                        return consumer2.process((Object)new Usage(element, range));
                    }
                    OCMacroCallArgument callArg = (OCMacroCallArgument)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCMacroCallArgument.class});
                    if (callArg != null && searchInMacroCalls) {
                        return consumer2.process((Object)new Usage(callArg.getParent()));
                    }
                    if (type2 != OCTokenTypes.IDENTIFIER) {
                        return true;
                    }
                    if (searchForMacro && parentType == OCElementTypes.MACRO_REF && (define = (OCDefineDirective)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDefineDirective.class})) != null) {
                        consumer2.process((Object)new Usage(define));
                    }
                    if (parentType != OCElementTypes.MACRO_DEFINITION) {
                        return true;
                    }
                    if (element.equals(((OCDefineDirective)parent).getNameIdentifier())) {
                        return true;
                    }
                    return consumer2.process((Object)new Usage(parent));
                }
            }, searchScope, stringToSearch, (short)1, true);
        }
        return true;
    }

    private static boolean isDumb(@Nullable Project project2) {
        if (project2 != null) {
            return DumbServiceImpl.getInstance(project2).isDumb();
        }
        for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbServiceImpl.getInstance(proj).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static class Usage {
        @NotNull
        private final PsiElement myElement;
        @Nullable
        private final TextRange myTextRange;

        public Usage(@NotNull PsiElement element, @Nullable TextRange textRange) {
            this.myElement = element;
            this.myTextRange = textRange;
        }

        public Usage(@NotNull PsiElement element) {
            this.myElement = element;
            this.myTextRange = null;
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public TextRange getTextRange() {
            return this.myTextRange == null ? this.myElement.getTextRange() : this.myTextRange;
        }
    }
}

