/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.util.Condition;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionAncestorsQuery
extends AbstractQuery<OCFunctionSymbol> {
    private final OCFunctionSymbol myFunction;
    private final boolean myProcessSameSymbols;
    private final boolean myGoTransitive;
    private final boolean myProcessConstructors;

    public OCFunctionAncestorsQuery(OCFunctionSymbol function, boolean goTransitive, boolean processSameSymbols) {
        this(function, goTransitive, processSameSymbols, false);
    }

    public OCFunctionAncestorsQuery(OCFunctionSymbol function, boolean goTransitive, boolean processSameSymbols, boolean processConstructors) {
        this.myFunction = function;
        this.myGoTransitive = goTransitive;
        this.myProcessSameSymbols = processSameSymbols;
        this.myProcessConstructors = processConstructors;
    }

    @Nullable
    public static OCFunctionSymbol findFirstVirtual(OCFunctionSymbol function, boolean processSameSymbols) {
        return (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, processSameSymbols), symbol -> symbol.isVirtual() || symbol.isOverride() || symbol.isFinal()).findFirst();
    }

    protected boolean processResults(@NotNull Processor<OCFunctionSymbol> consumer2) {
        OCSymbol associated;
        OCSymbolWithQualifiedName struct = this.myFunction.getResolvedOwner();
        if (!(struct instanceof OCStructSymbol)) {
            return true;
        }
        if (struct.isPredeclaration() && (associated = struct.getDefinitionSymbol()) instanceof OCSymbolWithQualifiedName) {
            struct = (OCSymbolWithQualifiedName)associated;
        }
        HashMap map2 = new HashMap();
        OCFile file2 = this.myFunction.getContainingOCFile();
        OCType resolvedType = this.myFunction.getResolvedType();
        boolean isDestructor = this.myFunction.isCppDestructor();
        boolean isConstructor = this.myFunction.isCppConstructor();
        OCResolveContext context = new OCResolveContext(file2);
        Condition condition2 = symbol -> symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriendOrStatic() && new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, context).isFunctionSignatureEqual(symbol.getType().resolve(file2));
        OCSymbolWithQualifiedName finalStruct = struct;
        Processor processor2 = symbol -> {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            OCQualifiedName name = functionSymbol.getResolvedQualifiedName();
            if (isDestructor && !functionSymbol.isCppDestructor() || isConstructor && !functionSymbol.isCppConstructor() || !this.myProcessSameSymbols && finalStruct.equals(functionSymbol.getParent())) {
                return true;
            }
            OCFunctionSymbol old = (OCFunctionSymbol)map2.get((Object)name);
            if (old == null || !old.isPredeclaration()) {
                map2.put((Object)name, (Object)functionSymbol);
            }
            return true;
        };
        if (!this.myFunction.isFriendOrStatic()) {
            String name = isDestructor || this.myProcessConstructors && isConstructor ? null : this.myFunction.getName();
            OCStructType.processMembersInBaseTypes((OCStructSymbol)struct, name, false, this.myGoTransitive, (Condition<OCSymbol>)condition2, (Processor<OCSymbol>)processor2, context);
        }
        if (this.myProcessSameSymbols) {
            this.myFunction.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(condition2, processor2));
        }
        for (OCFunctionSymbol symbol2 : map2.values()) {
            if (!(this.myProcessSameSymbols ? !symbol2.processSameSymbols(new OCCommonProcessors.TypeFilteredProcessor(consumer2, OCFunctionSymbol.class)) : !consumer2.process((Object)symbol2))) continue;
            return false;
        }
        return true;
    }
}

