/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionInheritorsSearch
extends QueryFactory<OCFunctionSymbol, SearchParameters> {
    public static final OCFunctionInheritorsSearch INSTANCE = new OCFunctionInheritorsSearch();

    public static SearchParameters getParameters(OCSymbolWithQualifiedName symbol, OCFile context, boolean searchBySignature) {
        if (symbol == null) {
            return new SearchParameters();
        }
        OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName();
        OCQualifiedName parentName = qualifiedName != null ? qualifiedName.getQualifier() : OCQualifiedName.GLOBAL;
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)symbol.getProject());
        SearchParameters parameters2 = searchBySignature ? SearchParameters.getSearchFunctionBySignatureParameters(context, scope, symbol.getName(), symbol.getType(), parentName) : SearchParameters.getSearchFunctionByNameParameters(context, scope, symbol.getName(), parentName);
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriend() && !((OCFunctionSymbol)symbol).isCppOperator()) {
            parameters2.myIsFriend = true;
        }
        parameters2.myIsFriendOrStatic = symbol.isFriendOrStatic();
        return parameters2;
    }

    public static SearchParameters getParameters(OCFunctionDeclaration function, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.getParameters((OCSymbolWithQualifiedName)function.getSymbol(), function.getContainingOCFile(), searchBySignature);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters2) {
        return OCFunctionInheritorsSearch.search(parameters2, null);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters2, @Nullable MultiMap<OCQualifiedName, OCQualifiedName> inheritanceCache) {
        if (parameters2.getFunctionName() == null) {
            return new EmptyQuery();
        }
        parameters2.myInheritenceCache = inheritanceCache;
        return INSTANCE.createQuery(parameters2);
    }

    public static Query<OCFunctionSymbol> search(OCFunctionSymbol function, OCFile context, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.search(OCFunctionInheritorsSearch.getParameters(function, context, searchBySignature));
    }

    private OCFunctionInheritorsSearch() {
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCFunctionSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<OCFunctionSymbol> consumer2) {
            HashSet curSubstructs;
            GlobalSearchScope scope = p.getScope();
            HashSet substructs = new HashSet();
            OCQualifiedName parentStruct = p.getParentStruct();
            if (p.myInheritenceCache != null && p.myInheritenceCache.containsKey((Object)parentStruct)) {
                Collection cached = p.myInheritenceCache.get((Object)parentStruct);
                substructs.addAll(cached);
            } else {
                Query<OCStructSymbol> search = p.myIncludeOnlyDirectInheritors ? OCDirectStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject) : OCStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject);
                for (OCStructSymbol substruct : search.findAll()) {
                    substructs.add((Object)substruct.getResolvedQualifiedName(false));
                }
                if (p.myInheritenceCache != null) {
                    p.myInheritenceCache.putValues((Object)parentStruct, (Collection)substructs);
                }
            }
            HashSet hashSet = curSubstructs = p.myIsFriendOrStatic ? new HashSet() : new HashSet((Collection)substructs);
            if (p.myIncludeSameSymbols) {
                curSubstructs.add((Object)parentStruct.dropArguments());
            }
            HashMap map2 = new HashMap();
            boolean needSpecificOrder = p.myImplementationsThenPredefinitions || p.myPredefinitionsThenImplementations;
            Processor processor2 = needSpecificOrder ? symbol -> {
                OCFunctionSymbol old = (OCFunctionSymbol)map2.get((Object)symbol.getResolvedQualifiedName());
                if (p.myIncludeSameSymbols || old == null || old.isPredeclaration() && p.myImplementationsThenPredefinitions || !old.isPredeclaration() && p.myPredefinitionsThenImplementations) {
                    map2.put((Object)symbol.getResolvedQualifiedName(), symbol);
                }
                return true;
            } : consumer2;
            OCFile context = p.myContext;
            VirtualFile contextFile = context != null ? context.getContainingFile().getVirtualFile() : null;
            OCType resolved = p.myType != null ? p.myType.resolve(context) : null;
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(p.getProject(), (Processor<OCSymbol>)((Processor)symbol -> {
                OCQualifiedName parentName;
                ProgressManager.checkCanceled();
                if (!(symbol instanceof OCFunctionSymbol) || !scope.accept(symbol.getContainingFile())) {
                    return true;
                }
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                if (p.isFriend() || function.isFriend()) {
                    return true;
                }
                OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)symbol).getParent();
                OCQualifiedName oCQualifiedName = parentName = parent != null ? parent.getResolvedQualifiedName() : null;
                if (!(p.isFriend() || function.isFriend() && !function.isCppOperator() || parentName == null && parentStruct == OCQualifiedName.GLOBAL && curSubstructs.contains((Object)OCQualifiedName.GLOBAL) || parentName != null && curSubstructs.contains((Object)parentName.dropArguments()))) {
                    return true;
                }
                if (function.isLocalInFile() && !Comparing.equal((Object)contextFile, (Object)function.getContainingFile())) {
                    return false;
                }
                OCFile file2 = function.getContainingOCFile();
                if (resolved != null && !function.getType().equalsAfterResolving(resolved, file2)) {
                    return true;
                }
                return symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> !(symbol1 instanceof OCFunctionSymbol) || processor2.process((Object)((OCFunctionSymbol)symbol1))));
            }), p.myFunctionName);
            if (processor2 != consumer2) {
                new CollectionQuery(map2.values()).forEach(consumer2);
            }
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private Project myProject;
        private String myFunctionName;
        private OCType myType;
        private OCFile myContext;
        private OCQualifiedName myParentStruct;
        private boolean myIncludeSameSymbols;
        private boolean myIsFriend;
        private boolean myIsFriendOrStatic;
        private boolean myIncludeOnlyDirectInheritors;
        private boolean myPredefinitionsThenImplementations;
        private boolean myImplementationsThenPredefinitions;
        private MultiMap<OCQualifiedName, OCQualifiedName> myInheritenceCache;

        public Project getProject() {
            return this.myProject;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public String getFunctionName() {
            return this.myFunctionName;
        }

        public OCType getType() {
            return this.myType;
        }

        public OCQualifiedName getParentStruct() {
            return this.myParentStruct;
        }

        public boolean isFriend() {
            return this.myIsFriend;
        }

        public void setIncludeSameSymbols(boolean value2) {
            this.myIncludeSameSymbols = value2;
        }

        public void setIncludeOnlyDirectInheritors(boolean value2) {
            this.myIncludeOnlyDirectInheritors = value2;
        }

        public void setPredeclarationsThenImplementations(boolean value2) {
            this.myPredefinitionsThenImplementations = value2;
        }

        public void setImplementationsThenPredeclarations(boolean value2) {
            this.myImplementationsThenPredefinitions = value2;
        }

        public static SearchParameters getSearchFunctionByNameParameters(OCFile context, GlobalSearchScope scope, String name, OCQualifiedName receiverType) {
            SearchParameters result2 = new SearchParameters();
            result2.myProject = context.getProject();
            result2.myContext = context;
            result2.myScope = scope;
            result2.myFunctionName = name;
            result2.myParentStruct = receiverType;
            return result2;
        }

        public static SearchParameters getSearchFunctionBySignatureParameters(OCFile context, GlobalSearchScope scope, String name, OCType type2, OCQualifiedName receiverType) {
            SearchParameters result2 = new SearchParameters();
            result2.myProject = context.getProject();
            result2.myContext = context;
            result2.myScope = scope;
            result2.myFunctionName = name;
            result2.myType = type2;
            result2.myParentStruct = receiverType;
            return result2;
        }

        private SearchParameters() {
        }

        public String toString() {
            return "SearchParameters{myFunctionName='" + this.myFunctionName + '\'' + ", myType=" + this.myType + ", myContext=" + this.myContext + ", myIncludeSameSymbols=" + this.myIncludeSameSymbols + ", myIsFriend=" + this.myIsFriend + ", myIsFriendOrStatic=" + this.myIsFriendOrStatic + '}';
        }
    }
}

