/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class OCFunctionReferenceSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    private final boolean myFindAllPotentialCalls;
    private static final EnumSet<PsiSearchHelperImpl.Options> UDL = EnumSet.of(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);
    private static final EnumSet<PsiSearchHelperImpl.Options> ORDINAL = EnumSet.of(PsiSearchHelperImpl.Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE, PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);

    public OCFunctionReferenceSearch() {
        this(false);
    }

    public OCFunctionReferenceSearch(boolean findPotentialAllPotentialCalls) {
        this.myFindAllPotentialCalls = findPotentialAllPotentialCalls;
    }

    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)OCFunctionReferenceSearch.this.doExecute(queryParameters, (Processor<PsiReference>)consumer2));
            }
        }.execute().getResultObject();
    }

    @NotNull
    private Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer2) {
        PsiElement element = queryParameters.getElementToSearch();
        if (element instanceof OCDeclarator) {
            element = element.getParent();
        }
        if (!(element instanceof OCFunctionDeclaration)) {
            return true;
        }
        OCFunctionDeclaration method2 = (OCFunctionDeclaration)element;
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        String searchWord = method2.getName();
        if (searchWord == null || searchWord.isEmpty()) {
            return true;
        }
        MyOccurenceProcessor processor2 = new MyOccurenceProcessor(method2, consumer2, this.myFindAllPotentialCalls);
        return ((PsiSearchHelperImpl)helper).processElementsWithWord((TextOccurenceProcessor)processor2, queryParameters.getEffectiveSearchScope(), searchWord, (short)1, method2.isOperator() ? UDL : ORDINAL, null);
    }

    public static boolean isCallViaReference(OCExpression qualifier) {
        if ((qualifier = OCParenthesesUtils.diveIntoParenthesesAndCasts(qualifier)) instanceof OCUnaryExpression && ((OCUnaryExpression)qualifier).getOperationSign() == OCTokenTypes.MUL) {
            return true;
        }
        if (qualifier != null) {
            OCType type2 = qualifier.getResolvedType();
            return type2 instanceof OCPointerType || type2 instanceof OCCppReferenceType;
        }
        return false;
    }

    private static class MyOccurenceProcessor
    implements TextOccurenceProcessor {
        private final OCSymbolWithQualifiedName myMethodSymbol;
        private final Processor<PsiReference> myConsumer;
        private final boolean myFindAllPotentialCalls;
        private final OCType myResolvedType;
        private final Collection<OCQualifiedName> myPossibleOwners;
        private final OCQualifiedName myOwner;

        public MyOccurenceProcessor(OCFunctionDeclaration function, Processor<PsiReference> consumer2, boolean findAllPotentialCalls) {
            this.myMethodSymbol = (OCSymbolWithQualifiedName)function.getSymbol();
            this.myConsumer = consumer2;
            this.myFindAllPotentialCalls = findAllPotentialCalls;
            if (this.myMethodSymbol != null) {
                this.myResolvedType = this.myMethodSymbol.getResolvedType();
                OCSymbolWithQualifiedName owner = this.myMethodSymbol.getResolvedOwner();
                if (owner instanceof OCStructSymbol) {
                    NullableFunction getNameFunction = symbol -> symbol.getResolvedQualifiedName();
                    this.myOwner = (OCQualifiedName)getNameFunction.fun((Object)((OCStructSymbol)owner));
                    if (this.myFindAllPotentialCalls) {
                        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
                        collectProcessor.process((Object)((OCStructSymbol)owner));
                        MyOccurenceProcessor.processAncestors((OCStructSymbol)owner, (Processor<OCStructSymbol>)collectProcessor);
                        this.myPossibleOwners = ContainerUtil.mapNotNull((Collection)collectProcessor.getResults(), (Function)getNameFunction);
                    } else {
                        this.myPossibleOwners = ContainerUtil.mapNotNull((Collection)OCStructInheritorsSearch.search((OCStructSymbol)owner, function).findAll(), (Function)getNameFunction);
                    }
                } else {
                    this.myOwner = OCQualifiedName.GLOBAL;
                    this.myPossibleOwners = Collections.emptySet();
                }
            } else {
                this.myOwner = null;
                this.myResolvedType = null;
                this.myPossibleOwners = Collections.emptySet();
            }
        }

        public static boolean processAncestors(OCStructSymbol substruct, Processor<OCStructSymbol> processor2) {
            OCFile file2 = substruct.getContainingOCFile();
            if (file2 == null) {
                return true;
            }
            OCResolveContext context = new OCResolveContext(file2);
            HashSet<OCStructSymbol> processed2 = new HashSet<OCStructSymbol>();
            Stack<OCStructSymbol> workset = new Stack<OCStructSymbol>();
            workset.add(substruct);
            while (!workset.isEmpty()) {
                OCStructSymbol symbol = (OCStructSymbol)workset.pop();
                if (processed2.contains(symbol)) continue;
                processed2.add(symbol);
                symbol.processBaseClasses(context, (symbol1, visibility) -> {
                    if (symbol1 instanceof OCStructSymbol) {
                        workset.add((OCStructSymbol)symbol1);
                        if (!processor2.process((Object)((OCStructSymbol)symbol1))) {
                            return false;
                        }
                    }
                    return true;
                });
            }
            return true;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            OCSymbol symbol = null;
            boolean isVirtual = false;
            PsiReference maybeOperatorRef = element.getReference();
            if (maybeOperatorRef instanceof OCOperatorReference) {
                symbol = (OCSymbol)((OCOperatorReference)maybeOperatorRef).resolveToSymbol();
            } else if (element instanceof OCReferenceElement) {
                symbol = ((OCReferenceElement)element).resolveToSymbol();
                isVirtual = ((OCReferenceElement)element).getNamespaceQualifier() == null;
            } else if (element instanceof OCQualifiedExpression) {
                symbol = ((OCQualifiedExpression)element).resolveToSymbol();
                isVirtual = OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)element).getQualifier());
            }
            if (symbol instanceof OCFunctionSymbol) {
                if (symbol.equals(this.myMethodSymbol)) {
                    return this.myConsumer.process((Object)element.getReference());
                }
                OCQualifiedName qualifiedName = ((OCFunctionSymbol)symbol).getResolvedQualifiedName();
                if (qualifiedName != null) {
                    OCTypeEqualityAfterResolvingVisitor visitor = new OCTypeEqualityAfterResolvingVisitor(this.myResolvedType, true, true, true, true, true, symbol.getContainingOCFile());
                    if (this.myOwner != null && this.myOwner.equals(qualifiedName.getQualifier())) {
                        if (symbol.getType().accept(visitor).booleanValue()) {
                            return this.myConsumer.process((Object)element.getReference());
                        }
                    } else if (this.myPossibleOwners.contains(qualifiedName.getQualifier())) {
                        if (!this.myFindAllPotentialCalls) {
                            if (symbol.getType().accept(visitor).booleanValue()) {
                                return this.myConsumer.process((Object)element.getReference());
                            }
                        } else if (isVirtual) {
                            OCSymbol contextSymbol;
                            OCCallable context = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
                            if (context != null && (contextSymbol = context.getSymbol()) instanceof OCFunctionSymbol) {
                                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)contextSymbol;
                                boolean bl = isVirtual = !functionSymbol.isCppDestructor() && !functionSymbol.isCppConstructor();
                            }
                            if (isVirtual && symbol.getType().accept(visitor).booleanValue()) {
                                return this.myConsumer.process((Object)element.getReference());
                            }
                        }
                    }
                }
            }
            return true;
        }
    }
}

