/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCMethodReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    private final boolean myFindAllPotentialCalls;

    public OCMethodReferencesSearch() {
        this(false);
    }

    public OCMethodReferencesSearch(boolean findPotentialAllPotentialCalls) {
        this.myFindAllPotentialCalls = findPotentialAllPotentialCalls;
    }

    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)OCMethodReferencesSearch.this.doExecute(queryParameters, (Processor<PsiReference>)consumer2));
            }
        }.execute().getResultObject();
    }

    private Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer2) {
        String searchWord;
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCMethod)) {
            return true;
        }
        OCMethod method2 = (OCMethod)element;
        List<OCMethodSelectorPart> parts = method2.getParameters();
        String methodSelector = method2.getSelector();
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        if (parts.isEmpty()) {
            return true;
        }
        String firstSelector = parts.get(0).getSelectorPart();
        if (firstSelector == null) {
            return true;
        }
        String string = searchWord = firstSelector.endsWith(":") ? firstSelector.substring(0, firstSelector.length() - 1) : firstSelector;
        if (searchWord.isEmpty()) {
            return true;
        }
        if (!helper.processElementsWithWord((TextOccurenceProcessor)new MyOccurenceProcessor(method2, methodSelector, consumer2, false, this.myFindAllPotentialCalls), queryParameters.getEffectiveSearchScope(), searchWord, (short)1, true)) {
            return false;
        }
        String getterName = OCNameSuggester.getObjCGetterFromSetter(methodSelector);
        if (getterName != null && !getterName.isEmpty()) {
            return helper.processElementsWithWord((TextOccurenceProcessor)new MyOccurenceProcessor(method2, getterName, consumer2, true, this.myFindAllPotentialCalls), queryParameters.getEffectiveSearchScope(), getterName, (short)1, true);
        }
        return true;
    }

    private static class MyOccurenceProcessor
    implements TextOccurenceProcessor {
        private final OCMethod myMethod;
        private final OCMethodSymbol mySymbol;
        private final String myMethodSelector;
        private final OCObjectType myType;
        private final Processor<PsiReference> myConsumer;
        private final boolean myFindAllPotentialCalls;
        private final boolean mySetterMode;

        public MyOccurenceProcessor(OCMethod method2, String methodSelector, Processor<PsiReference> consumer2, boolean setterMode, boolean findAllPotentialCalls) {
            this.mySetterMode = setterMode;
            this.myMethodSelector = methodSelector;
            this.myMethod = method2;
            this.mySymbol = (OCMethodSymbol)method2.getSymbol();
            this.myConsumer = consumer2;
            this.myFindAllPotentialCalls = findAllPotentialCalls;
            OCClassDeclaration containingClass = method2.getContainingClass();
            this.myType = containingClass.getType();
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            String selector2 = null;
            if (element instanceof OCQualifiedExpression) {
                selector2 = ((OCQualifiedExpression)element).getName();
                OCExpression expression2 = OCParenthesesUtils.topmostParenthesized((OCExpression)element);
                if (expression2.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)expression2.getParent()).getReceiverExpression() == expression2 ? !this.mySetterMode : this.mySetterMode) {
                    return true;
                }
            } else if (this.mySetterMode) {
                return true;
            }
            if (element instanceof OCMessageArgument && offsetInElement == 0) {
                OCSendMessageExpression sendMessageExpression = (OCSendMessageExpression)element.getParent();
                if (sendMessageExpression.getArguments().get(0) == element) {
                    selector2 = sendMessageExpression.getMessageSelector();
                    element = sendMessageExpression;
                }
            } else if (element instanceof OCSelectorExpression) {
                selector2 = ((OCSelectorExpression)element).getSelector();
            } else if (element instanceof XmlTag) {
                selector2 = ((XmlTag)element).getValue().getText();
            } else if (element instanceof XmlAttributeValue) {
                selector2 = ((XmlAttributeValue)element).getValue();
            } else if (element.getParent() instanceof OCPropertyAttribute) {
                element = element.getParent();
                selector2 = ((OCPropertyAttribute)element).getValue();
            }
            if (this.myMethodSelector.equals(selector2)) {
                for (PsiReference ref : element.getReferences()) {
                    if (ref.isReferenceTo((PsiElement)this.myMethod)) {
                        return this.myConsumer.process((Object)ref);
                    }
                    OCObjectTypeContext receiverContext = null;
                    boolean isVirtualCall = true;
                    if (ref.getElement() instanceof OCSendMessageExpression) {
                        OCExpression receiver2 = OCParenthesesUtils.diveIntoParentheses(((OCSendMessageExpression)ref.getElement()).getReceiverExpression());
                        if (receiver2 instanceof OCReferenceExpression) {
                            isVirtualCall = ((OCReferenceExpression)receiver2).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF;
                        }
                        receiverContext = ((OCSendMessageExpression)ref.getElement()).getReceiverContext();
                    } else if (ref.getElement() instanceof OCQualifiedExpression) {
                        receiverContext = ((OCQualifiedExpression)ref.getElement()).getQualifier().getTypeContext();
                    }
                    if (receiverContext == null || this.myType == null || !receiverContext.fitsStaticness(this.mySymbol)) continue;
                    OCObjectType receiverType = receiverContext.getType();
                    if (this.myFindAllPotentialCalls && !isVirtualCall) {
                        if (!receiverType.equalsAfterResolving((OCType)this.myType, (PsiElement)element.getContainingFile())) continue;
                        this.myConsumer.process((Object)ref);
                        continue;
                    }
                    if ((!this.myFindAllPotentialCalls || !receiverType.isCompatible(this.myType, element)) && (this.myFindAllPotentialCalls || !this.myType.isCompatible(receiverType, element))) continue;
                    return this.myConsumer.process((Object)ref);
                }
            }
            return true;
        }
    }
}

