/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import org.jetbrains.annotations.NotNull;

public class OCPropertyReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)OCPropertyReferencesSearch.doExecute(queryParameters, (Processor<PsiReference>)consumer2));
            }
        }.execute().getResultObject();
    }

    private static Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer2) {
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (!(symbol instanceof OCPropertySymbol)) {
            return true;
        }
        OCPropertySymbol property = (OCPropertySymbol)symbol;
        return ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, method2 -> method2.getGeneratedFromProperty() != property || OCPropertyReferencesSearch.processMethod(queryParameters, method2, element, consumer2));
    }

    private static boolean processMethod(ReferencesSearch.SearchParameters queryParameters, OCMethodSymbol method2, final PsiElement declarator, final Processor<PsiReference> consumer2) {
        final String methodSelector = method2.getName();
        TextOccurenceProcessor processor2 = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                PsiReference ref;
                String selector2 = null;
                if (element instanceof OCSendMessageExpression) {
                    selector2 = ((OCSendMessageExpression)element).getMessageSelector();
                } else if (element instanceof OCSelectorExpression) {
                    selector2 = ((OCSelectorExpression)element).getSelector();
                } else if (element instanceof OCQualifiedExpression) {
                    selector2 = ((OCQualifiedExpression)element).getName();
                }
                if (methodSelector.equals(selector2) && (ref = element.getReference()) != null && ref.isReferenceTo(declarator)) {
                    return consumer2.process((Object)ref);
                }
                return true;
            }
        };
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)declarator.getProject());
        return helper.processElementsWithWord(processor2, queryParameters.getEffectiveSearchScope(), methodSelector, (short)1, true);
    }
}

