/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCConstructorInEmptyInitializationUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCExternalReferenceUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCPropertyAttributeUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorImplicitReferenceSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchUtil {
    @NotNull
    public static Collection<VirtualFile> getProjectVirtualFilesByName(@NotNull Project project2, @NotNull String name) {
        return FilenameIndex.getVirtualFilesByName(project2, name, SystemInfo.isFileSystemCaseSensitive, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getProjectOCFilesByName(@NotNull Project project2, @NotNull String name) {
        return OCSearchUtil.getOCFilesByName(project2, name, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getOCFilesByName(@NotNull Project project2, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return ContainerUtil.filter((Object[])FilenameIndex.getFilesByName(project2, name, scope), (Condition)new FilteringIterator.InstanceOf(OCFile.class));
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(T member, Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors) {
        return OCSearchUtil.processMembersHierarchy(member, processor2, searchAncestors, searchInheritors, true);
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(T member, Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, boolean includeSameSymbols) {
        Object parameters2;
        if (member instanceof OCFunctionSymbol && searchInheritors) {
            parameters2 = OCFunctionInheritorsSearch.getParameters((OCFunctionSymbol)member, member.getContainingOCFile(), true);
            ((OCFunctionInheritorsSearch.SearchParameters)parameters2).setIncludeSameSymbols(includeSameSymbols);
            if (!OCFunctionInheritorsSearch.search((OCFunctionInheritorsSearch.SearchParameters)parameters2).forEach(processor2)) {
                return false;
            }
        }
        if (member instanceof OCFunctionSymbol && searchAncestors && !new OCFunctionAncestorsQuery((OCFunctionSymbol)member, true, includeSameSymbols).forEach(processor2)) {
            return false;
        }
        if (member instanceof OCMemberSymbol) {
            parameters2 = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)member);
            ((OCMemberInheritorsSearch.SearchParameters)parameters2).setIncludeSelfImplementation(includeSameSymbols);
            ((OCMemberInheritorsSearch.SearchParameters)parameters2).setInheritors(searchInheritors);
            ((OCMemberInheritorsSearch.SearchParameters)parameters2).setAncestors(searchAncestors);
            if (!OCMemberInheritorsSearch.search(parameters2).forEach(processor2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processMembersHierarchyPsi(OCSymbolWithParent member, Processor<PsiElement> processor2, boolean searchAncestors, boolean searchInheritors) {
        return OCSearchUtil.processMembersHierarchy(member, symbol -> {
            Object overridingMethod = symbol.locateDefinition();
            if (overridingMethod instanceof OCDeclarator) {
                overridingMethod = overridingMethod.getParent();
            }
            if (overridingMethod != null) {
                return processor2.process(overridingMethod);
            }
            return true;
        }, searchAncestors, searchInheritors);
    }

    @Nullable
    public static Ancestor findSomeAncestor(OCSymbolWithParent member) {
        Ancestor result2 = new Ancestor();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            result2.symbol = symbol;
            if (!OCSearchScope.isInProjectSources(symbol)) {
                result2.isOutOfProject = true;
                return false;
            }
            return true;
        }, true, false, false);
        return result2.getSymbol() != null ? result2 : null;
    }

    public static boolean processMemberAncestors(OCSymbolWithParent member, Processor<? super OCSymbolWithParent> processor2, boolean onlyDeclarations) {
        return OCSearchUtil.processMembersHierarchy(member, ancestor -> {
            if (onlyDeclarations && ancestor.isDefinition() && ancestor.getFirstPredeclaration() != null || ancestor.equals(member)) {
                return true;
            }
            return processor2.process(ancestor);
        }, true, false, true);
    }

    public static boolean findAllMemberUsages(OCSymbolWithParent member, Set<UsageInfo> result2, boolean searchInheritors, boolean searchAncestors) {
        return OCSearchUtil.processMembersHierarchyPsi(member, (Processor<PsiElement>)((Processor)element -> {
            OCSearchUtil.findOneMethodUsages(element, result2);
            return true;
        }), searchAncestors, searchInheritors);
    }

    public static void findOneMethodUsages(PsiElement method2, Set<UsageInfo> result2) {
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(method2.getProject());
        if (method2 instanceof OCFunctionDeclaration) {
            OCDeclarator declarator = ((OCFunctionDeclaration)method2).getDeclarator();
            if (declarator != null) {
                for (PsiReference ref : ReferencesSearch.search((PsiElement)declarator, (SearchScope)scope).findAll()) {
                    if (ref.getElement() == null || !((Object)((Object)OCLanguage.getInstance())).equals(ref.getElement().getLanguage())) continue;
                    result2.add(new OCFunctionUsage(ref));
                }
                for (PsiReference ref : OCConstructorImplicitReferenceSearch.search(declarator, (SearchScope)scope)) {
                    result2.add(new OCConstructorInEmptyInitializationUsage((OCBaseConstructorReference)ref));
                }
            }
        } else if (method2 instanceof OCMethod) {
            Processor consumer2 = psiReference -> {
                if (psiReference instanceof OCExternalReference) {
                    result2.add(new OCExternalReferenceUsage((OCExternalReference)psiReference));
                    return true;
                }
                PsiElement element = psiReference.getElement();
                if (element instanceof OCSendMessageExpression) {
                    result2.add(new OCMethodCallUsage((PsiReference)psiReference));
                } else if (element instanceof OCSelectorExpression) {
                    result2.add(new OCSelectorExpressionUsage((PsiReference)psiReference));
                } else if (element instanceof OCPropertyAttribute) {
                    result2.add(new OCPropertyAttributeUsage((PsiReference)psiReference));
                } else if (element instanceof OCQualifiedExpression) {
                    result2.add(new OCMethodDotCallUsage((PsiReference)psiReference));
                }
                return true;
            };
            ReferencesSearch.search((PsiElement)method2, (SearchScope)scope, (boolean)false).forEach(consumer2);
        }
    }

    public static boolean hasRelatedSymbols(@NotNull OCStructSymbol symbol) {
        Ref result2 = Ref.create((Object)false);
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (s instanceof OCStructSymbol && !s.isPredeclaration() && !symbol.equals(s)) {
                result2.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)result2.get();
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol) {
        return OCSearchUtil.getRelatedSymbols(symbol, false);
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, boolean excludeProcessingSymbol) {
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (excludeProcessingSymbol && symbol.equals(s)) {
                return true;
            }
            if (s instanceof OCStructSymbol && !s.isPredeclaration()) {
                if (((OCStructSymbol)s).isSpecialization()) {
                    if (!s.isPredeclaration()) {
                        result2.add((OCSymbol)s);
                    }
                } else {
                    result2.add(0, (OCSymbol)s);
                }
            }
            return true;
        }));
        return result2;
    }

    public static class Ancestor {
        OCSymbolWithParent symbol;
        boolean isOutOfProject;

        public OCSymbolWithParent getSymbol() {
            return this.symbol;
        }

        public boolean isOutOfProject() {
            return this.isOutOfProject;
        }
    }
}

