/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseConstructorReference
implements PsiReference {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final OCSymbolDeclarator myField;
    @NotNull
    protected final OCFunctionSymbol myTargetConstructor;

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCSymbolDeclarator field, @NotNull OCFunctionSymbol targetConstructor) {
        this.myElement = element;
        this.myField = field;
        this.myTargetConstructor = targetConstructor;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public PsiElement resolve() {
        return this.myTargetConstructor.locateDefinition();
    }

    @NotNull
    public OCFunctionSymbol getTargetConstructor() {
        return this.myTargetConstructor;
    }

    @NotNull
    public OCSymbolDeclarator getField() {
        return this.myField;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myElement.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCSymbol symbol = ((OCFunctionDeclaration)element).getSymbol();
        if (Comparing.equal((Object)this.myTargetConstructor, (Object)symbol)) {
            return true;
        }
        if (symbol != null && symbol.isGlobal()) {
            OCQualifiedName symbolName;
            OCQualifiedName thisName = this.myTargetConstructor.getResolvedQualifiedName();
            if (Comparing.equal((Object)thisName, (Object)(symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName()))) {
                OCType symbolType;
                OCType thisResolvedType;
                return !(symbol instanceof OCFunctionSymbol) || (thisResolvedType = this.myTargetConstructor.getResolvedType()).equals((Object)(symbolType = symbol.getResolvedType()), element);
            }
            return false;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        return new Object[0];
    }

    public boolean isSoft() {
        return false;
    }
}

