/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCConstructorReferenceSearchBase
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer2) {
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)OCConstructorReferenceSearchBase.this.doExecute(queryParameters, (Processor<PsiReference>)consumer2));
            }
        }.execute().getResultObject();
    }

    private Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer2) {
        OCFunctionSymbol constructorPredefinition;
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element.getParent() instanceof OCFunctionDefinition)) {
            return true;
        }
        final OCFunctionDeclaration constructor = (OCFunctionDeclaration)element.getParent();
        OCSymbolWithQualifiedName constructorSymbol = (OCSymbolWithQualifiedName)constructor.getSymbol();
        if (!(constructorSymbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
            return true;
        }
        OCFunctionSymbol predefinition = (OCFunctionSymbol)constructorSymbol.getFirstPredeclaration();
        OCFunctionSymbol oCFunctionSymbol = constructorPredefinition = predefinition != null ? predefinition : (OCFunctionSymbol)constructorSymbol;
        if (!(constructorPredefinition.getParent() instanceof OCStructSymbol)) {
            return true;
        }
        OCStructSymbol structSymbol = (OCStructSymbol)constructorPredefinition.getParent();
        final OCStructType structType = structSymbol.getType();
        final CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
        constructors.process((Object)structSymbol);
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)constructors);
        final SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        TextOccurenceProcessor processor2 = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                PsiElement parent = element.getParent();
                if (parent instanceof OCTypeElement && parent.getContext() instanceof OCDeclaration) {
                    OCDeclaration declaration2 = (OCDeclaration)parent.getContext();
                    if (PsiTreeUtil.getContextOfType((PsiElement)declaration2, (Class[])new Class[]{OCParameterList.class}) != null) {
                        return true;
                    }
                    if (declaration2.getParent() instanceof OCStruct) {
                        OCStructSymbol symbol = (OCStructSymbol)((OCStruct)declaration2.getParent()).getSymbol();
                        for (OCDeclarator declarator : declaration2.getDeclarators()) {
                            if (!declarator.getType().resolve(element.getContainingFile()).equals((Object)structType, declaration2)) {
                                return true;
                            }
                            if (OCConstructorReferenceSearchBase.this.processStructFieldInitializers(symbol, declarator, structType, constructorPredefinition, constructors.getResults(), (Processor<PsiReference>)consumer2, searchScope)) continue;
                            OCConstructorReferenceSearchBase.this.onReferenceFromStruct((OCStruct)declaration2.getParent(), declarator, constructorPredefinition, (Processor<PsiReference>)consumer2);
                        }
                        return true;
                    }
                    for (OCDeclarator declarator : declaration2.getDeclarators()) {
                        if (declarator.getInitializer() != null) continue;
                        for (PsiReference ref : declarator.getReferences()) {
                            if (!ref.isReferenceTo((PsiElement)constructor) || OCConstructorReferenceSearchBase.this.onReferenceFromDeclarator(declarator, constructorPredefinition, (Processor<PsiReference>)consumer2)) continue;
                            return false;
                        }
                    }
                } else if (parent instanceof OCCppBaseClause) {
                    OCStructSymbol symbol;
                    OCStruct struct = (OCStruct)parent.getContext().getContext();
                    OCStructSymbol oCStructSymbol = symbol = struct != null ? (OCStructSymbol)struct.getSymbol() : null;
                    if (symbol != null && !OCConstructorReferenceSearchBase.this.processStructFieldInitializers(symbol, constructor, structType, constructorPredefinition, constructors.getResults(), (Processor<PsiReference>)consumer2, searchScope)) {
                        OCConstructorReferenceSearchBase.this.onReferenceFromStruct(struct, constructor, constructorPredefinition, (Processor<PsiReference>)consumer2);
                    }
                }
                return true;
            }
        };
        String searchWord = constructor.getName();
        if (searchWord == null) {
            return true;
        }
        return helper.processElementsWithWord(processor2, searchScope, searchWord, (short)1, true);
    }

    private boolean processStructFieldInitializers(@Nullable OCStructSymbol symbol, OCSymbolDeclarator member, OCStructType constructorOwner, OCFunctionSymbol constructor, Collection<OCSymbol> constructors, Processor<PsiReference> consumer2, SearchScope searchScope) {
        if (symbol == null) {
            return false;
        }
        Ref hasConstructors = new Ref((Object)false);
        OCResolveContext context = new OCResolveContext(member);
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)symbol1 -> {
            hasConstructors.set((Object)true);
            if (symbol1.getKind().isConstructorOrDestructor() && !symbol1.isPredeclaration()) {
                Object psiElement = symbol1.locateDefinition();
                if (!(psiElement instanceof OCDeclarator)) {
                    return true;
                }
                OCFunctionDefinition definition = (OCFunctionDefinition)psiElement.getParent();
                OCConstructorInitializationList initializationList = definition.getConstructorInitializationList();
                boolean found = false;
                if (initializationList != null) {
                    if (!OCConstructorReferenceSearchBase.isInScope(searchScope, initializationList)) {
                        return true;
                    }
                    for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                        OCReferenceElement field = initializer.getReferenceElement();
                        if (field == null || !field.getReference().isReferenceTo((PsiElement)member)) continue;
                        if (member instanceof OCFunctionDefinition) {
                            found = true;
                            break;
                        }
                        OCSymbol fieldSymbol = field.resolveToSymbol();
                        if (fieldSymbol == null || !constructorOwner.equals((Object)fieldSymbol.getResolvedType(), member)) continue;
                        OCResolveContext context1 = new OCResolveContext(field);
                        OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(initializer.getInitializers());
                        OCSymbol resolved = OCResolveOverloadsUtil.resolveOverloads(constructors, argumentsList, null, null, null, false, false, false, true, false, context1);
                        if (!Comparing.equal((Object)resolved, (Object)constructor)) continue;
                        found = true;
                        this.onReferenceFromInitializer(initializer, member, constructor, consumer2);
                        break;
                    }
                }
                if (!found && constructor.getNonInitializedParametersCount(context) == 0) {
                    this.onReferenceFromOtherConstructor(definition, member, constructor, consumer2);
                }
            }
            return true;
        }), true);
        return (Boolean)hasConstructors.get();
    }

    private static boolean isInScope(SearchScope scope, PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (scope instanceof GlobalSearchScope) {
            return scope.contains(file2.getVirtualFile());
        }
        if (scope instanceof LocalSearchScope) {
            return ((LocalSearchScope)scope).containsRange(file2, element.getTextRange());
        }
        return false;
    }

    protected abstract boolean onReferenceFromInitializer(OCConstructorFieldInitializer var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromOtherConstructor(OCFunctionDefinition var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromStruct(OCStruct var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromDeclarator(OCDeclarator var1, OCFunctionSymbol var2, Processor<PsiReference> var3);
}

