/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesDialog;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesOptions;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFindUsagesHandler
extends FindUsagesHandler {
    private boolean myDeleteMode;

    public OCFindUsagesHandler(@NotNull PsiElement psiElement) {
        super(psiElement);
    }

    public OCFindUsagesHandler(@NotNull PsiElement psiElement, boolean isDeleteMode) {
        super(psiElement);
        this.myDeleteMode = isDeleteMode;
    }

    private String getActionName() {
        return this.myDeleteMode ? "delete" : "find usages of";
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        OCSymbol symbol;
        PsiElement element = this.getPsiElement();
        if (element instanceof OCFile) {
            symbol = ((OCFile)element).getSameNamedClass();
        } else if (element instanceof OCSymbolDeclarator) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        } else {
            return super.getPrimaryElements();
        }
        HashSet result2 = new HashSet();
        CommonProcessors.CollectProcessor psiCollector = new CommonProcessors.CollectProcessor((Collection)result2);
        Processor collector = symbol1 -> {
            OCFindUsagesHandler.processSymbol(symbol1, (Processor<PsiElement>)psiCollector);
            return true;
        };
        if (symbol instanceof OCSymbolWithParent) {
            OCSearchUtil.Ancestor ancestor = OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol);
            if (ancestor != null) {
                int code2;
                String subject = symbol.getKind().getNameLowercase();
                String message2 = symbol.getNameWithKindUppercase() + " overrides " + subject + " in " + ancestor.getSymbol().getParent().getNameWithKindLowercase() + (ancestor.isOutOfProject() ? " which is out of project" : "");
                if (this.myDeleteMode && ancestor.isOutOfProject()) {
                    code2 = Messages.showYesNoDialog((Project)this.getProject(), (String)(message2 + ". Do you want to proceed the refactoring?"), (String)"Warning", (Icon)Messages.getQuestionIcon());
                    if (code2 != 0) {
                        return PsiElement.EMPTY_ARRAY;
                    }
                } else {
                    code2 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((String)(message2 + "\n\nDo you want to " + this.getActionName() + " the base " + subject + "?"), (String)"Method search", (Icon)Messages.getQuestionIcon());
                    if (code2 == 0) {
                        OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)collector, !this.myDeleteMode);
                    } else {
                        result2.add(element);
                    }
                }
            } else {
                result2.add(element);
            }
            if (this.myDeleteMode) {
                boolean isGeneratedFromProperty = false;
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method2 = (OCMethodSymbol)symbol;
                    OCMethodSymbol associatedSymbol = method2.getAssociatedSymbol();
                    boolean bl = isGeneratedFromProperty = associatedSymbol != null && associatedSymbol.getGeneratedFromProperty() != null;
                }
                if (!isGeneratedFromProperty) {
                    OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, collector, false, true, true);
                }
            }
        } else if (symbol != null) {
            if (this.myDeleteMode) {
                if (element instanceof OCMethodSelectorPart) {
                    psiCollector.process((Object)element);
                } else {
                    symbol.processSameSymbols((Processor<OCSymbol>)collector);
                }
            } else {
                psiCollector.process((Object)element);
            }
        }
        if (symbol != null) {
            symbol = symbol.getDefinitionSymbol();
            if (this.myDeleteMode && symbol instanceof OCClassSymbol) {
                result2.clear();
                String categoryName = ((OCClassSymbol)symbol).getCategoryName();
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)arg_0 -> OCFindUsagesHandler.lambda$getPrimaryElements$1(categoryName, (Set)result2, psiCollector, arg_0)));
            }
            if (result2.isEmpty()) {
                result2.add(element);
            }
            return PsiUtilCore.toPsiElementArray((Collection)result2);
        }
        return super.getPrimaryElements();
    }

    void processSecondaryElements(AssociatedElementProcessor processor2) {
        block15: {
            Object symbol;
            PsiElement element;
            block14: {
                element = this.getPsiElement();
                if (!(element instanceof OCSymbolDeclarator)) {
                    return;
                }
                symbol = ((OCSymbolDeclarator)element).getSymbol();
                if (!(symbol instanceof OCInstanceVariableSymbol)) break block14;
                OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
                if (property == null) break block15;
                if (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar()) {
                    processor2.process(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol));
                }
                if (processor2.proceedProperty(property)) {
                    OCFindUsagesHandler.processSymbol(property, processor2);
                    this.processSynthesizes(property, processor2);
                }
                break block15;
            }
            if (symbol instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar();
                if (ivar != null) {
                    if (ivar.isClang4ImplicitIvar()) {
                        processor2.process(new OCSymbolHolderVirtualPsiElement(ivar));
                    } else if (processor2.proceedIvar(ivar)) {
                        OCFindUsagesHandler.processSymbol(ivar, processor2);
                    }
                }
                this.processSynthesizes((OCPropertySymbol)symbol, processor2);
            } else if (symbol instanceof OCClassSymbol && processor2.proceedDerivedClasses()) {
                for (OCClassSymbol clazz : OCClassInheritorsSearch.search((OCClassSymbol)symbol).findAll()) {
                    OCFindUsagesHandler.processSymbol(clazz, processor2);
                }
            } else if (symbol instanceof OCStructSymbol && ((OCElement)element).getContainingOCFile().isCpp() && processor2.proceedDerivedClasses()) {
                for (OCStructSymbol struct : OCStructInheritorsSearch.search((OCStructSymbol)symbol, element).findAll()) {
                    OCFindUsagesHandler.processSymbol(struct, processor2);
                }
            }
        }
    }

    private void processSynthesizes(OCPropertySymbol symbol, Processor<PsiElement> processor2) {
        if (this.myDeleteMode) {
            symbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)symbol1 -> {
                OCFindUsagesHandler.processSymbol(symbol1, processor2);
                return true;
            }));
        }
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        HashSet result2 = new HashSet();
        if (this.myDeleteMode) {
            this.processSecondaryElements(new AssociatedElementProcessor((Set)result2){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set2;
                }

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    String message2 = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + property.getNameWithKindLowercase() + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message2, (String)"Properties search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    if (ivar.getGeneratedFromProperty() != null) {
                        return true;
                    }
                    String message2 = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + ivar.getNameWithKindLowercase() + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message2, (String)"Instance variables search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return false;
                }

                public boolean process(PsiElement element) {
                    this.val$result.add(element);
                    return true;
                }
            });
        } else {
            final OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.getProject());
            this.processSecondaryElements(new AssociatedElementProcessor((Set)result2){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set2;
                }

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    return options.isSearchForProperties;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    return options.isSearchForIvars;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return options.isSearchForDerivedClasses;
                }

                public boolean process(PsiElement element) {
                    this.val$result.add(element);
                    return true;
                }
            });
        }
        return PsiUtilCore.toPsiElementArray((Collection)result2);
    }

    private static void processSymbol(OCSymbol symbol, Processor<PsiElement> processor2) {
        if (symbol == null) {
            return;
        }
        Object def = symbol.locateDefinition();
        if (def != null) {
            processor2.process(def);
        }
    }

    @Override
    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        Object symbol;
        if (isSingleFile) {
            return false;
        }
        return !(psiElement instanceof OCSymbolDeclarator) || (symbol = ((OCSymbolDeclarator)psiElement).getSymbol()) == null || !symbol.getKind().isLocal();
    }

    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        return OCFindUsagesOptions.getInstance(this.getProject());
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        return new OCFindUsagesDialog(this.getPsiElement(), this.getProject(), OCFindUsagesOptions.getInstance(this.getProject()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
    }

    private static /* synthetic */ boolean lambda$getPrimaryElements$1(String categoryName, Set result2, CommonProcessors.CollectProcessor psiCollector, OCSymbol curSymbol) {
        if (categoryName != null && !categoryName.equals(((OCClassSymbol)curSymbol).getCategoryName())) {
            return true;
        }
        OCFile file2 = curSymbol.getContainingOCFile();
        if (file2 != null && curSymbol.equals(file2.getSameNamedClass()) && !file2.hasExtraTopLevelDefinitions()) {
            result2.add(file2);
        } else if (!result2.contains(file2)) {
            OCFindUsagesHandler.processSymbol(curSymbol, (Processor<PsiElement>)psiCollector);
        }
        return true;
    }

    static interface AssociatedElementProcessor
    extends Processor<PsiElement> {
        public boolean proceedProperty(OCPropertySymbol var1);

        public boolean proceedIvar(OCInstanceVariableSymbol var1);

        public boolean proceedDerivedClasses();
    }
}

