/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        return element instanceof OCDeclarator || element instanceof OCMethodSelectorPart || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        return element instanceof OCDeclarator && (((OCDeclarator)element).getInitializer() != null || element.getParent().getParent() instanceof OCForeachStatement);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression2) {
        if (expression2 instanceof OCReferenceElement || expression2 instanceof OCReferenceExpression || expression2 instanceof OCQualifiedExpression || expression2 instanceof OCArraySelectionExpression || expression2 instanceof OCUnaryExpression && ((OCUnaryExpression)expression2).getOperationSign() == OCTokenTypes.MUL) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{OCReferenceExpression.class, OCParenthesizedExpression.class});
            OCElementType operator2 = null;
            if (parent instanceof OCAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((OCAssignmentExpression)parent).getReceiverExpression(), (PsiElement)expression2, (boolean)false)) {
                return ((OCAssignmentExpression)parent).getOperationSign() == OCTokenTypes.EQ ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.ReadWrite;
            }
            if (parent instanceof OCPrefixExpression) {
                operator2 = ((OCPrefixExpression)parent).getOperationSign();
            } else if (parent instanceof OCPostfixExpression) {
                operator2 = ((OCPostfixExpression)parent).getOperationSign();
            }
            return operator2 == OCTokenTypes.PLUSPLUS || operator2 == OCTokenTypes.MINUSMINUS ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
        }
        if (expression2 instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)expression2).getMessageSelector().endsWith(":") ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        return ReadWriteAccessDetector.Access.Read;
    }

    public boolean canBeConstReference(PsiElement expression2, boolean checkPointerType) {
        OCType receiverType;
        OCType expectedType;
        PsiElement parent = expression2.getParent();
        if (expression2 instanceof OCReferenceElement) {
            expression2 = parent;
            parent = expression2.getParent();
        }
        if (parent instanceof OCQualifiedExpression) {
            OCSymbol function;
            if (OCParenthesesUtils.topmostParenthesized((OCExpression)parent).getParent() instanceof OCCallExpression && (function = ((OCQualifiedExpression)parent).resolveToSymbol()) instanceof OCFunctionSymbol && !((OCFunctionSymbol)function).isConst() && !((OCFunctionSymbol)function).resolveIsStatic()) {
                return false;
            }
            if (this.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
                return false;
            }
        }
        if (expression2 instanceof OCExpression && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)expression2)) instanceof OCCppReferenceType && !((OCCppReferenceType)expectedType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getSourceExpression() == expression2 && (receiverType = ((OCAssignmentExpression)parent).getReceiverExpression().getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCDeclarator && (receiverType = ((OCDeclarator)parent).getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        return !(parent instanceof OCUnaryExpression) || ((OCUnaryExpression)parent).getOperationSign() != OCTokenTypes.MUL || this.getExpressionAccess(parent) == ReadWriteAccessDetector.Access.Read;
    }
}

