/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages.rules;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCGroupRuleProviderBase<T extends OCElement>
implements FileStructureGroupRuleProvider {
    OCGroupRuleProviderBase() {
    }

    @Nullable
    public UsageGroupingRule getUsageGroupingRule(Project project2) {
        return new UsageGroupingRule(){

            @Nullable
            public UsageGroup groupUsage(@NotNull Usage usage) {
                if (usage instanceof PsiElementUsage) {
                    PsiElement psiElement = ((PsiElementUsage)usage).getElement();
                    if (!psiElement.getLanguage().isKindOf((Language)OCLanguage.getInstance())) {
                        return null;
                    }
                    return OCGroupRuleProviderBase.this.createUsageGroupForElement(psiElement);
                }
                return null;
            }
        };
    }

    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        OCElement element = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, this.getUsageClass());
        if (this.isAcceptableElement(element)) {
            return this.createUsageGroup(element);
        }
        return null;
    }

    protected boolean isAcceptableElement(OCElement element) {
        return element != null;
    }

    protected abstract Class<? extends OCElement> getUsageClass();

    protected abstract UsageGroup createUsageGroup(T var1);
}

